// (c) Microsoft Corporation 2005-2007. 

namespace System
    open Microsoft.FSharp.Core
    
    #if CLI_AT_MOST_1_1
    type Converter            = delegate of obj -> obj
    #else 
    type Action<'A1,'A2>                   = delegate of 'A1 * 'A2 -> unit
    type Action<'A1,'A2,'A3>               = delegate of 'A1 * 'A2 * 'A3 -> unit
    type Action<'A1,'A2,'A3,'A4>           = delegate of 'A1 * 'A2 * 'A3 * 'A4 -> unit
    type Action<'A1,'A2,'A3,'A4,'A5>       = delegate of 'A1 * 'A2 * 'A3 * 'A4 * 'A5 -> unit
    type Converter<'A1,'A2,'B>             = delegate of 'A1 * 'A2 -> 'B
    type Converter<'A1,'A2,'A3,'B>         = delegate of 'A1 * 'A2 * 'A3 -> 'B
    type Converter<'A1,'A2,'A3,'A4,'B>     = delegate of 'A1 * 'A2 * 'A3 * 'A4 -> 'B
    type Converter<'A1,'A2,'A3,'A4,'A5,'B> = delegate of 'A1 * 'A2 * 'A3 * 'A4 * 'A5 -> 'B
    #endif

namespace Microsoft.FSharp.Core
    open Microsoft.FSharp.Core
    open Microsoft.FSharp.Primitives.Basics
    open Microsoft.FSharp.Core.Operators
    open System

    type FuncConvert = 
    #if CLI_AT_MOST_1_1
        [<OverloadID("Converter1")>]
        static member  ToFastFunc : Converter -> ('a -> 'b)
    #else
        [<OverloadID("Action1")>]
        static member  ToFastFunc       : Action<'a>            -> ('a -> unit)
        
        [<OverloadID("Converter1")>]
        static member  ToFastFunc       : Converter<'a,'b>          -> ('a -> 'b)
        
        [<OverloadID("Action2")>]
        static member  ToFastFunc       : Action<'a1,'a2>           -> ('a1 -> 'a2 -> unit)
        
        [<OverloadID("Converter2")>]
        static member  ToFastFunc       : Converter<'a1,'a2,'b>     -> ('a1 -> 'a2 -> 'b)
        
        [<OverloadID("Action3")>]
        static member  ToFastFunc       : Action<'a1,'a2,'a3>       -> ('a1 -> 'a2 -> 'a3 -> unit)
        
        
        [<OverloadID("Converter3")>]
        static member  ToFastFunc       : Converter<'a1,'a2,'a3,'b> -> ('a1 -> 'a2 -> 'a3 -> 'b)
        
        [<OverloadID("Action2")>]
        static member  ToTupledFastFunc : Action<'a1,'a2>           -> ('a1 * 'a2 -> unit)
        
        [<OverloadID("Converter2")>]
        static member  ToTupledFastFunc : Converter<'a1,'a2,'b>     -> ('a1 * 'a2 -> 'b)
        
        [<OverloadID("Action3")>]
        static member  ToTupledFastFunc : Action<'a1,'a2,'a3>       -> ('a1 * 'a2 * 'a3 -> unit)
        
        [<OverloadID("Converter3")>]
        static member  ToTupledFastFunc : Converter<'a1,'a2,'a3,'b> -> ('a1 * 'a2 * 'a3 -> 'b)
    #endif

    #if CLI_AT_LEAST_2_0
        // Used by CodeDOM provider when calling delegate with "tupled" function as an argument
        // (which is required because member methods must take tuple as an argument in CodeDOM)
        
        [<OverloadID("FuncFromTupled1")>]
        static member FuncFromTupled : ('a -> 'b) -> ('a -> 'b)
        
        [<OverloadID("FuncFromTupled2")>]
        static member FuncFromTupled : ('a * 'b -> 'c) -> ('a -> 'b -> 'c)
        
        [<OverloadID("FuncFromTupled3")>]
        static member FuncFromTupled : ('a * 'b * 'c -> 'd) -> ('a -> 'b -> 'c -> 'd)
        
        [<OverloadID("FuncFromTupled4")>]
        static member FuncFromTupled : ('a * 'b * 'c * 'd -> 'e) -> ('a -> 'b -> 'c -> 'd -> 'e)
        
        [<OverloadID("FuncFromTupled5")>]
        static member FuncFromTupled : ('a * 'b * 'c * 'd * 'e -> 'f) -> ('a -> 'b -> 'c -> 'd -> 'e -> 'f)
    #endif
