// (c) Microsoft Corporation 2005-2007. 

#light

/// Functions to make F# math-related code look similar to code in other systems
namespace Microsoft.FSharp.Compatibility

open Microsoft.FSharp.Core
open Microsoft.FSharp.Collections
open Microsoft.FSharp.Math

/// Functions to make F# math-related code look a bit like MATLAB (TM) code.
module MATLAB =

    /// Create a matrix containing the given vector along the nth diagonal.
    /// The 0th index is the main diagonal, and higher indexes are further to the upper-right of the matrix.
    /// The element type of the matrix must have an associated instance of INumeric&lt;'a&gt; (see [[GlobalAssociations]]) (else InvalidArgumentException).
#if CLI_AT_LEAST_2_0
    val diagn     : Vector<'a> -> int -> Matrix<'a>
#else
    val diagn     : vector -> int -> matrix
#endif
  
    /// The upper triangular part of a matrix.  Positive offsets indicate further into upper
    /// upper-right triangular region.  The 0th index inculdes the main diagonal.
#if CLI_AT_LEAST_2_0
    val triun     : Matrix<'a> -> int -> Matrix<'a>
#else
    val triun     : matrix -> int -> matrix
#endif
 
    /// The upper triangular part of a matrix including the main diagonal
#if CLI_AT_LEAST_2_0
    val triu      : Matrix<'a>        -> Matrix<'a>
#else
    val triu      : matrix        -> matrix
#endif
  
    /// The lower triangular part of a matrix.  Positive offsets indicate further into upper
    /// upper-right triangular region.  The 0th index inculdes the main diagonal.
#if CLI_AT_LEAST_2_0
    val triln     : Matrix<'a> -> int -> Matrix<'a>
#else
    val triln     : matrix -> int -> matrix
#endif

    /// The lower triangular part of a matrix including the main diagonal
#if CLI_AT_LEAST_2_0
    val tril      : Matrix<'a>        -> Matrix<'a>
#else
    val tril      : matrix        -> matrix
#endif

  
