(*==========================================================================
 * (c) Microsoft Corporation 2005-2007. The interface to the module 
 * is similar to that found in versions of other ML implementations, 
 * but is not an exact match.
 *=========================================================================*)

module Microsoft.FSharp.Compatibility.OCaml.Printexc
open Microsoft.FSharp.Compatibility.OCaml
open Microsoft.FSharp.Compatibility.OCaml.Pervasives

let to_string (e:exn) = 
  match e with 
  | Failure s -> s
  | InvalidArgument s -> "invalid argument: "^s
  | Match_failure(s,n,m) -> "match failure, file '"^s^"', line "^string_of_int n^", column "^string_of_int m
  | _ -> any_to_string e^"\n"

let print f x = try f x with e -> prerr_endline (to_string e) ; raise e 
