/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.decompiled;

import java.lang.reflect.Modifier;
import java.util.List;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.MixinNode;
import org.codehaus.groovy.ast.decompiled.AnnotationStub;
import org.codehaus.groovy.ast.decompiled.Annotations;
import org.codehaus.groovy.ast.decompiled.AsmReferenceResolver;
import org.codehaus.groovy.ast.decompiled.ClassSignatureParser;
import org.codehaus.groovy.ast.decompiled.ClassStub;
import org.codehaus.groovy.ast.decompiled.FieldStub;
import org.codehaus.groovy.ast.decompiled.MemberSignatureParser;
import org.codehaus.groovy.ast.decompiled.MemberStub;
import org.codehaus.groovy.ast.decompiled.MethodStub;
import org.codehaus.groovy.classgen.Verifier;

public class DecompiledClassNode
extends ClassNode {
    private final ClassStub classData;
    private final AsmReferenceResolver resolver;
    private boolean supersInitialized = false;
    private boolean membersInitialized = false;

    public DecompiledClassNode(ClassStub data, AsmReferenceResolver resolver) {
        super(data.className, DecompiledClassNode.getFullModifiers(data, resolver), null, null, MixinNode.EMPTY_ARRAY);
        this.classData = data;
        this.resolver = resolver;
        this.isPrimaryNode = false;
    }

    private static int getFullModifiers(ClassStub data, AsmReferenceResolver resolver) {
        String className = data.className;
        int bound = className.length();
        while (bound > 0) {
            Integer outerModifiers;
            ClassNode outerClass;
            int idx = className.lastIndexOf(36, bound);
            if (idx > 0 && (outerClass = resolver.resolveClassNullable(className.substring(0, idx))) instanceof DecompiledClassNode && (outerModifiers = ((DecompiledClassNode)outerClass).classData.innerClassModifiers.get(className.substring(idx + 1))) != null) {
                return data.accessModifiers | outerModifiers;
            }
            bound = idx - 1;
        }
        return data.accessModifiers;
    }

    public long getCompilationTimeStamp() {
        if (this.classData.fields != null) {
            for (FieldStub field : this.classData.fields) {
                Long timestamp;
                if (!Modifier.isStatic(field.accessModifiers) || (timestamp = Verifier.getTimestampFromFieldName(field.fieldName)) == null) continue;
                return timestamp;
            }
        }
        return Long.MAX_VALUE;
    }

    @Override
    public GenericsType[] getGenericsTypes() {
        this.lazyInitSupers();
        return super.getGenericsTypes();
    }

    @Override
    public boolean isUsingGenerics() {
        this.lazyInitSupers();
        return super.isUsingGenerics();
    }

    @Override
    public List<FieldNode> getFields() {
        this.lazyInitMembers();
        return super.getFields();
    }

    @Override
    public ClassNode[] getInterfaces() {
        this.lazyInitSupers();
        return super.getInterfaces();
    }

    @Override
    public List<MethodNode> getMethods() {
        this.lazyInitMembers();
        return super.getMethods();
    }

    @Override
    public List<ConstructorNode> getDeclaredConstructors() {
        this.lazyInitMembers();
        return super.getDeclaredConstructors();
    }

    @Override
    public FieldNode getDeclaredField(String name) {
        this.lazyInitMembers();
        return super.getDeclaredField(name);
    }

    @Override
    public List<MethodNode> getDeclaredMethods(String name) {
        this.lazyInitMembers();
        return super.getDeclaredMethods(name);
    }

    @Override
    public ClassNode getUnresolvedSuperClass(boolean useRedirect) {
        this.lazyInitSupers();
        return super.getUnresolvedSuperClass(useRedirect);
    }

    @Override
    public ClassNode[] getUnresolvedInterfaces(boolean useRedirect) {
        this.lazyInitSupers();
        return super.getUnresolvedInterfaces(useRedirect);
    }

    @Override
    public List<AnnotationNode> getAnnotations() {
        this.lazyInitSupers();
        return super.getAnnotations();
    }

    @Override
    public List<AnnotationNode> getAnnotations(ClassNode type) {
        this.lazyInitSupers();
        return super.getAnnotations(type);
    }

    @Override
    public void setRedirect(ClassNode cn) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setGenericsPlaceHolder(boolean b) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setUsingGenerics(boolean b) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String setName(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isResolved() {
        return true;
    }

    @Override
    public Class getTypeClass() {
        return this.resolver.resolveJvmClass(this.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInitSupers() {
        Object object = this.lazyInitLock;
        synchronized (object) {
            if (!this.supersInitialized) {
                ClassSignatureParser.configureClass(this, this.classData, this.resolver);
                this.addAnnotations(this.classData, this);
                this.supersInitialized = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInitMembers() {
        Object object = this.lazyInitLock;
        synchronized (object) {
            if (!this.membersInitialized) {
                if (this.classData.methods != null) {
                    for (MethodStub method : this.classData.methods) {
                        MethodNode node = this.addAnnotations(method, MemberSignatureParser.createMethodNode(this.resolver, method));
                        if (node instanceof ConstructorNode) {
                            this.addConstructor((ConstructorNode)node);
                            continue;
                        }
                        this.addMethod(node);
                    }
                }
                if (this.classData.fields != null) {
                    for (FieldStub field : this.classData.fields) {
                        this.addField(this.addAnnotations(field, MemberSignatureParser.createFieldNode(field, this.resolver, this)));
                    }
                }
                this.membersInitialized = true;
            }
        }
    }

    private <T extends AnnotatedNode> T addAnnotations(MemberStub stub, T node) {
        List<AnnotationStub> annotations = stub.annotations;
        if (annotations != null) {
            for (AnnotationStub annotation : annotations) {
                AnnotationNode annotationNode = Annotations.createAnnotationNode(annotation, this.resolver);
                if (annotationNode == null) continue;
                node.addAnnotation(annotationNode);
            }
        }
        return node;
    }
}

