/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.util;

import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.annotation.Repeatable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.apiguardian.api.API;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;

@API(status=API.Status.INTERNAL, since="1.0")
public final class AnnotationUtils {
    private AnnotationUtils() {
    }

    public static boolean isAnnotated(Optional<? extends AnnotatedElement> element, Class<? extends Annotation> annotationType) {
        return AnnotationUtils.findAnnotation(element, annotationType).isPresent();
    }

    public static boolean isAnnotated(AnnotatedElement element, Class<? extends Annotation> annotationType) {
        return AnnotationUtils.findAnnotation(element, annotationType).isPresent();
    }

    public static <A extends Annotation> Optional<A> findAnnotation(Optional<? extends AnnotatedElement> element, Class<A> annotationType) {
        if (element == null || !element.isPresent()) {
            return Optional.empty();
        }
        boolean inherited = annotationType.isAnnotationPresent(Inherited.class);
        return AnnotationUtils.findAnnotation(element.get(), annotationType, inherited, new HashSet<Annotation>());
    }

    public static <A extends Annotation> Optional<A> findAnnotation(AnnotatedElement element, Class<A> annotationType) {
        boolean inherited = annotationType.isAnnotationPresent(Inherited.class);
        return AnnotationUtils.findAnnotation(element, annotationType, inherited, new HashSet<Annotation>());
    }

    private static <A extends Annotation> Optional<A> findAnnotation(AnnotatedElement element, Class<A> annotationType, boolean inherited, Set<Annotation> visited) {
        Preconditions.notNull(annotationType, "annotationType must not be null");
        if (element == null) {
            return Optional.empty();
        }
        A annotation = element.getDeclaredAnnotation(annotationType);
        if (annotation != null) {
            return Optional.of(annotation);
        }
        Optional<A> directMetaAnnotation = AnnotationUtils.findMetaAnnotation(annotationType, element.getDeclaredAnnotations(), inherited, visited);
        if (directMetaAnnotation.isPresent()) {
            return directMetaAnnotation;
        }
        if (element instanceof Class) {
            Optional<A> annotationOnSuperclass;
            Class superclass;
            Class clazz = (Class)element;
            for (Class<?> ifc : clazz.getInterfaces()) {
                Optional<A> annotationOnInterface;
                if (ifc == Annotation.class || !(annotationOnInterface = AnnotationUtils.findAnnotation(ifc, annotationType, inherited, visited)).isPresent()) continue;
                return annotationOnInterface;
            }
            if (inherited && (superclass = clazz.getSuperclass()) != null && superclass != Object.class && (annotationOnSuperclass = AnnotationUtils.findAnnotation(superclass, annotationType, inherited, visited)).isPresent()) {
                return annotationOnSuperclass;
            }
        }
        return AnnotationUtils.findMetaAnnotation(annotationType, element.getAnnotations(), inherited, visited);
    }

    private static <A extends Annotation> Optional<A> findMetaAnnotation(Class<A> annotationType, Annotation[] candidates, boolean inherited, Set<Annotation> visited) {
        for (Annotation candidateAnnotation : candidates) {
            Optional<A> metaAnnotation;
            Class<? extends Annotation> candidateAnnotationType = candidateAnnotation.annotationType();
            if (AnnotationUtils.isInJavaLangAnnotationPackage(candidateAnnotationType) || !visited.add(candidateAnnotation) || !(metaAnnotation = AnnotationUtils.findAnnotation(candidateAnnotationType, annotationType, inherited, visited)).isPresent()) continue;
            return metaAnnotation;
        }
        return Optional.empty();
    }

    public static <A extends Annotation> List<A> findRepeatableAnnotations(AnnotatedElement element, Class<A> annotationType) {
        Preconditions.notNull(annotationType, "annotationType must not be null");
        Repeatable repeatable = annotationType.getAnnotation(Repeatable.class);
        Preconditions.notNull(repeatable, () -> annotationType.getName() + " must be @Repeatable");
        Class<? extends Annotation> containerType = repeatable.value();
        boolean inherited = containerType.isAnnotationPresent(Inherited.class);
        if (element == null) {
            return Collections.emptyList();
        }
        LinkedHashSet found = new LinkedHashSet(16);
        AnnotationUtils.findRepeatableAnnotations(element, annotationType, containerType, inherited, found, new HashSet<Annotation>(16));
        return Collections.unmodifiableList(new ArrayList(found));
    }

    private static <A extends Annotation> void findRepeatableAnnotations(AnnotatedElement element, Class<A> annotationType, Class<? extends Annotation> containerType, boolean inherited, Set<A> found, Set<Annotation> visited) {
        if (element instanceof Class) {
            Class superclass;
            Class clazz = (Class)element;
            if (inherited && (superclass = clazz.getSuperclass()) != null && superclass != Object.class) {
                AnnotationUtils.findRepeatableAnnotations(superclass, annotationType, containerType, inherited, found, visited);
            }
            for (Class<?> ifc : clazz.getInterfaces()) {
                if (ifc == Annotation.class) continue;
                AnnotationUtils.findRepeatableAnnotations(ifc, annotationType, containerType, inherited, found, visited);
            }
        }
        AnnotationUtils.findRepeatableAnnotations(element.getDeclaredAnnotations(), annotationType, containerType, inherited, found, visited);
        AnnotationUtils.findRepeatableAnnotations(element.getAnnotations(), annotationType, containerType, inherited, found, visited);
    }

    private static <A extends Annotation> void findRepeatableAnnotations(Annotation[] candidates, Class<A> annotationType, Class<? extends Annotation> containerType, boolean inherited, Set<A> found, Set<Annotation> visited) {
        for (Annotation candidate : candidates) {
            Class<? extends Annotation> candidateAnnotationType = candidate.annotationType();
            if (AnnotationUtils.isInJavaLangAnnotationPackage(candidateAnnotationType) || !visited.add(candidate)) continue;
            if (candidateAnnotationType.equals(annotationType)) {
                found.add((Annotation)annotationType.cast(candidate));
                continue;
            }
            if (candidateAnnotationType.equals(containerType)) {
                Method method = ReflectionUtils.getMethod(containerType, "value", new Class[0]).orElseThrow(() -> new JUnitException(String.format("Container annotation type '%s' must declare a 'value' attribute of type %s[].", containerType, annotationType)));
                Annotation[] containedAnnotations = (Annotation[])ReflectionUtils.invokeMethod(method, candidate, new Object[0]);
                found.addAll(Arrays.asList(containedAnnotations));
                continue;
            }
            AnnotationUtils.findRepeatableAnnotations(candidateAnnotationType, annotationType, containerType, inherited, found, visited);
        }
    }

    public static List<Field> findPublicAnnotatedFields(Class<?> clazz, Class<?> fieldType, Class<? extends Annotation> annotationType) {
        Preconditions.notNull(clazz, "Class must not be null");
        Preconditions.notNull(fieldType, "fieldType must not be null");
        Preconditions.notNull(annotationType, "annotationType must not be null");
        return Arrays.stream(clazz.getFields()).filter(field -> fieldType.isAssignableFrom(field.getType()) && AnnotationUtils.isAnnotated(field, annotationType)).collect(CollectionUtils.toUnmodifiableList());
    }

    public static List<Field> findAnnotatedFields(Class<?> clazz, Class<? extends Annotation> annotationType, Predicate<Field> predicate) {
        return AnnotationUtils.findAnnotatedFields(clazz, annotationType, predicate, ReflectionUtils.HierarchyTraversalMode.TOP_DOWN);
    }

    public static List<Field> findAnnotatedFields(Class<?> clazz, Class<? extends Annotation> annotationType, Predicate<Field> predicate, ReflectionUtils.HierarchyTraversalMode traversalMode) {
        Preconditions.notNull(clazz, "Class must not be null");
        Preconditions.notNull(annotationType, "annotationType must not be null");
        Preconditions.notNull(predicate, "Predicate must not be null");
        Predicate<Field> annotated = field -> AnnotationUtils.isAnnotated(field, annotationType);
        return ReflectionUtils.findFields(clazz, annotated.and(predicate), traversalMode);
    }

    public static List<Method> findAnnotatedMethods(Class<?> clazz, Class<? extends Annotation> annotationType, ReflectionUtils.HierarchyTraversalMode traversalMode) {
        Preconditions.notNull(clazz, "Class must not be null");
        Preconditions.notNull(annotationType, "annotationType must not be null");
        return ReflectionUtils.findMethods(clazz, method -> AnnotationUtils.isAnnotated(method, annotationType), traversalMode);
    }

    private static boolean isInJavaLangAnnotationPackage(Class<? extends Annotation> annotationType) {
        return annotationType != null && annotationType.getName().startsWith("java.lang.annotation");
    }
}

