/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.engines.jacl;

import org.apache.bsf.BSFEngine;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.bsf.util.EngineUtils;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.ReflectObject;
import tcl.lang.TclException;
import tcl.lang.TclObject;

class BSFCommand
implements Command {
    BSFManager mgr;
    BSFEngine jengine;

    BSFCommand(BSFManager mgr, BSFEngine jengine) {
        this.mgr = mgr;
        this.jengine = jengine;
    }

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length < 2) {
            interp.setResult("invalid # of args; usage: bsf lookupBean|registerBean|unregisterBean|addEventListener args");
            throw new TclException(1);
        }
        String op = argv[1].toString();
        if (op.equals("lookupBean")) {
            if (argv.length != 3) {
                interp.setResult("invalid # of args; usage: bsf lookupBean name-of-bean");
                throw new TclException(1);
            }
            String beanName = argv[2].toString();
            Object bean = this.mgr.lookupBean(beanName);
            if (bean == null) {
                interp.setResult("unknown object: " + beanName);
                throw new TclException(1);
            }
            interp.setResult(ReflectObject.newInstance((Interp)interp, bean.getClass(), (Object)bean));
        } else if (op.equals("registerBean")) {
            if (argv.length != 4) {
                interp.setResult("invalid # of args; usage: bsf registerBean name-of-bean bean");
                throw new TclException(1);
            }
            this.mgr.registerBean(argv[2].toString(), ReflectObject.get((Interp)interp, (TclObject)argv[3]));
            interp.setResult("");
        } else if (op.equals("unregisterBean")) {
            if (argv.length != 3) {
                interp.setResult("invalid # of args; usage: bsf unregisterBean name-of-bean");
                throw new TclException(1);
            }
            this.mgr.unregisterBean(argv[2].toString());
            interp.setResult("");
        } else if (op.equals("addEventListener")) {
            if (argv.length != 6) {
                interp.setResult("invalid # of args; usage: bsf addEventListener object event-set-name filter script-to-run");
                throw new TclException(1);
            }
            try {
                String filter = argv[4].toString();
                filter = filter.equals("") ? null : filter;
                EngineUtils.addEventListener(ReflectObject.get((Interp)interp, (TclObject)argv[2]), argv[3].toString(), filter, this.jengine, this.mgr, "<event-script>", 0, 0, argv[5].toString());
            }
            catch (BSFException e) {
                e.printStackTrace();
                interp.setResult("got BSF exception: " + e.getMessage());
                throw new TclException(1);
            }
        }
    }
}

