/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.tools.groovydoc.antlr4;

import com.github.javaparser.StaticJavaParser;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.groovy.antlr.GroovydocVisitor;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.ErrorCollector;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.groovydoc.GroovyClassDoc;
import org.codehaus.groovy.groovydoc.GroovyMemberDoc;
import org.codehaus.groovy.groovydoc.GroovyMethodDoc;
import org.codehaus.groovy.groovydoc.GroovyProgramElementDoc;
import org.codehaus.groovy.tools.groovydoc.GroovyDocParserI;
import org.codehaus.groovy.tools.groovydoc.LinkArgument;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyClassDoc;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyFieldDoc;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyMethodDoc;
import org.codehaus.groovy.tools.groovydoc.antlr4.GroovydocJavaVisitor;
import org.codehaus.groovy.tools.shell.util.Logger;

public class GroovyDocParser
implements GroovyDocParserI {
    private final List<LinkArgument> links;
    private final Properties properties;
    private final Logger log = Logger.create(GroovyDocParser.class);

    public GroovyDocParser(List<LinkArgument> links, Properties properties) {
        this.links = links;
        this.properties = properties;
    }

    @Override
    public Map<String, GroovyClassDoc> getClassDocsFromSingleSource(String packagePath, String file, String src) throws RuntimeException {
        if (file.indexOf(".java") > 0) {
            return this.parseJava(packagePath, file, src);
        }
        if (file.indexOf(".sourcefile") > 0) {
            return this.parseJava(packagePath, file, src);
        }
        return this.parseGroovy(packagePath, file, src);
    }

    private Map<String, GroovyClassDoc> parseJava(String packagePath, String file, String src) throws RuntimeException {
        GroovydocJavaVisitor visitor = new GroovydocJavaVisitor(packagePath, this.links);
        visitor.visit(StaticJavaParser.parse((String)src), null);
        return visitor.getGroovyClassDocs();
    }

    private Map<String, GroovyClassDoc> parseGroovy(String packagePath, String file, String src) throws RuntimeException {
        CompilerConfiguration config = new CompilerConfiguration();
        config.getOptimizationOptions().put("groovydoc", true);
        CompilationUnit compUnit = new CompilationUnit(config);
        SourceUnit unit = new SourceUnit(file, src, config, null, new ErrorCollector(config));
        compUnit.addSource(unit);
        compUnit.compile(3);
        ModuleNode root = unit.getAST();
        GroovydocVisitor visitor = new GroovydocVisitor(unit, packagePath, this.links);
        visitor.visitClass((ClassNode)root.getClasses().get(0));
        Map<String, GroovyClassDoc> groovyClassDocs = visitor.getGroovyClassDocs();
        for (GroovyClassDoc classDoc : groovyClassDocs.values()) {
            this.replaceTags((SimpleGroovyClassDoc)classDoc);
        }
        return groovyClassDocs;
    }

    private void replaceTags(SimpleGroovyClassDoc sgcd) {
        sgcd.setRawCommentText(sgcd.replaceTags(sgcd.getRawCommentText()));
        for (GroovyMethodDoc groovyMethodDoc : sgcd.methods()) {
            SimpleGroovyMethodDoc sgmd = (SimpleGroovyMethodDoc)groovyMethodDoc;
            sgmd.setRawCommentText(sgcd.replaceTags(sgmd.getRawCommentText()));
        }
        for (GroovyMemberDoc groovyMemberDoc : sgcd.isEnum() ? sgcd.enumConstants() : sgcd.fields()) {
            SimpleGroovyFieldDoc sgfd = (SimpleGroovyFieldDoc)groovyMemberDoc;
            sgfd.setRawCommentText(sgcd.replaceTags(sgfd.getRawCommentText()));
        }
        for (GroovyProgramElementDoc groovyProgramElementDoc : sgcd.innerClasses()) {
            this.replaceTags((SimpleGroovyClassDoc)groovyProgramElementDoc);
        }
    }
}

