/*
 * Decompiled with CFR 0.152.
 */
package org.testng.xml.internal;

import java.util.List;
import java.util.Set;
import org.testng.TestNGException;
import org.testng.collections.Lists;
import org.testng.collections.Sets;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public final class XmlSuiteUtils {
    private XmlSuiteUtils() {
    }

    public static void validateIfSuitesContainDuplicateTests(List<XmlSuite> list) {
        for (XmlSuite xmlSuite : list) {
            XmlSuiteUtils.ensureNoDuplicateTestsArePresent(xmlSuite);
            XmlSuiteUtils.validateIfSuitesContainDuplicateTests(xmlSuite.getChildSuites());
        }
    }

    public static void adjustSuiteNamesToEnsureUniqueness(List<XmlSuite> list) {
        XmlSuiteUtils.adjustSuiteNamesToEnsureUniqueness(list, Sets.newHashSet());
    }

    public static XmlSuite newXmlSuiteUsing(List<String> list) {
        XmlSuite xmlSuite = new XmlSuite();
        xmlSuite.setVerbose(0);
        xmlSuite.setName("Jar suite");
        XmlTest xmlTest = new XmlTest(xmlSuite);
        xmlTest.setXmlClasses(XmlSuiteUtils.constructXmlClassesUsing(list));
        return xmlSuite;
    }

    static void ensureNoDuplicateTestsArePresent(XmlSuite xmlSuite) {
        Set set = Sets.newHashSet();
        for (XmlTest xmlTest : xmlSuite.getTests()) {
            if (set.add(xmlTest.getName())) continue;
            throw new TestNGException("Two tests in the same suite [" + xmlSuite.getName() + "] cannot have the same name: " + xmlTest.getName());
        }
    }

    private static List<XmlClass> constructXmlClassesUsing(List<String> list) {
        List<XmlClass> list2 = Lists.newLinkedList();
        for (String string : list) {
            XmlClass xmlClass = new XmlClass(string);
            list2.add(xmlClass);
        }
        return list2;
    }

    private static void adjustSuiteNamesToEnsureUniqueness(List<XmlSuite> list, Set<String> set) {
        for (XmlSuite xmlSuite : list) {
            String string = xmlSuite.getName();
            int n = 0;
            String string2 = string;
            while (set.contains(string2)) {
                string2 = string + " (" + n++ + ")";
            }
            if (n > 0) {
                xmlSuite.setName(string2);
                set.add(string2);
            } else {
                set.add(string);
            }
            XmlSuiteUtils.adjustSuiteNamesToEnsureUniqueness(xmlSuite.getChildSuites(), set);
        }
    }
}

