/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Map;
import org.testng.IClass;
import org.testng.IMethodSelector;
import org.testng.IObjectFactory;
import org.testng.IObjectFactory2;
import org.testng.ITestObjectFactory;
import org.testng.TestNGException;
import org.testng.annotations.IFactoryAnnotation;
import org.testng.annotations.IParametersAnnotation;
import org.testng.internal.ClassHelper;
import org.testng.internal.Parameters;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.util.Strings;
import org.testng.xml.XmlMethodSelector;
import org.testng.xml.XmlTest;

public final class InstanceCreator {
    private static final String CANNOT_INSTANTIATE_CLASS = "Cannot instantiate class ";

    private InstanceCreator() {
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (ExceptionInInitializerError | IllegalAccessException | InstantiationException | NullPointerException | SecurityException e) {
            throw new TestNGException(CANNOT_INSTANTIATE_CLASS + clazz.getName(), e);
        }
    }

    public static <T> T newInstanceOrNull(Class<T> clazz) {
        try {
            Constructor<T> constructor = clazz.getConstructor(new Class[0]);
            return InstanceCreator.newInstance(constructor, new Object[0]);
        }
        catch (ExceptionInInitializerError | SecurityException e) {
            throw new TestNGException(CANNOT_INSTANTIATE_CLASS + clazz.getName(), e);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static <T> T newInstance(Constructor<T> constructor, Object ... parameters) {
        try {
            return constructor.newInstance(parameters);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new TestNGException(CANNOT_INSTANTIATE_CLASS + constructor.getDeclaringClass().getName(), e);
        }
    }

    public static IMethodSelector createSelector(XmlMethodSelector selector) {
        try {
            Class<?> cls = Class.forName(selector.getClassName());
            return (IMethodSelector)cls.newInstance();
        }
        catch (Exception ex) {
            throw new TestNGException("Couldn't find method selector : " + selector.getClassName(), ex);
        }
    }

    public static Object createInstance(Class<?> declaringClass, Map<Class<?>, IClass> classes, XmlTest xmlTest, IAnnotationFinder finder, ITestObjectFactory objectFactory, boolean create, String errorMsgPrefix) {
        if (objectFactory instanceof IObjectFactory) {
            return InstanceCreator.createInstanceUsingObjectFactory(declaringClass, classes, xmlTest, finder, (IObjectFactory)objectFactory, create, errorMsgPrefix);
        }
        if (objectFactory instanceof IObjectFactory2) {
            return InstanceCreator.createInstanceUsingObjectFactory(declaringClass, (IObjectFactory2)objectFactory);
        }
        throw new AssertionError((Object)("Unknown object factory type:" + objectFactory));
    }

    private static Object createInstanceUsingObjectFactory(Class<?> declaringClass, IObjectFactory2 objectFactory) {
        return objectFactory.newInstance(declaringClass);
    }

    public static Object createInstanceUsingObjectFactory(Class<?> declaringClass, Map<Class<?>, IClass> classes, XmlTest xmlTest, IAnnotationFinder finder, IObjectFactory factory, boolean create, String errorMsgPrefix) {
        Object result;
        block10: {
            result = null;
            try {
                Constructor<?> constructor = ClassHelper.findAnnotatedConstructor(finder, declaringClass);
                if (null != constructor) {
                    try {
                        result = InstanceCreator.instantiateUsingParameterizedConstructor(finder, constructor, xmlTest, factory);
                        break block10;
                    }
                    catch (IllegalArgumentException e) {
                        return null;
                    }
                }
                result = InstanceCreator.instantiateUsingDefaultConstructor(declaringClass, classes, xmlTest, factory);
            }
            catch (TestNGException ex) {
                throw ex;
            }
            catch (NoSuchMethodException ex) {
            }
            catch (Throwable cause) {
                throw new TestNGException("An error occurred while instantiating class " + declaringClass.getName() + ": " + cause.getMessage(), cause);
            }
        }
        if (result == null && create) {
            String suffix = "instantiated";
            if (!Modifier.isPublic(declaringClass.getModifiers())) {
                suffix = suffix + "/accessed.";
            }
            if (Strings.isNotNullAndNotEmpty(errorMsgPrefix)) {
                suffix = suffix + ". Root cause: " + errorMsgPrefix;
            }
            throw new TestNGException("An error occurred while instantiating class " + declaringClass.getName() + ". Check to make sure it can be " + suffix);
        }
        return result;
    }

    private static Object instantiateUsingParameterizedConstructor(IAnnotationFinder finder, Constructor<?> constructor, XmlTest xmlTest, IObjectFactory objectFactory) {
        IFactoryAnnotation factoryAnnotation = finder.findAnnotation(constructor, IFactoryAnnotation.class);
        if (factoryAnnotation != null) {
            throw new IllegalArgumentException("No factory annotation found.");
        }
        IParametersAnnotation parametersAnnotation = finder.findAnnotation(constructor, IParametersAnnotation.class);
        if (parametersAnnotation == null) {
            return null;
        }
        String[] parameterNames = parametersAnnotation.getValue();
        Object[] parameters = Parameters.createInstantiationParameters(constructor, "@Parameters", finder, parameterNames, xmlTest.getAllParameters(), xmlTest.getSuite());
        return objectFactory.newInstance(constructor, parameters);
    }

    private static Object instantiateUsingDefaultConstructor(Class<?> declaringClass, Map<Class<?>, IClass> classes, XmlTest xmlTest, IObjectFactory factory) throws NoSuchMethodException, IllegalAccessException, InstantiationException {
        Constructor<?> ct;
        boolean isStatic;
        Class[] parameterTypes = new Class[]{};
        Object[] parameters = new Object[]{};
        Class<?> ec = declaringClass.getEnclosingClass();
        boolean bl = isStatic = 0 != (declaringClass.getModifiers() & 8);
        if (null != ec && !isStatic) {
            parameterTypes = new Class[]{ec};
            parameters = new Object[]{InstanceCreator.computeParameters(classes, ec, factory)};
        }
        try {
            ct = declaringClass.getDeclaredConstructor(parameterTypes);
        }
        catch (NoSuchMethodException ex) {
            ct = declaringClass.getDeclaredConstructor(String.class);
            parameters = new Object[]{xmlTest.getName()};
        }
        return factory.newInstance(ct, parameters);
    }

    private static Object computeParameters(Map<Class<?>, IClass> classes, Class<?> ec, IObjectFactory factory) throws NoSuchMethodException, IllegalAccessException, InstantiationException {
        IClass enclosingIClass = classes.get(ec);
        if (enclosingIClass == null) {
            return ec.newInstance();
        }
        Object[] enclosingInstances = enclosingIClass.getInstances(false);
        if (enclosingInstances == null || enclosingInstances.length == 0) {
            return factory.newInstance(ec.getConstructor(ec), new Object[0]);
        }
        return enclosingInstances[0];
    }
}

