/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.util;

import java.beans.BeanInfo;
import java.beans.Beans;
import java.beans.EventSetDescriptor;
import java.beans.FeatureDescriptor;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.bsf.util.Bean;
import org.apache.bsf.util.MethodUtils;
import org.apache.bsf.util.event.EventAdapter;
import org.apache.bsf.util.event.EventAdapterRegistry;
import org.apache.bsf.util.event.EventProcessor;
import org.apache.bsf.util.type.TypeConvertor;
import org.apache.bsf.util.type.TypeConvertorRegistry;

public class ReflectionUtils {
    public static void addEventListener(Object source, String eventSetName, EventProcessor processor) throws IntrospectionException, IllegalArgumentException, IllegalAccessException, InstantiationException, InvocationTargetException {
        Object[] args;
        Method addListenerMethod;
        BeanInfo bi = Introspector.getBeanInfo(source.getClass());
        EventSetDescriptor esd = (EventSetDescriptor)ReflectionUtils.findFeatureByName("event", eventSetName, bi.getEventSetDescriptors());
        if (esd == null) {
            throw new IllegalArgumentException("event set '" + eventSetName + "' unknown for source type '" + source.getClass() + "'");
        }
        Class<?> listenerType = esd.getListenerType();
        Class adapterClass = EventAdapterRegistry.lookup(listenerType);
        if (adapterClass == null) {
            throw new IllegalArgumentException("event adapter for listener type '" + listenerType + "' (eventset " + "'" + eventSetName + "') unknown");
        }
        EventAdapter adapter = (EventAdapter)adapterClass.newInstance();
        adapter.setEventProcessor(processor);
        if (eventSetName.equals("propertyChange") || eventSetName.equals("vetoableChange")) {
            addListenerMethod = esd.getAddListenerMethod();
            args = new Object[]{adapter};
        } else {
            addListenerMethod = esd.getAddListenerMethod();
            args = new Object[]{adapter};
        }
        addListenerMethod.invoke(source, args);
    }

    public static Bean createBean(ClassLoader cld, String className, Class[] argTypes, Object[] args) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, IOException {
        if (argTypes != null) {
            Class<?> cl = cld != null ? cld.loadClass(className) : Thread.currentThread().getContextClassLoader().loadClass(className);
            Constructor c = MethodUtils.getConstructor(cl, argTypes);
            return new Bean(cl, c.newInstance(args));
        }
        Object obj = Beans.instantiate(cld, className);
        return new Bean(obj.getClass(), obj);
    }

    public static Bean createBean(ClassLoader cld, String className, Object[] args) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, IOException {
        Class[] argTypes = null;
        if (args != null) {
            argTypes = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                argTypes[i] = args[i] != null ? args[i].getClass() : null;
            }
        }
        return ReflectionUtils.createBean(cld, className, argTypes, args);
    }

    private static FeatureDescriptor findFeatureByName(String featureType, String name, FeatureDescriptor[] fds) {
        for (int i = 0; i < fds.length; ++i) {
            if (!name.equals(fds[i].getName())) continue;
            return fds[i];
        }
        return null;
    }

    public static Bean getField(Object target, String fieldName) throws IllegalArgumentException, IllegalAccessException {
        Class<?> targetClass = target instanceof Class ? (Class<?>)target : target.getClass();
        try {
            Field f = targetClass.getField(fieldName);
            Class<?> fieldType = f.getType();
            Object value = f.get(target);
            return new Bean(fieldType, value);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException("field '" + fieldName + "' is " + "unknown for '" + target + "'");
        }
    }

    public static Bean getProperty(Object target, String propName, Integer index) throws IntrospectionException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?> propType;
        Method rm;
        BeanInfo bi = Introspector.getBeanInfo(target.getClass());
        PropertyDescriptor pd = (PropertyDescriptor)ReflectionUtils.findFeatureByName("property", propName, bi.getPropertyDescriptors());
        if (pd == null) {
            throw new IllegalArgumentException("property '" + propName + "' is " + "unknown for '" + target + "'");
        }
        if (index != null) {
            if (!(pd instanceof IndexedPropertyDescriptor)) {
                throw new IllegalArgumentException("attempt to get non-indexed property '" + propName + "' as being indexed");
            }
            IndexedPropertyDescriptor ipd = (IndexedPropertyDescriptor)pd;
            rm = ipd.getIndexedReadMethod();
            propType = ipd.getIndexedPropertyType();
        } else {
            rm = pd.getReadMethod();
            propType = pd.getPropertyType();
        }
        if (rm == null) {
            throw new IllegalArgumentException("property '" + propName + "' is not readable");
        }
        Object propVal = null;
        propVal = index != null ? rm.invoke(target, index) : rm.invoke(target, null);
        return new Bean(propType, propVal);
    }

    public static void setField(Object target, String fieldName, Bean value, TypeConvertorRegistry tcr) throws IllegalArgumentException, IllegalAccessException {
        Class<?> targetClass = target instanceof Class ? (Class<?>)target : target.getClass();
        try {
            Field f = targetClass.getField(fieldName);
            Class<?> fieldType = f.getType();
            Object fieldVal = null;
            boolean okeydokey = true;
            if (fieldType.isAssignableFrom(value.type)) {
                fieldVal = value.value;
            } else if (tcr != null) {
                TypeConvertor cvtor = tcr.lookup(value.type, fieldType);
                if (cvtor != null) {
                    fieldVal = cvtor.convert(value.type, fieldType, value.value);
                } else {
                    okeydokey = false;
                }
            } else {
                okeydokey = false;
            }
            if (!okeydokey) {
                throw new IllegalArgumentException("unable to assign '" + value.value + "' to field '" + fieldName + "'");
            }
            f.set(target, fieldVal);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException("field '" + fieldName + "' is " + "unknown for '" + target + "'");
        }
    }

    public static void setProperty(Object target, String propName, Integer index, Object value, Class valueType, TypeConvertorRegistry tcr) throws IntrospectionException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?> propType;
        Method wm;
        BeanInfo bi = Introspector.getBeanInfo(target.getClass());
        PropertyDescriptor pd = (PropertyDescriptor)ReflectionUtils.findFeatureByName("property", propName, bi.getPropertyDescriptors());
        if (pd == null) {
            throw new IllegalArgumentException("property '" + propName + "' is " + "unknown for '" + target + "'");
        }
        if (index != null) {
            if (!(pd instanceof IndexedPropertyDescriptor)) {
                throw new IllegalArgumentException("attempt to set non-indexed property '" + propName + "' as being indexed");
            }
            IndexedPropertyDescriptor ipd = (IndexedPropertyDescriptor)pd;
            wm = ipd.getIndexedWriteMethod();
            propType = ipd.getIndexedPropertyType();
        } else {
            wm = pd.getWriteMethod();
            propType = pd.getPropertyType();
        }
        if (wm == null) {
            throw new IllegalArgumentException("property '" + propName + "' is not writeable");
        }
        Object propVal = null;
        boolean okeydokey = true;
        if (propType.isAssignableFrom(valueType)) {
            propVal = value;
        } else if (tcr != null) {
            TypeConvertor cvtor = tcr.lookup(valueType, propType);
            if (cvtor != null) {
                propVal = cvtor.convert(valueType, propType, value);
            } else {
                okeydokey = false;
            }
        } else {
            okeydokey = false;
        }
        if (!okeydokey) {
            throw new IllegalArgumentException("unable to assign '" + value + "' to property '" + propName + "'");
        }
        if (index != null) {
            wm.invoke(target, index, propVal);
        } else {
            wm.invoke(target, propVal);
        }
    }
}

