/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.gamma.transactionalobjects;

import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.LockMode;
import org.multiverse.api.Txn;
import org.multiverse.api.exceptions.LockedException;
import org.multiverse.api.functions.DoubleFunction;
import org.multiverse.api.functions.Function;
import org.multiverse.api.predicates.DoublePredicate;
import org.multiverse.api.references.TxnDouble;
import org.multiverse.stms.gamma.GammaStm;
import org.multiverse.stms.gamma.GammaStmUtils;
import org.multiverse.stms.gamma.Listeners;
import org.multiverse.stms.gamma.ThreadLocalGammaObjectPool;
import org.multiverse.stms.gamma.transactionalobjects.BaseGammaTxnRef;
import org.multiverse.stms.gamma.transactionalobjects.Tranlocal;
import org.multiverse.stms.gamma.transactions.GammaTxn;

public class GammaTxnDouble
extends BaseGammaTxnRef
implements TxnDouble {
    public GammaTxnDouble(double value) {
        this((GammaStm)GlobalStmInstance.getGlobalStmInstance(), value);
    }

    public GammaTxnDouble(GammaTxn tx) {
        this(tx, 0.0);
    }

    public GammaTxnDouble(GammaTxn tx, double value) {
        super(tx.getConfig().stm, 3);
        this.arriveAndLock(1, 3);
        Tranlocal tranlocal = this.openForConstruction(tx);
        tranlocal.long_value = GammaStmUtils.doubleAsLong(value);
    }

    public GammaTxnDouble(GammaStm stm) {
        this(stm, 0.0);
    }

    public GammaTxnDouble(GammaStm stm, double value) {
        super(stm, 3);
        this.long_value = GammaStmUtils.doubleAsLong(value);
        this.version = 1L;
    }

    @Override
    public final double get() {
        return this.get(GammaStmUtils.getRequiredThreadLocalGammaTxn());
    }

    @Override
    public final double get(Txn tx) {
        return this.get(GammaStmUtils.asGammaTxn(tx));
    }

    public final double get(GammaTxn tx) {
        return GammaStmUtils.longAsDouble(this.openForRead((GammaTxn)tx, (int)0).long_value);
    }

    @Override
    public final double getAndLock(LockMode lockMode) {
        return this.getAndLock(GammaStmUtils.getRequiredThreadLocalGammaTxn(), lockMode);
    }

    @Override
    public final double getAndLock(Txn tx, LockMode lockMode) {
        return this.getAndLock(GammaStmUtils.asGammaTxn(tx), lockMode);
    }

    public final double getAndLock(GammaTxn tx, LockMode lockMode) {
        return GammaStmUtils.longAsDouble(this.getLong(tx, lockMode));
    }

    @Override
    public final double set(double value) {
        return this.set(GammaStmUtils.getRequiredThreadLocalGammaTxn(), value);
    }

    @Override
    public final double set(Txn tx, double value) {
        return this.set(GammaStmUtils.asGammaTxn(tx), value);
    }

    public final double set(GammaTxn tx, double value) {
        this.openForWrite((GammaTxn)tx, (int)0).long_value = GammaStmUtils.doubleAsLong(value);
        return value;
    }

    @Override
    public final double setAndLock(double value, LockMode lockMode) {
        return this.setAndLock(GammaStmUtils.getRequiredThreadLocalGammaTxn(), (double)GammaStmUtils.doubleAsLong(value), lockMode);
    }

    @Override
    public final double setAndLock(Txn tx, double value, LockMode lockMode) {
        return this.setAndLock(GammaStmUtils.asGammaTxn(tx), value, lockMode);
    }

    public final double setAndLock(GammaTxn tx, double value, LockMode lockMode) {
        return GammaStmUtils.longAsDouble(this.setLong(tx, lockMode, GammaStmUtils.doubleAsLong(value), false));
    }

    @Override
    public final double getAndSet(double value) {
        return this.getAndSet(GammaStmUtils.getRequiredThreadLocalGammaTxn(), value);
    }

    @Override
    public final double getAndSet(Txn tx, double value) {
        return this.getAndSet(GammaStmUtils.asGammaTxn(tx), value);
    }

    public final double getAndSet(GammaTxn tx, double value) {
        Tranlocal tranlocal = this.openForWrite(tx, 0);
        double oldValue = GammaStmUtils.longAsDouble(tranlocal.long_value);
        tranlocal.long_value = GammaStmUtils.doubleAsLong(value);
        return oldValue;
    }

    @Override
    public final double getAndSetAndLock(double value, LockMode lockMode) {
        return this.getAndSetAndLock(GammaStmUtils.getRequiredThreadLocalGammaTxn(), value, lockMode);
    }

    @Override
    public final double getAndSetAndLock(Txn tx, double value, LockMode lockMode) {
        return this.getAndSetAndLock(GammaStmUtils.asGammaTxn(tx), value, lockMode);
    }

    public final double getAndSetAndLock(GammaTxn tx, double value, LockMode lockMode) {
        return GammaStmUtils.longAsDouble(this.setLong(tx, lockMode, GammaStmUtils.doubleAsLong(value), true));
    }

    @Override
    public final double atomicGet() {
        return GammaStmUtils.longAsDouble(this.atomicGetLong());
    }

    @Override
    public final double atomicWeakGet() {
        return GammaStmUtils.longAsDouble(this.long_value);
    }

    @Override
    public final double atomicSet(double newValue) {
        return GammaStmUtils.longAsDouble(this.atomicSetLong(GammaStmUtils.doubleAsLong(newValue), false));
    }

    @Override
    public final double atomicGetAndSet(double newValue) {
        return GammaStmUtils.longAsDouble(this.atomicSetLong(GammaStmUtils.doubleAsLong(newValue), true));
    }

    @Override
    public final void commute(DoubleFunction function) {
        this.commute(GammaStmUtils.getRequiredThreadLocalGammaTxn(), function);
    }

    @Override
    public final void commute(Txn tx, DoubleFunction function) {
        this.commute(GammaStmUtils.asGammaTxn(tx), function);
    }

    public final void commute(GammaTxn tx, DoubleFunction function) {
        this.openForCommute(tx, (Function)function);
    }

    @Override
    public final double atomicAlterAndGet(DoubleFunction function) {
        return this.atomicAlter(function, false);
    }

    @Override
    public final double atomicGetAndAlter(DoubleFunction function) {
        return this.atomicAlter(function, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double atomicAlter(DoubleFunction function, boolean returnOld) {
        double newValue;
        if (function == null) {
            throw new NullPointerException("Function can't be null");
        }
        int arriveStatus = this.arriveAndExclusiveLockOrBackoff();
        if (arriveStatus == 0) {
            throw new LockedException();
        }
        double oldValue = GammaStmUtils.longAsDouble(this.long_value);
        boolean abort = true;
        try {
            newValue = function.call(oldValue);
            abort = false;
        }
        finally {
            if (abort) {
                this.departAfterFailureAndUnlock();
            }
        }
        if (oldValue == newValue) {
            if ((arriveStatus & 2) != 0) {
                this.unlockByUnregistered();
            } else {
                this.departAfterReadingAndUnlock();
            }
            return oldValue;
        }
        if ((arriveStatus & 4) != 0) {
            this.stm.globalConflictCounter.signalConflict();
        }
        this.long_value = GammaStmUtils.doubleAsLong(newValue);
        ++this.version;
        Listeners listeners = this.___removeListenersAfterWrite();
        this.departAfterUpdateAndUnlock();
        if (listeners != null) {
            listeners.openAll(ThreadLocalGammaObjectPool.getThreadLocalGammaObjectPool());
        }
        return returnOld ? oldValue : newValue;
    }

    @Override
    public final double alterAndGet(DoubleFunction function) {
        return this.alterAndGet(GammaStmUtils.getRequiredThreadLocalGammaTxn(), function);
    }

    @Override
    public final double alterAndGet(Txn tx, DoubleFunction function) {
        return this.alterAndGet(GammaStmUtils.asGammaTxn(tx), function);
    }

    public final double alterAndGet(GammaTxn tx, DoubleFunction function) {
        return this.alter(tx, function, false);
    }

    @Override
    public final double getAndAlter(DoubleFunction function) {
        return this.getAndAlter(GammaStmUtils.getRequiredThreadLocalGammaTxn(), function);
    }

    @Override
    public final double getAndAlter(Txn tx, DoubleFunction function) {
        return this.getAndAlter(GammaStmUtils.asGammaTxn(tx), function);
    }

    public final double getAndAlter(GammaTxn tx, DoubleFunction function) {
        return this.alter(tx, function, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final double alter(GammaTxn tx, DoubleFunction function, boolean returnOld) {
        if (tx == null) {
            throw new NullPointerException();
        }
        if (function == null) {
            tx.abort();
            throw new NullPointerException("Function can't be null");
        }
        Tranlocal write = this.openForWrite(tx, 0);
        boolean abort = true;
        try {
            double oldValue = GammaStmUtils.longAsDouble(write.long_value);
            write.long_value = GammaStmUtils.doubleAsLong(function.call(oldValue));
            abort = false;
            double d = returnOld ? oldValue : GammaStmUtils.longAsDouble(write.long_value);
            return d;
        }
        finally {
            if (abort) {
                tx.abort();
            }
        }
    }

    @Override
    public final boolean atomicCompareAndSet(double expectedValue, double newValue) {
        return this.atomicCompareAndSetLong(GammaStmUtils.doubleAsLong(expectedValue), GammaStmUtils.doubleAsLong(newValue));
    }

    @Override
    public final double getAndIncrement(double amount) {
        return this.getAndIncrement(GammaStmUtils.getRequiredThreadLocalGammaTxn(), amount);
    }

    @Override
    public final double getAndIncrement(Txn tx, double amount) {
        return this.getAndIncrement(GammaStmUtils.asGammaTxn(tx), amount);
    }

    public final double getAndIncrement(GammaTxn tx, double amount) {
        Tranlocal tranlocal = this.openForWrite(tx, 0);
        double oldValue = GammaStmUtils.longAsDouble(tranlocal.long_value);
        tranlocal.long_value = GammaStmUtils.doubleAsLong(oldValue + amount);
        return oldValue;
    }

    @Override
    public final double atomicGetAndIncrement(double amount) {
        return this.atomicIncrement(amount, true);
    }

    @Override
    public final double atomicIncrementAndGet(double amount) {
        return this.atomicIncrement(amount, false);
    }

    private double atomicIncrement(double amount, boolean returnOld) {
        int arriveStatus = this.arriveAndExclusiveLockOrBackoff();
        if (arriveStatus == 0) {
            throw new LockedException();
        }
        double oldValue = GammaStmUtils.longAsDouble(this.long_value);
        if (amount == 0.0) {
            if ((arriveStatus & 2) != 0) {
                this.unlockByUnregistered();
            } else {
                this.departAfterReadingAndUnlock();
            }
            return oldValue;
        }
        if ((arriveStatus & 4) != 0) {
            this.stm.globalConflictCounter.signalConflict();
        }
        double newValue = oldValue + amount;
        this.long_value = GammaStmUtils.doubleAsLong(newValue);
        ++this.version;
        Listeners listeners = this.___removeListenersAfterWrite();
        this.departAfterUpdateAndUnlock();
        if (listeners != null) {
            listeners.openAll(ThreadLocalGammaObjectPool.getThreadLocalGammaObjectPool());
        }
        return returnOld ? oldValue : newValue;
    }

    @Override
    public final double incrementAndGet(double amount) {
        return this.incrementAndGet(GammaStmUtils.getRequiredThreadLocalGammaTxn(), amount);
    }

    @Override
    public final double incrementAndGet(Txn tx, double amount) {
        return this.incrementAndGet(GammaStmUtils.asGammaTxn(tx), amount);
    }

    public final double incrementAndGet(GammaTxn tx, double amount) {
        Tranlocal tranlocal = this.openForWrite(tx, 0);
        double result = GammaStmUtils.longAsDouble(tranlocal.long_value) + amount;
        tranlocal.long_value = GammaStmUtils.doubleAsLong(result);
        return result;
    }

    @Override
    public final void await(double value) {
        this.await(GammaStmUtils.getRequiredThreadLocalGammaTxn(), value);
    }

    @Override
    public final void await(Txn tx, double value) {
        this.await(GammaStmUtils.asGammaTxn(tx), value);
    }

    public final void await(GammaTxn tx, double value) {
        if (GammaStmUtils.longAsDouble(this.openForRead((GammaTxn)tx, (int)0).long_value) != value) {
            tx.retry();
        }
    }

    @Override
    public final void await(DoublePredicate predicate) {
        this.await(GammaStmUtils.getRequiredThreadLocalGammaTxn(), predicate);
    }

    @Override
    public final void await(Txn tx, DoublePredicate predicate) {
        this.await(GammaStmUtils.asGammaTxn(tx), predicate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void await(GammaTxn tx, DoublePredicate predicate) {
        Tranlocal tranlocal = this.openForRead(tx, 0);
        boolean abort = true;
        try {
            if (!predicate.evaluate(GammaStmUtils.longAsDouble(tranlocal.long_value))) {
                tx.retry();
            }
            abort = false;
        }
        finally {
            if (abort) {
                tx.abort();
            }
        }
    }

    @Override
    public final String toDebugString() {
        return String.format("GammaTxnDouble{orec=%s, version=%s, value=%s, hasListeners=%s)", this.___toOrecString(), this.version, GammaStmUtils.longAsDouble(this.long_value), this.listeners != null);
    }

    @Override
    public final String toString() {
        return this.toString(GammaStmUtils.getRequiredThreadLocalGammaTxn());
    }

    @Override
    public final String toString(Txn tx) {
        return this.toString(GammaStmUtils.asGammaTxn(tx));
    }

    public final String toString(GammaTxn tx) {
        return Double.toString(this.get(tx));
    }

    @Override
    public final String atomicToString() {
        return Double.toString(this.atomicGet());
    }
}

