/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.util.Collections;
import java.util.Comparator;
import java.util.Optional;
import org.apiguardian.api.API;
import org.junit.jupiter.api.ClassDescriptor;
import org.junit.jupiter.api.ClassOrdererContext;
import org.junit.jupiter.api.Order;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;

@API(status=API.Status.EXPERIMENTAL, since="5.8")
public interface ClassOrderer {
    @API(status=API.Status.STABLE, since="5.9")
    public static final String DEFAULT_ORDER_PROPERTY_NAME = "junit.jupiter.testclass.order.default";

    public void orderClasses(ClassOrdererContext var1);

    public static class Random
    implements ClassOrderer {
        private static final Logger logger = LoggerFactory.getLogger(Random.class);
        private static final long DEFAULT_SEED = System.nanoTime();
        public static final String RANDOM_SEED_PROPERTY_NAME = "junit.jupiter.execution.order.random.seed";

        @Override
        public void orderClasses(ClassOrdererContext context) {
            Collections.shuffle(context.getClassDescriptors(), new java.util.Random(this.getCustomSeed(context).orElse(DEFAULT_SEED)));
        }

        private Optional<Long> getCustomSeed(ClassOrdererContext context) {
            return context.getConfigurationParameter(RANDOM_SEED_PROPERTY_NAME).map(configurationParameter -> {
                Long seed = null;
                try {
                    seed = Long.valueOf(configurationParameter);
                    logger.config(() -> String.format("Using custom seed for configuration parameter [%s] with value [%s].", RANDOM_SEED_PROPERTY_NAME, configurationParameter));
                }
                catch (NumberFormatException ex) {
                    logger.warn((Throwable)ex, () -> String.format("Failed to convert configuration parameter [%s] with value [%s] to a long. Using default seed [%s] as fallback.", RANDOM_SEED_PROPERTY_NAME, configurationParameter, DEFAULT_SEED));
                }
                return seed;
            });
        }

        static {
            logger.config(() -> "ClassOrderer.Random default seed: " + DEFAULT_SEED);
        }
    }

    public static class OrderAnnotation
    implements ClassOrderer {
        @Override
        public void orderClasses(ClassOrdererContext context) {
            context.getClassDescriptors().sort(Comparator.comparingInt(OrderAnnotation::getOrder));
        }

        private static int getOrder(ClassDescriptor descriptor) {
            return descriptor.findAnnotation(Order.class).map(Order::value).orElse(0x3FFFFFFF);
        }
    }

    public static class DisplayName
    implements ClassOrderer {
        private static final Comparator<ClassDescriptor> comparator = Comparator.comparing(ClassDescriptor::getDisplayName);

        @Override
        public void orderClasses(ClassOrdererContext context) {
            context.getClassDescriptors().sort(comparator);
        }
    }

    public static class ClassName
    implements ClassOrderer {
        private static final Comparator<ClassDescriptor> comparator = Comparator.comparing(descriptor -> descriptor.getTestClass().getName());

        @Override
        public void orderClasses(ClassOrdererContext context) {
            context.getClassDescriptors().sort(comparator);
        }
    }
}

