/*
 * Decompiled with CFR 0.152.
 */
package com.bfo.json;

import com.bfo.json.Core;
import com.bfo.json.SerializerState;
import java.io.IOException;

class IBoolean
extends Core {
    private final boolean value;
    private final byte flags;

    IBoolean(boolean value, byte flags) {
        this.value = value;
        this.flags = flags;
    }

    @Override
    Object value() {
        return this.value ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    String type() {
        return "boolean";
    }

    @Override
    boolean booleanValue() {
        return this.value;
    }

    @Override
    Number numberValue() {
        return this.intValue();
    }

    @Override
    int intValue() {
        if ((this.flags & 1) != 0) {
            throw new ClassCastException("Cannot convert boolean " + this.value + " to number in strict mode");
        }
        return this.value ? 1 : 0;
    }

    @Override
    float floatValue() {
        return this.intValue();
    }

    @Override
    double doubleValue() {
        return this.intValue();
    }

    @Override
    void write(Appendable sb, SerializerState state) throws IOException {
        sb.append(this.value ? "true" : "false");
    }
}

