/*
 * Decompiled with CFR 0.152.
 */
package com.grack.nanojson;

import com.grack.nanojson.JsonSink;
import com.grack.nanojson.JsonWriterException;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import java.util.Stack;

class JsonWriterBase<SELF extends JsonWriterBase<SELF>>
implements JsonSink<SELF> {
    protected final Appendable appendable;
    private Stack<Boolean> states = new Stack();
    private boolean first = true;
    private boolean inObject;
    private String indentString;
    private int indent = 0;

    JsonWriterBase(Appendable appendable, String string) {
        this.appendable = appendable;
        this.indentString = string;
    }

    private SELF castThis() {
        return (SELF)this;
    }

    @Override
    public SELF array(Collection<?> collection) {
        return (SELF)this.array((String)null, (Collection)collection);
    }

    @Override
    public SELF array(String string, Collection<?> collection) {
        if (string == null) {
            this.array();
        } else {
            this.array(string);
        }
        for (Object obj : collection) {
            this.value(obj);
        }
        return (SELF)this.end();
    }

    @Override
    public SELF object(Map<?, ?> map) {
        return (SELF)this.object((String)null, (Map)map);
    }

    @Override
    public SELF object(String string, Map<?, ?> map) {
        if (string == null) {
            this.object();
        } else {
            this.object(string);
        }
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object obj = entry.getValue();
            if (!(entry.getKey() instanceof String)) {
                throw new JsonWriterException("Invalid key type for map: " + (entry.getKey() == null ? "null" : entry.getKey().getClass()));
            }
            String string2 = (String)entry.getKey();
            this.value(string2, obj);
        }
        return (SELF)this.end();
    }

    @Override
    public SELF nul() {
        this.preValue();
        this.raw("null");
        return this.castThis();
    }

    @Override
    public SELF nul(String string) {
        this.preValue(string);
        this.raw("null");
        return this.castThis();
    }

    @Override
    public SELF value(Object object) {
        if (object == null) {
            return (SELF)this.nul();
        }
        if (object instanceof String) {
            return (SELF)this.value((String)object);
        }
        if (object instanceof Number) {
            return (SELF)this.value((Number)object);
        }
        if (object instanceof Boolean) {
            return (SELF)this.value((Boolean)object);
        }
        if (object instanceof Collection) {
            return (SELF)this.array((Collection)object);
        }
        if (object instanceof Map) {
            return (SELF)this.object((Map)object);
        }
        if (object.getClass().isArray()) {
            int n = Array.getLength(object);
            this.array();
            for (int i = 0; i < n; ++i) {
                this.value(Array.get(object, i));
            }
            return (SELF)this.end();
        }
        throw new JsonWriterException("Unable to handle type: " + object.getClass());
    }

    @Override
    public SELF value(String string, Object object) {
        if (object == null) {
            return (SELF)this.nul(string);
        }
        if (object instanceof String) {
            return (SELF)this.value(string, (String)object);
        }
        if (object instanceof Number) {
            return (SELF)this.value(string, (Number)object);
        }
        if (object instanceof Boolean) {
            return (SELF)this.value(string, (Boolean)object);
        }
        if (object instanceof Collection) {
            return (SELF)this.array(string, (Collection)object);
        }
        if (object instanceof Map) {
            return (SELF)this.object(string, (Map)object);
        }
        if (object.getClass().isArray()) {
            int n = Array.getLength(object);
            this.array(string);
            for (int i = 0; i < n; ++i) {
                this.value(Array.get(object, i));
            }
            return (SELF)this.end();
        }
        throw new JsonWriterException("Unable to handle type: " + object.getClass());
    }

    @Override
    public SELF value(String string) {
        if (string == null) {
            return (SELF)this.nul();
        }
        this.preValue();
        this.emitStringValue(string);
        return this.castThis();
    }

    @Override
    public SELF value(int n) {
        this.preValue();
        this.raw(Integer.toString(n));
        return this.castThis();
    }

    @Override
    public SELF value(long l) {
        this.preValue();
        this.raw(Long.toString(l));
        return this.castThis();
    }

    @Override
    public SELF value(boolean bl) {
        this.preValue();
        this.raw(Boolean.toString(bl));
        return this.castThis();
    }

    @Override
    public SELF value(double d) {
        this.preValue();
        this.raw(Double.toString(d));
        return this.castThis();
    }

    @Override
    public SELF value(float f) {
        this.preValue();
        this.raw(Float.toString(f));
        return this.castThis();
    }

    @Override
    public SELF value(Number number) {
        this.preValue();
        if (number == null) {
            this.raw("null");
        } else {
            this.raw(number.toString());
        }
        return this.castThis();
    }

    @Override
    public SELF value(String string, String string2) {
        if (string2 == null) {
            return (SELF)this.nul(string);
        }
        this.preValue(string);
        this.emitStringValue(string2);
        return this.castThis();
    }

    @Override
    public SELF value(String string, int n) {
        this.preValue(string);
        this.raw(Integer.toString(n));
        return this.castThis();
    }

    @Override
    public SELF value(String string, long l) {
        this.preValue(string);
        this.raw(Long.toString(l));
        return this.castThis();
    }

    @Override
    public SELF value(String string, boolean bl) {
        this.preValue(string);
        this.raw(Boolean.toString(bl));
        return this.castThis();
    }

    @Override
    public SELF value(String string, double d) {
        this.preValue(string);
        this.raw(Double.toString(d));
        return this.castThis();
    }

    @Override
    public SELF value(String string, float f) {
        this.preValue(string);
        this.raw(Float.toString(f));
        return this.castThis();
    }

    @Override
    public SELF value(String string, Number number) {
        if (number == null) {
            return (SELF)this.nul(string);
        }
        this.preValue(string);
        this.raw(number.toString());
        return this.castThis();
    }

    @Override
    public SELF array() {
        this.preValue();
        this.states.push(this.inObject);
        this.inObject = false;
        this.first = true;
        this.raw('[');
        return this.castThis();
    }

    @Override
    public SELF object() {
        this.preValue();
        this.states.push(this.inObject);
        this.inObject = true;
        this.first = true;
        this.raw('{');
        if (this.indentString != null) {
            ++this.indent;
            this.appendNewLine();
        }
        return this.castThis();
    }

    @Override
    public SELF array(String string) {
        this.preValue(string);
        this.states.push(this.inObject);
        this.inObject = false;
        this.first = true;
        this.raw('[');
        return this.castThis();
    }

    @Override
    public SELF object(String string) {
        this.preValue(string);
        this.states.push(this.inObject);
        this.inObject = true;
        this.first = true;
        this.raw('{');
        if (this.indentString != null) {
            ++this.indent;
            this.appendNewLine();
        }
        return this.castThis();
    }

    @Override
    public SELF end() {
        if (this.states.size() == 0) {
            throw new JsonWriterException("Invalid call to end()");
        }
        if (this.inObject) {
            if (this.indentString != null) {
                --this.indent;
                this.appendNewLine();
                this.appendIndent();
            }
            this.raw('}');
        } else {
            this.raw(']');
        }
        this.first = false;
        this.inObject = this.states.pop();
        return this.castThis();
    }

    protected void doneInternal() {
        if (this.states.size() > 0) {
            throw new JsonWriterException("Unclosed JSON objects and/or arrays when closing writer");
        }
        if (this.first) {
            throw new JsonWriterException("Nothing was written to the JSON writer");
        }
    }

    private void appendIndent() {
        for (int i = 0; i < this.indent; ++i) {
            this.raw(this.indentString);
        }
    }

    private void appendNewLine() {
        this.raw('\n');
    }

    private void raw(String string) {
        try {
            this.appendable.append(string);
        }
        catch (IOException iOException) {
            throw new JsonWriterException(iOException);
        }
    }

    private void raw(char c) {
        try {
            this.appendable.append(c);
        }
        catch (IOException iOException) {
            throw new JsonWriterException(iOException);
        }
    }

    private void pre() {
        if (this.first) {
            this.first = false;
        } else {
            if (this.states.size() == 0) {
                throw new JsonWriterException("Invalid call to emit a value in a finished JSON writer");
            }
            this.raw(',');
            if (this.indentString != null && this.inObject) {
                this.appendNewLine();
            }
        }
    }

    private void preValue() {
        if (this.inObject) {
            throw new JsonWriterException("Invalid call to emit a keyless value while writing an object");
        }
        this.pre();
    }

    private void preValue(String string) {
        if (!this.inObject) {
            throw new JsonWriterException("Invalid call to emit a key value while not writing an object");
        }
        this.pre();
        if (this.indentString != null) {
            this.appendIndent();
        }
        this.emitStringValue(string);
        this.raw(':');
    }

    private void emitStringValue(String string) {
        this.raw('\"');
        char c = '\u0000';
        char c2 = '\u0000';
        block9: for (int i = 0; i < string.length(); ++i) {
            c = c2;
            c2 = string.charAt(i);
            switch (c2) {
                case '\"': 
                case '\\': {
                    this.raw('\\');
                    this.raw(c2);
                    continue block9;
                }
                case '/': {
                    if (c == '<') {
                        this.raw('\\');
                    }
                    this.raw(c2);
                    continue block9;
                }
                case '\b': {
                    this.raw("\\b");
                    continue block9;
                }
                case '\t': {
                    this.raw("\\t");
                    continue block9;
                }
                case '\n': {
                    this.raw("\\n");
                    continue block9;
                }
                case '\f': {
                    this.raw("\\f");
                    continue block9;
                }
                case '\r': {
                    this.raw("\\r");
                    continue block9;
                }
                default: {
                    if (this.shouldBeEscaped(c2)) {
                        String string2 = "000" + Integer.toHexString(c2);
                        this.raw("\\u" + string2.substring(string2.length() - "0000".length()));
                        continue block9;
                    }
                    this.raw(c2);
                }
            }
        }
        this.raw('\"');
    }

    private boolean shouldBeEscaped(char c) {
        return c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100';
    }
}

