/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.LambdaExp;
import gnu.expr.ScopeExp;

public class ChainLambdas
extends ExpWalker {
    Compilation comp;
    ScopeExp currentScope;

    public static void chainLambdas(Expression exp, Compilation comp) {
        ChainLambdas walker = new ChainLambdas();
        walker.comp = comp;
        exp.walk(walker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Expression walkScopeExp(ScopeExp exp) {
        ScopeExp saveScope = this.currentScope;
        try {
            if (exp.outer == null) {
                exp.outer = this.currentScope;
            }
            this.currentScope = exp;
            exp.walkChildren(this);
            ScopeExp scopeExp = exp;
            return scopeExp;
        }
        finally {
            this.currentScope = saveScope;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Expression walkLambdaExp(LambdaExp exp) {
        LambdaExp parent = this.currentLambda;
        if (parent != null && !(parent instanceof ClassExp)) {
            exp.nextSibling = parent.firstChild;
            parent.firstChild = exp;
        }
        ScopeExp saveScope = this.currentScope;
        try {
            exp.outer = this.currentScope;
            this.currentScope = exp;
            exp.walkChildrenOnly(this);
        }
        finally {
            this.currentScope = saveScope;
        }
        exp.walkProperties(this);
        LambdaExp prev = null;
        LambdaExp child = exp.firstChild;
        while (child != null) {
            LambdaExp next = child.nextSibling;
            child.nextSibling = prev;
            prev = child;
            child = next;
        }
        exp.firstChild = prev;
        if (exp.getName() == null && exp.nameDecl != null) {
            exp.setName(exp.nameDecl.getName());
        }
        return exp;
    }

    protected Expression walkClassExp(ClassExp exp) {
        LambdaExp parent = this.currentLambda;
        if (parent != null && !(parent instanceof ClassExp)) {
            exp.nextSibling = parent.firstChild;
            parent.firstChild = exp;
        }
        this.walkScopeExp(exp);
        exp.getCompiledClassType(this.comp);
        this.comp.addClass(exp.type);
        if (exp.isMakingClassPair()) {
            exp.instanceType.setName(exp.type.getName() + "$class");
            this.comp.addClass(exp.instanceType);
        }
        return exp;
    }
}

