/*
 * Decompiled with CFR 0.152.
 */
package nice.tools.ant;

import bossa.modules.Compilation;
import bossa.modules.fun;
import bossa.parser.JavaccParser;
import java.io.File;
import nice.tools.ant.NicecListener;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;

public class NiceDoc
extends Task {
    private static final String ERROR_MSG = "Generation failed with errors.";
    private static final String BUG_MSG = "Generation failed because of a bug.";
    private static final String WARNING_MSG = "Generation successful despite warnings.";
    private static final String OK_MSG = "Generation successful.";
    private String sourcepath;
    private File destination;
    private String classpath = "";
    private String runtime = null;
    private String pack;
    private Path nestedClasspath = null;

    public void setSourcepath(String string) {
        this.sourcepath = string;
    }

    public void setDestination(File file) {
        this.destination = file;
    }

    public void setClasspath(String string) {
        this.classpath = string;
    }

    public void setRuntime(String string) {
        this.runtime = string;
    }

    public void setPackage(String string) {
        this.pack = string;
    }

    public Path createClasspath() {
        this.nestedClasspath = new Path(this.project);
        return this.nestedClasspath.createPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        String string = System.getProperty("user.dir");
        try {
            System.setProperty("user.dir", this.project.getBaseDir().getAbsolutePath());
            NicecListener nicecListener = new NicecListener(this);
            Compilation compilation = fun.createCompilation(nicecListener, new JavaccParser(true));
            if (this.sourcepath != null) {
                compilation.sourcePath = this.sourcepath;
            }
            compilation.packagePath = this.classpath + (this.nestedClasspath != null ? File.pathSeparator + this.nestedClasspath : "");
            nice.tools.doc.fun.generate(compilation, this.pack, this.destination);
            int n = nicecListener.statusCode;
            switch (n) {
                case 2: {
                    throw new BuildException(ERROR_MSG, this.location);
                }
                case 1: {
                    throw new BuildException(BUG_MSG, this.location);
                }
                case 3: {
                    this.log(WARNING_MSG, 1);
                    return;
                }
                case 0: {
                    this.log(OK_MSG, 2);
                    return;
                }
            }
            return;
        }
        finally {
            System.setProperty("user.dir", string);
        }
    }
}

