/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.ant;

import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.util.DOMElementWriter;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DependencyAnalyzer
extends Task {
    public static final String TAB = "\t";
    List groups = new ArrayList();
    File dir = null;
    File output = null;
    boolean showGroupContent = false;
    Map className2group;
    Set otherClasses = new HashSet();

    public void setDir(File d) {
        this.dir = d;
    }

    public void setOutput(File o) {
        this.output = o;
    }

    public void setShowContent(boolean v) {
        this.showGroupContent = v;
    }

    public Group createGroup() {
        Group group = new Group();
        group.setProject(this.getProject());
        this.groups.add(group);
        return group;
    }

    private void toTxt(OutputStream out) throws IOException {
        StringBuffer sb = new StringBuffer();
        Iterator it = this.groups.iterator();
        while (it.hasNext()) {
            Group cg = (Group)((Object)it.next());
            cg.toString(sb, "");
        }
        DataOutputStream dos = new DataOutputStream(out);
        dos.writeUTF(sb.toString());
        dos.flush();
    }

    private void toXml(OutputStream out) throws IOException {
        DocumentBuilder builder;
        try {
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e1) {
            throw new IOException(e1.getMessage());
        }
        Document doc = builder.newDocument();
        Element rootElement = doc.createElement("dependency");
        doc.appendChild(rootElement);
        Iterator it = this.groups.iterator();
        while (it.hasNext()) {
            Group cg = (Group)((Object)it.next());
            cg.toXml(doc, rootElement);
        }
        Element gd = doc.createElement("otherClasses");
        gd.setAttribute("size", "" + this.otherClasses.size());
        rootElement.appendChild(gd);
        ArrayList classes = new ArrayList(this.otherClasses);
        Collections.sort(classes);
        Iterator it2 = classes.iterator();
        while (it2.hasNext()) {
            Element c = doc.createElement("class");
            c.setAttribute("name", (String)it2.next());
            gd.appendChild(c);
        }
        BufferedWriter wri = null;
        wri = new BufferedWriter(new OutputStreamWriter(out, "UTF8"));
        wri.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
        new DOMElementWriter().write(rootElement, (Writer)wri, 0, "  ");
        ((Writer)wri).flush();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        this.className2group = new HashMap();
        Iterator itg = this.groups.iterator();
        while (itg.hasNext()) {
            Group group = (Group)((Object)itg.next());
            if (group.groupDir == null) {
                group.groupDir = this.dir;
            }
            Iterator itc = group.getSelectedFiles().iterator();
            while (itc.hasNext()) {
                String fn = (String)itc.next();
                this.className2group.put(fn, group);
            }
        }
        DependencyVisitor dv = new DependencyVisitor();
        Iterator itg2 = this.groups.iterator();
        while (itg2.hasNext()) {
            Group group = (Group)((Object)itg2.next());
            this.log("Visit the group: " + group.name, 4);
            Iterator itc = group.getSelectedFiles().iterator();
            while (itc.hasNext()) {
                String fn;
                dv.className = fn = (String)itc.next();
                dv.group = group;
                this.log("Visit the class: " + fn, 4);
                try {
                    File f = new File(group.groupDir, fn);
                    new ClassReader((InputStream)new FileInputStream(f)).accept((ClassVisitor)dv, false);
                }
                catch (FileNotFoundException e) {
                    this.log(e.getMessage(), 0);
                }
                catch (IOException e) {
                    this.log(e.getMessage(), 0);
                }
            }
        }
        OutputStream out = null;
        try {
            try {
                boolean isXmlOutput = false;
                if (this.output == null) {
                    out = System.out;
                } else {
                    this.log("Dependency analyse report: " + this.output.getAbsolutePath());
                    out = new FileOutputStream(this.output);
                    isXmlOutput = this.output.getName().endsWith(".xml");
                }
                if (isXmlOutput) {
                    this.toXml(out);
                } else {
                    this.toTxt(out);
                }
                out.flush();
            }
            catch (IOException exc) {
                throw new BuildException("Unable to write log file", (Throwable)exc);
            }
            Object var8_11 = null;
            if (out == System.out) return;
            if (out == System.err) return;
            if (out == null) return;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            if (out == System.out) throw throwable;
            if (out == System.err) throw throwable;
            if (out == null) throw throwable;
            try {
                out.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        out.close();
        return;
    }

    private class DependencyVisitor
    implements AnnotationVisitor,
    SignatureVisitor,
    ClassVisitor,
    FieldVisitor,
    MethodVisitor {
        public Group group;
        public String className;

        private DependencyVisitor() {
        }

        private boolean addDependency(String dep) {
            ArrayList<String> cns;
            if (dep == null) {
                return false;
            }
            dep = dep.replace('/', File.separatorChar) + ".class";
            DependencyAnalyzer.this.log("has dependency: " + dep, 4);
            Group depGroup = (Group)((Object)DependencyAnalyzer.this.className2group.get(dep));
            if (depGroup == null) {
                DependencyAnalyzer.this.log("no group: " + dep, 4);
                DependencyAnalyzer.this.otherClasses.add(dep);
                return false;
            }
            if (depGroup == this.group) {
                DependencyAnalyzer.this.log("same group", 4);
                return false;
            }
            HashMap<String, ArrayList<String>> classDep = (HashMap<String, ArrayList<String>>)this.group.dependencies.get((Object)depGroup);
            if (classDep == null) {
                DependencyAnalyzer.this.log("first dependency on the group: " + depGroup.name, 4);
                classDep = new HashMap<String, ArrayList<String>>();
                this.group.dependencies.put(depGroup, classDep);
            }
            if ((cns = (ArrayList<String>)classDep.get(this.className)) == null) {
                DependencyAnalyzer.this.log("first dependency for the class: " + this.className, 4);
                cns = new ArrayList<String>();
                classDep.put(this.className, cns);
                cns.add(dep);
                return true;
            }
            if (cns.contains(dep)) {
                DependencyAnalyzer.this.log("existing dependency", 4);
                return false;
            }
            cns.add(dep);
            DependencyAnalyzer.this.log("new dependency", 4);
            return true;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            if (signature == null) {
                this.addDependency(superName);
                this.addNames(interfaces);
            } else {
                this.addSignature(signature);
            }
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            this.addDesc(desc);
            return this;
        }

        public void visitAttribute(Attribute attr) {
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            if (signature == null) {
                this.addDesc(desc);
            } else {
                this.addTypeSignature(signature);
            }
            if (value instanceof Type) {
                this.addType((Type)value);
            }
            return this;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (signature == null) {
                this.addMethodDesc(desc);
            } else {
                this.addSignature(signature);
            }
            this.addNames(exceptions);
            return this;
        }

        public void visitSource(String source, String debug) {
        }

        public void visitInnerClass(String name, String outerName, String innerName, int access) {
        }

        public void visitOuterClass(String owner, String name, String desc) {
        }

        public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
            this.addDesc(desc);
            return this;
        }

        public void visitTypeInsn(int opcode, String desc) {
            if (desc.charAt(0) == '[') {
                this.addDesc(desc);
            } else {
                this.addDependency(desc);
            }
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            this.addDependency(owner);
            this.addDesc(desc);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            this.addDependency(owner);
            this.addMethodDesc(desc);
        }

        public void visitLdcInsn(Object cst) {
            if (cst instanceof Type) {
                this.addType((Type)cst);
            }
        }

        public void visitMultiANewArrayInsn(String desc, int dims) {
            this.addDesc(desc);
        }

        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            this.addTypeSignature(signature);
        }

        public AnnotationVisitor visitAnnotationDefault() {
            return this;
        }

        public void visitCode() {
        }

        public void visitInsn(int opcode) {
        }

        public void visitIntInsn(int opcode, int operand) {
        }

        public void visitVarInsn(int opcode, int var) {
        }

        public void visitJumpInsn(int opcode, Label label) {
        }

        public void visitLabel(Label label) {
        }

        public void visitIincInsn(int var, int increment) {
        }

        public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        }

        public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        }

        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
            this.addDependency(type);
        }

        public void visitLineNumber(int line, Label start) {
        }

        public void visitMaxs(int maxStack, int maxLocals) {
        }

        public void visit(String name, Object value) {
            if (value instanceof Type) {
                this.addType((Type)value);
            }
        }

        public void visitEnum(String name, String desc, String value) {
            this.addDesc(desc);
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            this.addDesc(desc);
            return this;
        }

        public AnnotationVisitor visitArray(String name) {
            return this;
        }

        public void visitFormalTypeParameter(String name) {
        }

        public SignatureVisitor visitClassBound() {
            return this;
        }

        public SignatureVisitor visitInterfaceBound() {
            return this;
        }

        public SignatureVisitor visitSuperclass() {
            return this;
        }

        public SignatureVisitor visitInterface() {
            return this;
        }

        public SignatureVisitor visitParameterType() {
            return this;
        }

        public SignatureVisitor visitReturnType() {
            return this;
        }

        public SignatureVisitor visitExceptionType() {
            return this;
        }

        public void visitBaseType(char descriptor) {
        }

        public void visitTypeVariable(String name) {
        }

        public SignatureVisitor visitArrayType() {
            return this;
        }

        public void visitClassType(String name) {
            this.addDependency(name);
        }

        public void visitInnerClassType(String name) {
            this.addDependency(name);
        }

        public void visitTypeArgument() {
        }

        public SignatureVisitor visitTypeArgument(char wildcard) {
            return this;
        }

        public void visitEnd() {
        }

        private void addNames(String[] names) {
            for (int i = 0; names != null && i < names.length; ++i) {
                this.addDependency(names[i]);
            }
        }

        private void addDesc(String desc) {
            this.addType(Type.getType((String)desc));
        }

        private void addMethodDesc(String desc) {
            this.addType(Type.getReturnType((String)desc));
            Type[] types = Type.getArgumentTypes((String)desc);
            for (int i = 0; i < types.length; ++i) {
                this.addType(types[i]);
            }
        }

        private void addType(Type t) {
            switch (t.getSort()) {
                case 9: {
                    this.addType(t.getElementType());
                    break;
                }
                case 10: {
                    this.addDependency(t.getClassName().replace('.', '/'));
                }
            }
        }

        private void addSignature(String signature) {
            if (signature != null) {
                new SignatureReader(signature).accept((SignatureVisitor)this);
            }
        }

        private void addTypeSignature(String signature) {
            if (signature != null) {
                new SignatureReader(signature).acceptType((SignatureVisitor)this);
            }
        }
    }

    public class Group
    extends MatchingTask {
        public String name;
        private String filterClassName;
        private ClassFilter filter;
        private List selectedFiles;
        private File groupDir;
        public Map dependencies = new HashMap();

        public void setName(String n) {
            this.name = n;
        }

        public void setFilter(String filterClass) {
            this.filterClassName = filterClass;
        }

        public void setDir(File d) {
            this.groupDir = d;
        }

        public Collection getSelectedFiles() {
            if (this.selectedFiles == null) {
                this.selectedFiles = Arrays.asList(this.getDirectoryScanner(this.groupDir).getIncludedFiles());
                List<String> toDeselct = Arrays.asList(this.getDirectoryScanner(this.groupDir).getExcludedFiles());
                this.log(toDeselct.toString(), 4);
                this.selectedFiles.removeAll(toDeselct);
                if (this.filterClassName != null) {
                    try {
                        this.filter = (ClassFilter)Class.forName(this.filterClassName).newInstance();
                    }
                    catch (Exception e) {
                        throw new BuildException(e.getMessage(), (Throwable)e);
                    }
                    Iterator it = this.selectedFiles.iterator();
                    while (it.hasNext()) {
                        String fn = (String)it.next();
                        if (this.filter.accept(new File(DependencyAnalyzer.this.dir, fn))) continue;
                        it.remove();
                    }
                }
                Collections.sort(this.selectedFiles);
            }
            return this.selectedFiles;
        }

        public void toString(StringBuffer sb, String t0) {
            Iterator it;
            String t1 = t0 + DependencyAnalyzer.TAB;
            String t2 = t1 + DependencyAnalyzer.TAB;
            String t3 = t2 + DependencyAnalyzer.TAB;
            sb.append(t0).append("Group: ").append(this.name).append("\n");
            if (DependencyAnalyzer.this.showGroupContent) {
                sb.append(t1).append("contains: \n");
                it = this.getSelectedFiles().iterator();
                while (it.hasNext()) {
                    String fn = (String)((Object)it.next());
                    sb.append(t2).append(fn).append("\n");
                }
            }
            it = this.dependencies.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry me = it.next();
                Group cg = (Group)((Object)me.getKey());
                Map realDep = (Map)me.getValue();
                sb.append(t1).append("depends on ").append(cg.name).append(": \n");
                Iterator it2 = realDep.entrySet().iterator();
                while (it2.hasNext()) {
                    Map.Entry me2 = it2.next();
                    String cn = (String)me2.getKey();
                    List cdeps = (List)me2.getValue();
                    sb.append(t2).append("class: ").append(cn).append(" depends on:\n");
                    Iterator it3 = cdeps.iterator();
                    while (it3.hasNext()) {
                        sb.append(t3).append(it3.next()).append("\n");
                    }
                }
            }
        }

        public void toXml(Document doc, Element parent) {
            Iterator it;
            Element group = doc.createElement("group");
            group.setAttribute("name", this.name);
            parent.appendChild(group);
            if (DependencyAnalyzer.this.showGroupContent) {
                Element gc = doc.createElement("group-content");
                gc.setAttribute("size", "" + this.getSelectedFiles().size());
                group.appendChild(gc);
                it = this.getSelectedFiles().iterator();
                while (it.hasNext()) {
                    String fn = (String)it.next();
                    Element c = doc.createElement("class");
                    c.setAttribute("name", fn);
                    gc.appendChild(c);
                }
            }
            ArrayList grouplist = new ArrayList(this.dependencies.keySet());
            Collections.sort(grouplist, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((Group)((Object)o1)).name.compareTo(((Group)((Object)o2)).name);
                }
            });
            it = grouplist.iterator();
            while (it.hasNext()) {
                Group cg = (Group)((Object)it.next());
                Map realDep = (Map)this.dependencies.get((Object)cg);
                Element gd = doc.createElement("group-dependency");
                gd.setAttribute("group-name", cg.name);
                gd.setAttribute("size", "" + realDep.size());
                group.appendChild(gd);
                ArrayList classlist = new ArrayList(realDep.keySet());
                Collections.sort(classlist);
                Iterator it2 = classlist.iterator();
                while (it2.hasNext()) {
                    String cn = (String)it2.next();
                    List cdeps = (List)realDep.get(cn);
                    Collections.sort(cdeps);
                    Element c = doc.createElement("class");
                    c.setAttribute("name", cn);
                    c.setAttribute("size", "" + cdeps.size());
                    gd.appendChild(c);
                    Iterator it3 = cdeps.iterator();
                    while (it3.hasNext()) {
                        Element cd = doc.createElement("class-dependency");
                        cd.setAttribute("name", (String)it3.next());
                        c.appendChild(cd);
                    }
                }
            }
        }
    }

    public static interface ClassFilter {
        public boolean accept(File var1);
    }
}

