/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.ant;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.CallTarget;
import org.apache.tools.ant.taskdefs.Property;

public class TokenizedAntCall
extends CallTarget {
    private String tokenList = "";
    private String separators = " ";
    private String tokenVarName = "token";
    private ArrayList props = new ArrayList();

    public Property createParam() {
        Property p = super.createParam();
        this.props.add(p);
        return p;
    }

    public String getTokenList() {
        return this.tokenList;
    }

    public void setTokenList(String tokenList) {
        this.tokenList = tokenList;
    }

    public String getSeparators() {
        return this.separators;
    }

    public void setSeparators(String separators) {
        this.separators = separators;
    }

    public String getTokenVarName() {
        return this.tokenVarName;
    }

    public void setTokenVarName(String tokenVarName) {
        this.tokenVarName = tokenVarName;
    }

    public void execute() throws BuildException {
        this.log("tokenList=" + this.tokenList, 4);
        this.tokenList = this.getVal(this.tokenList)[0];
        this.log("effective TokenList=" + this.tokenList, 4);
        this.log("separators=" + this.separators, 4);
        StringTokenizer st = new StringTokenizer(this.tokenList, this.separators, false);
        while (st.hasMoreTokens()) {
            String tokenValue = st.nextToken();
            this.log("token value=" + tokenValue, 4);
            Property prop = super.createParam();
            prop.setName(this.tokenVarName);
            prop.setValue(tokenValue);
            super.execute();
            if (!st.hasMoreTokens()) continue;
            Iterator it = this.props.iterator();
            while (it.hasNext()) {
                Property old = (Property)it.next();
                Property neo = super.createParam();
                neo.setName(old.getName());
                neo.setValue(old.getValue());
            }
        }
    }

    private String[] getVal(String s) throws BuildException {
        int begin = s.indexOf("${");
        int end = s.indexOf("}");
        if (begin == -1) {
            if (end == -1) {
                return new String[]{s, ""};
            }
            return new String[]{s.substring(0, end), s.substring(end + 1)};
        }
        if (end == -1) {
            throw new BuildException("${ without } in the expression " + s);
        }
        if (end < begin) {
            return new String[]{s.substring(0, end), s.substring(end + 1)};
        }
        String res = s.substring(0, begin);
        String[] ss = this.getVal(s.substring(begin + 2));
        if (ss[0].length() > 0) {
            String varValue = this.getProject().getProperty(ss[0]);
            if (varValue == null) {
                throw new BuildException("No variable '" + ss[0] + "' found");
            }
            res = res + varValue;
        }
        String[] t = this.getVal(ss[1]);
        res = res + t[0];
        return new String[]{res, t[1]};
    }
}

