/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.edit;

import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSString;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.PDPage;
import org.pdfbox.pdmodel.PDResources;
import org.pdfbox.pdmodel.common.COSStreamArray;
import org.pdfbox.pdmodel.common.PDStream;
import org.pdfbox.pdmodel.font.PDFont;
import org.pdfbox.pdmodel.graphics.xobject.PDXObjectImage;

public class PDPageContentStream {
    private PDPage page;
    private Writer output;
    private boolean inTextMode = false;
    private Map fontMappings = new HashMap();
    private Map imageMappings = new HashMap();
    private int fontNumber = 1;
    private int imageNumber = 1;
    private PDResources resources;
    private NumberFormat formatDecimal = NumberFormat.getNumberInstance();
    private static final String BEGIN_TEXT = "BT\n";
    private static final String END_TEXT = "ET\n";
    private static final String SET_FONT = "Tf\n";
    private static final String MOVE_TEXT_POSITION = "Td\n";
    private static final String SHOW_TEXT = "Tj\n";
    private static final String SAVE_GRAPHICS_STATE = "q\n";
    private static final String RESTORE_GRAPHICS_STATE = "Q\n";
    private static final String CONCATENATE_MATRIX = "cm\n";
    private static final String XOBJECT_DO = "Do\n";
    private static final String RG_STROKING = "RG\n";
    private static final String RG_NON_STROKING = "rg\n";
    private static final String APPEND_RECTANGLE = "re\n";
    private static final String FILL = "f\n";
    private static final int SPACE = 32;

    public PDPageContentStream(PDDocument document, PDPage sourcePage) throws IOException {
        this(document, sourcePage, false);
    }

    public PDPageContentStream(PDDocument document, PDPage sourcePage, boolean appendContent) throws IOException {
        this.page = sourcePage;
        this.resources = this.page.getResources();
        if (this.resources == null) {
            this.resources = new PDResources();
            this.page.setResources(this.resources);
        }
        if (appendContent) {
            PDStream contents = sourcePage.getContents();
            PDStream contentsToAppend = new PDStream(document);
            COSStreamArray compoundStream = null;
            if (contents.getStream() instanceof COSStreamArray) {
                compoundStream = (COSStreamArray)contents.getStream();
                compoundStream.appendStream(contentsToAppend.getStream());
            } else {
                COSArray newArray = new COSArray();
                newArray.add(contents.getCOSObject());
                newArray.add(contentsToAppend.getCOSObject());
                compoundStream = new COSStreamArray(newArray);
            }
            ArrayList<COSName> filters = new ArrayList<COSName>();
            filters.add(COSName.FLATE_DECODE);
            contentsToAppend.setFilters(filters);
            sourcePage.setContents(new PDStream(compoundStream));
            this.output = new OutputStreamWriter(contentsToAppend.createOutputStream(), "ISO-8859-1");
        } else {
            PDStream contents = new PDStream(document);
            ArrayList<COSName> filters = new ArrayList<COSName>();
            filters.add(COSName.FLATE_DECODE);
            contents.setFilters(filters);
            sourcePage.setContents(contents);
            this.output = new OutputStreamWriter(contents.createOutputStream(), "ISO-8859-1");
        }
        this.formatDecimal.setMaximumFractionDigits(10);
        this.formatDecimal.setGroupingUsed(false);
    }

    public void beginText() throws IOException {
        if (this.inTextMode) {
            throw new IOException("Error: Nested beginText() calls are not allowed.");
        }
        this.output.write(BEGIN_TEXT);
        this.inTextMode = true;
    }

    public void endText() throws IOException {
        if (!this.inTextMode) {
            throw new IOException("Error: You must call beginText() before calling endText.");
        }
        this.output.write(END_TEXT);
        this.inTextMode = false;
    }

    public void setFont(PDFont font, float fontSize) throws IOException {
        String fontMapping = (String)this.fontMappings.get(font);
        if (fontMapping == null) {
            fontMapping = "F" + this.fontNumber++;
            this.fontMappings.put(font, fontMapping);
            this.resources.getFonts().put(fontMapping, font);
        }
        this.output.write("/");
        this.output.write(fontMapping);
        this.output.write(32);
        this.output.write(this.formatDecimal.format(fontSize));
        this.output.write(32);
        this.output.write(SET_FONT);
    }

    public void drawImage(PDXObjectImage image, int x, int y) throws IOException {
        this.drawImage(image, x, y, image.getWidth(), image.getHeight());
    }

    public void drawImage(PDXObjectImage image, int x, int y, int width, int height) throws IOException {
        String imageMapping = (String)this.imageMappings.get(image);
        if (imageMapping == null) {
            imageMapping = "Im" + this.imageNumber++;
            this.imageMappings.put(image, imageMapping);
            this.resources.getImages().put(imageMapping, image);
        }
        this.output.write(SAVE_GRAPHICS_STATE);
        this.output.write(this.formatDecimal.format(width));
        this.output.write(32);
        this.output.write(this.formatDecimal.format(0L));
        this.output.write(32);
        this.output.write(this.formatDecimal.format(0L));
        this.output.write(32);
        this.output.write(this.formatDecimal.format(height));
        this.output.write(32);
        this.output.write(this.formatDecimal.format(x));
        this.output.write(32);
        this.output.write(this.formatDecimal.format(y));
        this.output.write(32);
        this.output.write(CONCATENATE_MATRIX);
        this.output.write(32);
        this.output.write("/");
        this.output.write(imageMapping);
        this.output.write(32);
        this.output.write(XOBJECT_DO);
        this.output.write(32);
        this.output.write(RESTORE_GRAPHICS_STATE);
    }

    public void moveTextPositionByAmount(float x, float y) throws IOException {
        this.output.write(this.formatDecimal.format(x));
        this.output.write(32);
        this.output.write(this.formatDecimal.format(y));
        this.output.write(32);
        this.output.write(MOVE_TEXT_POSITION);
    }

    public void drawString(String text) throws IOException {
        COSString string = new COSString(text);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        string.writePDF(buffer);
        this.output.write(new String(buffer.toByteArray(), "ISO-8859-1"));
        this.output.write(32);
        this.output.write(SHOW_TEXT);
    }

    public void setStrokingColor(Color color) throws IOException {
        this.setStrokingColor(color.getRed(), color.getGreen(), color.getBlue());
    }

    public void setNonStrokingColor(Color color) throws IOException {
        this.setNonStrokingColor(color.getRed(), color.getGreen(), color.getBlue());
    }

    public void setStrokingColor(int r, int g, int b) throws IOException {
        this.output.write(this.formatDecimal.format((double)r / 255.0));
        this.output.write(32);
        this.output.write(this.formatDecimal.format((double)g / 255.0));
        this.output.write(32);
        this.output.write(this.formatDecimal.format((double)b / 255.0));
        this.output.write(32);
        this.output.write(RG_STROKING);
    }

    public void setNonStrokingColor(int r, int g, int b) throws IOException {
        this.output.write(this.formatDecimal.format((double)r / 255.0));
        this.output.write(32);
        this.output.write(this.formatDecimal.format((double)g / 255.0));
        this.output.write(32);
        this.output.write(this.formatDecimal.format((double)b / 255.0));
        this.output.write(32);
        this.output.write(RG_NON_STROKING);
    }

    public void fillRect(float x, float y, float width, float height) throws IOException {
        this.output.write(this.formatDecimal.format(x));
        this.output.write(32);
        this.output.write(this.formatDecimal.format(y));
        this.output.write(32);
        this.output.write(this.formatDecimal.format(width));
        this.output.write(32);
        this.output.write(this.formatDecimal.format(height));
        this.output.write(32);
        this.output.write(APPEND_RECTANGLE);
        this.output.write(FILL);
    }

    public void appendRawCommands(String commands) throws IOException {
        this.output.write(commands);
    }

    public void close() throws IOException {
        this.output.close();
    }
}

