/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.ttf;

import java.io.IOException;
import org.pdfbox.ttf.GlyphData;
import org.pdfbox.ttf.IndexToLocationTable;
import org.pdfbox.ttf.MaximumProfileTable;
import org.pdfbox.ttf.PostScriptTable;
import org.pdfbox.ttf.TTFDataStream;
import org.pdfbox.ttf.TTFTable;
import org.pdfbox.ttf.TrueTypeFont;

public class GlyphTable
extends TTFTable {
    public static final String TAG = "glyf";
    private GlyphData[] glyphs;

    public void initData(TrueTypeFont ttf, TTFDataStream data) throws IOException {
        MaximumProfileTable maxp = ttf.getMaximumProfile();
        IndexToLocationTable loc = ttf.getIndexToLocation();
        PostScriptTable post = ttf.getPostScript();
        long[] offsets = loc.getOffsets();
        int numGlyphs = maxp.getNumGlyphs();
        this.glyphs = new GlyphData[numGlyphs];
        String[] glyphNames = post.getGlyphNames();
        for (int i = 0; i < numGlyphs - 1; ++i) {
            GlyphData glyph = new GlyphData();
            data.seek(this.getOffset() + offsets[i]);
            glyph.initData(ttf, data);
            this.glyphs[i] = glyph;
        }
    }

    public GlyphData[] getGlyphs() {
        return this.glyphs;
    }

    public void setGlyphs(GlyphData[] glyphsValue) {
        this.glyphs = glyphsValue;
    }
}

