/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.Utils;
import com.puppycrawl.tools.checkstyle.checks.AbstractHeaderCheck;
import java.util.Arrays;
import org.apache.commons.beanutils.ConversionException;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class RegexpHeaderCheck
extends AbstractHeaderCheck {
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private int[] mMultiLines = EMPTY_INT_ARRAY;
    private RE[] mHeaderRegexps;

    private boolean isMultiLine(int aLineNo) {
        return Arrays.binarySearch(this.mMultiLines, aLineNo + 1) >= 0;
    }

    public void setMultiLines(int[] aList) {
        if (aList == null || aList.length == 0) {
            this.mMultiLines = EMPTY_INT_ARRAY;
            return;
        }
        this.mMultiLines = new int[aList.length];
        System.arraycopy(aList, 0, this.mMultiLines, 0, aList.length);
        Arrays.sort(this.mMultiLines);
    }

    public void setHeaderFile(String aFileName) throws ConversionException {
        super.setHeaderFile(aFileName);
        this.initHeaderRegexps();
    }

    public void setHeader(String aHeader) {
        super.setHeader(aHeader);
        this.initHeaderRegexps();
    }

    private void initHeaderRegexps() {
        String[] headerLines = this.getHeaderLines();
        if (headerLines != null) {
            this.mHeaderRegexps = new RE[headerLines.length];
            for (int i = 0; i < headerLines.length; ++i) {
                try {
                    this.mHeaderRegexps[i] = Utils.getRE(headerLines[i]);
                    continue;
                }
                catch (RESyntaxException ex) {
                    throw new ConversionException("line " + i + " in header specification" + " is not a regular expression");
                }
            }
        }
    }

    private boolean isMatch(int aLineNo, int aHeaderLineNo) {
        String line = this.getLines()[aLineNo];
        return this.mHeaderRegexps[aHeaderLineNo].match(line);
    }

    public void beginTree(DetailAST aRootAST) {
        int fileSize;
        int headerSize = this.getHeaderLines().length;
        if (headerSize - this.mMultiLines.length > (fileSize = this.getLines().length)) {
            this.log(1, "header.missing");
        } else {
            int i;
            int headerLineNo = 0;
            for (i = 0; headerLineNo < headerSize && i < fileSize; ++i) {
                boolean isMatch = this.isMatch(i, headerLineNo);
                while (!isMatch && this.isMultiLine(headerLineNo)) {
                    isMatch = ++headerLineNo == headerSize || this.isMatch(i, headerLineNo);
                }
                if (!isMatch) {
                    this.log(i + 1, "header.mismatch", (Object)this.getHeaderLines()[headerLineNo]);
                    break;
                }
                if (this.isMultiLine(headerLineNo)) continue;
                ++headerLineNo;
            }
            if (i == fileSize) {
                while (headerLineNo < headerSize) {
                    if (!this.isMultiLine(headerLineNo)) {
                        this.log(1, "header.missing");
                        break;
                    }
                    ++headerLineNo;
                }
            }
        }
    }
}

