/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.indentation;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.indentation.ExpressionHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentLevel;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentationCheck;
import com.puppycrawl.tools.checkstyle.checks.indentation.LineSet;

public class MethodCallHandler
extends ExpressionHandler {
    public MethodCallHandler(IndentationCheck aIndentCheck, DetailAST aAst, ExpressionHandler aParent) {
        super(aIndentCheck, aAst.getType() == 43 ? "ctor call" : "method call", aAst, aParent);
    }

    private void checkLParen() {
        DetailAST lparen = this.getMainAst();
        int columnNo = this.expandedTabsColumnNo(lparen);
        if (this.getLevel().accept(columnNo)) {
            return;
        }
        if (!this.startsLine(lparen)) {
            return;
        }
        this.logError(lparen, "lparen", columnNo);
    }

    private void checkRParen() {
        DetailAST rparen = this.getMainAst().findFirstToken(77);
        int columnNo = this.expandedTabsColumnNo(rparen);
        if (this.getLevel().accept(columnNo)) {
            return;
        }
        if (!this.startsLine(rparen)) {
            return;
        }
        this.logError(rparen, "rparen", columnNo);
    }

    public IndentLevel getLevelImpl() {
        if (this.getParent() instanceof MethodCallHandler) {
            MethodCallHandler container = (MethodCallHandler)this.getParent();
            if (container != null) {
                if (MethodCallHandler.areOnSameLine(container.getMainAst(), this.getMainAst())) {
                    return container.getLevel();
                }
                return new IndentLevel(container.getLevel(), this.getBasicOffset());
            }
            ExpressionHandler p = this.getParent();
            while (p instanceof MethodCallHandler) {
                p = p.getParent();
            }
            return p.suggestedChildLevel(this);
        }
        LineSet lines = new LineSet();
        this.findSubtreeLines(lines, (DetailAST)this.getMainAst().getFirstChild(), true);
        int firstCol = lines.firstLineCol();
        int lineStart = this.getLineStart(this.getFirstAst(this.getMainAst()));
        if (lineStart != firstCol) {
            return new IndentLevel(lineStart);
        }
        return super.getLevelImpl();
    }

    private DetailAST getFirstAst(DetailAST aAst) {
        DetailAST ast;
        for (ast = (DetailAST)aAst.getFirstChild(); ast != null && ast.getType() == 59; ast = (DetailAST)ast.getFirstChild()) {
        }
        if (ast == null) {
            ast = aAst;
        }
        return ast;
    }

    public IndentLevel suggestedChildLevel(ExpressionHandler aChild) {
        DetailAST first = (DetailAST)this.getMainAst().getFirstChild();
        int indentLevel = this.getLineStart(first);
        if (aChild instanceof MethodCallHandler && !MethodCallHandler.areOnSameLine((DetailAST)aChild.getMainAst().getFirstChild(), (DetailAST)this.getMainAst().getFirstChild())) {
            indentLevel += this.getBasicOffset();
        }
        return new IndentLevel(indentLevel);
    }

    public void checkIndentation() {
        DetailAST methodName = (DetailAST)this.getMainAst().getFirstChild();
        this.checkExpressionSubtree(methodName, this.getLevel(), false, false);
        this.checkLParen();
        DetailAST rparen = this.getMainAst().findFirstToken(77);
        DetailAST lparen = this.getMainAst();
        if (rparen.getLineNo() != lparen.getLineNo()) {
            this.checkExpressionSubtree(this.getMainAst().findFirstToken(34), new IndentLevel(this.getLevel(), this.getBasicOffset()), false, true);
            this.checkRParen();
        }
    }

    protected boolean shouldIncreaseIndent() {
        return false;
    }
}

