/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.Utils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FallThroughCheck
extends Check {
    private boolean mCheckLastGroup;
    private String mReliefPattern = "fallthru|falls? ?through";
    private Pattern mRegExp;

    public int[] getDefaultTokens() {
        return new int[]{33};
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void setReliefPattern(String aPattern) {
        this.mReliefPattern = aPattern;
    }

    public void setCheckLastCaseGroup(boolean aValue) {
        this.mCheckLastGroup = aValue;
    }

    public void init() {
        super.init();
        this.mRegExp = Utils.getPattern(this.mReliefPattern);
    }

    public void visitToken(DetailAST aAST) {
        boolean isLastGroup;
        DetailAST nextGroup = (DetailAST)aAST.getNextSibling();
        boolean bl = isLastGroup = nextGroup == null || nextGroup.getType() != 33;
        if (isLastGroup && !this.mCheckLastGroup) {
            return;
        }
        DetailAST slist = aAST.findFirstToken(7);
        if (!this.isTerminated(slist, true, true) && !this.hasFallTruComment(aAST, nextGroup)) {
            if (!isLastGroup) {
                this.log(nextGroup, "fall.through");
            } else {
                this.log(aAST, "fall.through.last");
            }
        }
    }

    private boolean isTerminated(DetailAST aAST, boolean aUseBreak, boolean aUseContinue) {
        switch (aAST.getType()) {
            case 88: 
            case 90: {
                return true;
            }
            case 86: {
                return aUseBreak;
            }
            case 87: {
                return aUseContinue;
            }
            case 7: {
                return this.checkSlist(aAST, aUseBreak, aUseContinue);
            }
            case 83: {
                return this.checkIf(aAST, aUseBreak, aUseContinue);
            }
            case 84: 
            case 85: 
            case 91: {
                return this.checkLoop(aAST);
            }
            case 95: {
                return this.checkTry(aAST, aUseBreak, aUseContinue);
            }
            case 89: {
                return this.checkSwitch(aAST, aUseContinue);
            }
        }
        return false;
    }

    private boolean checkSlist(DetailAST aAST, boolean aUseBreak, boolean aUseContinue) {
        DetailAST lastStmt = aAST.getLastChild();
        if (lastStmt.getType() == 73) {
            lastStmt = lastStmt.getPreviousSibling();
        }
        return lastStmt != null && this.isTerminated(lastStmt, aUseBreak, aUseContinue);
    }

    private boolean checkIf(DetailAST aAST, boolean aUseBreak, boolean aUseContinue) {
        DetailAST thenStmt = (DetailAST)aAST.findFirstToken(77).getNextSibling();
        DetailAST elseStmt = (DetailAST)thenStmt.getNextSibling();
        boolean isTerminated = this.isTerminated(thenStmt, aUseBreak, aUseContinue);
        if (isTerminated && elseStmt != null) {
            isTerminated = this.isTerminated((DetailAST)elseStmt.getFirstChild(), aUseBreak, aUseContinue);
        }
        return isTerminated;
    }

    private boolean checkLoop(DetailAST aAST) {
        DetailAST loopBody = null;
        if (aAST.getType() == 85) {
            DetailAST lparen = aAST.findFirstToken(175);
            loopBody = lparen.getPreviousSibling();
        } else {
            DetailAST rparen = aAST.findFirstToken(77);
            loopBody = (DetailAST)rparen.getNextSibling();
        }
        return this.isTerminated(loopBody, false, false);
    }

    private boolean checkTry(DetailAST aAST, boolean aUseBreak, boolean aUseContinue) {
        DetailAST catchBody;
        DetailAST finalStmt = aAST.getLastChild();
        if (finalStmt.getType() == 97) {
            return this.isTerminated(finalStmt.findFirstToken(7), aUseBreak, aUseContinue);
        }
        boolean isTerminated = this.isTerminated((DetailAST)aAST.getFirstChild(), aUseBreak, aUseContinue);
        for (DetailAST catchStmt = aAST.findFirstToken(96); catchStmt != null && isTerminated; isTerminated &= this.isTerminated(catchBody, aUseBreak, aUseContinue), catchStmt = (DetailAST)catchStmt.getNextSibling()) {
            catchBody = catchStmt.findFirstToken(7);
        }
        return isTerminated;
    }

    private boolean checkSwitch(DetailAST aAST, boolean aUseContinue) {
        boolean isTerminated;
        DetailAST caseGroup = aAST.findFirstToken(33);
        boolean bl = isTerminated = caseGroup != null;
        while (isTerminated && caseGroup != null && caseGroup.getType() != 73) {
            DetailAST caseBody = caseGroup.findFirstToken(7);
            isTerminated &= this.isTerminated(caseBody, false, aUseContinue);
            caseGroup = (DetailAST)caseGroup.getNextSibling();
        }
        return isTerminated;
    }

    private boolean hasFallTruComment(DetailAST aCurrentCase, DetailAST aNextCase) {
        int startLineNo = aCurrentCase.getLineNo();
        int endLineNo = aNextCase.getLineNo();
        int endColNo = aNextCase.getColumnNo();
        String[] lines = this.getLines();
        String linepart = lines[endLineNo - 1].substring(0, endColNo);
        if (this.commentMatch(this.mRegExp, linepart, endLineNo)) {
            return true;
        }
        for (int i = endLineNo - 2; i > startLineNo - 1; --i) {
            if (lines[i].trim().length() == 0) continue;
            return this.commentMatch(this.mRegExp, lines[i], i + 1);
        }
        return false;
    }

    private boolean commentMatch(Pattern aPattern, String aLine, int aLineNo) {
        Matcher matcher = aPattern.matcher(aLine);
        boolean hit = matcher.find();
        if (hit) {
            int startMatch = matcher.start();
            int endMatch = matcher.end() - 1;
            return this.getFileContents().hasIntersectionWithComment(aLineNo, startMatch, aLineNo, endMatch);
        }
        return false;
    }
}

