/* PgSqlClient - ADO.NET Data Provider for PostgreSQL 7.4+
 * Copyright (c) 2003-2004 Carlos Guzman Alvarez
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;
using System.Data;
using System.ComponentModel;
using System.ComponentModel.Design.Serialization;
using System.Globalization;
using System.Reflection;

namespace PostgreSql.Data.PgSqlClient.Design
{
	internal class PgParameterConverter : TypeConverter
	{
		public override bool CanConvertTo(ITypeDescriptorContext context, Type destinationType) 
		{
			if (destinationType == typeof(InstanceDescriptor)) 
			{
				return true;
			}

			return base.CanConvertTo(context, destinationType);
		}

		public override object ConvertTo(ITypeDescriptorContext context, 
			CultureInfo culture, object value, Type destinationType) 
		{
			if (destinationType == typeof(InstanceDescriptor) && 
				value is PgParameter) 
			{
				PgParameter param = (PgParameter)value;

				ConstructorInfo ctor = typeof(PgParameter).GetConstructor(
					new Type[] {typeof(string)	, typeof(PgDbType), 
								   typeof(int)	, typeof(ParameterDirection),
								   typeof(bool)	, typeof(byte),
								   typeof(byte)	, typeof(string),
								   typeof(DataRowVersion), typeof(object)
							   });
				
				if (ctor != null)
				{
					return new InstanceDescriptor(ctor, 
						new object[] {
										 param.ParameterName	, param.PgDbType,
										 param.Size				, param.Direction,
										 param.IsNullable		, param.Precision,
										 param.Scale			, param.SourceColumn,
										 param.SourceVersion	, param.Value
									 });
				}
			}

			return base.ConvertTo(context, culture, value, destinationType);      
		}
	}
}
