/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.jaxen;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sourceforge.pmd.ast.Node;
import net.sourceforge.pmd.jaxen.Attribute;

public class AttributeAxisIterator
implements Iterator {
    private Object currObj;
    private MethodWrapper[] methodWrappers;
    private int position;
    private Node node;
    private static Map methodCache = new HashMap();

    public AttributeAxisIterator(Node contextNode) {
        this.node = contextNode;
        if (!methodCache.containsKey(contextNode.getClass())) {
            Method[] preFilter = contextNode.getClass().getMethods();
            ArrayList<MethodWrapper> postFilter = new ArrayList<MethodWrapper>();
            for (int i = 0; i < preFilter.length; ++i) {
                if (!this.isAttributeAccessor(preFilter[i])) continue;
                postFilter.add(new MethodWrapper(preFilter[i]));
            }
            methodCache.put(contextNode.getClass(), postFilter.toArray(new MethodWrapper[postFilter.size()]));
        }
        this.methodWrappers = (MethodWrapper[])methodCache.get(contextNode.getClass());
        this.position = 0;
        this.currObj = this.getNextAttribute();
    }

    public Object next() {
        if (this.currObj == null) {
            throw new IndexOutOfBoundsException();
        }
        Object ret = this.currObj;
        this.currObj = this.getNextAttribute();
        return ret;
    }

    public boolean hasNext() {
        return this.currObj != null;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    private Attribute getNextAttribute() {
        if (this.position == this.methodWrappers.length) {
            return null;
        }
        MethodWrapper m = this.methodWrappers[this.position++];
        return new Attribute(this.node, m.name, m.method);
    }

    protected boolean isAttributeAccessor(Method method) {
        String methodName = method.getName();
        return (Integer.TYPE == method.getReturnType() || Boolean.TYPE == method.getReturnType() || String.class == method.getReturnType()) && method.getParameterTypes().length == 0 && Void.TYPE != method.getReturnType() && !methodName.startsWith("jjt") && !methodName.equals("toString") && !methodName.equals("getScope") && !methodName.equals("getClass") && !methodName.equals("getTypeNameNode") && !methodName.equals("getImportedNameNode") && !methodName.equals("hashCode");
    }

    private static class MethodWrapper {
        public Method method;
        public String name;

        public MethodWrapper(Method m) {
            this.method = m;
            this.name = this.truncateMethodName(m.getName());
        }

        private String truncateMethodName(String n) {
            if (n.startsWith("get")) {
                return n.substring("get".length());
            }
            if (n.startsWith("is")) {
                return n.substring("is".length());
            }
            if (n.startsWith("has")) {
                return n.substring("has".length());
            }
            if (n.startsWith("uses")) {
                return n.substring("uses".length());
            }
            return n;
        }
    }
}

