/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules.design;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.ast.ASTAssignmentOperator;
import net.sourceforge.pmd.ast.ASTCompilationUnit;
import net.sourceforge.pmd.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.ast.ASTIfStatement;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.ast.ASTName;
import net.sourceforge.pmd.ast.ASTNullLiteral;
import net.sourceforge.pmd.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.ast.ASTStatementExpression;
import net.sourceforge.pmd.properties.BooleanProperty;

public class NonThreadSafeSingleton
extends AbstractRule {
    private Map fieldDecls = new HashMap();
    private boolean checkNonStaticMethods = true;
    private boolean checkNonStaticFields = true;
    private static final PropertyDescriptor checkNonStaticMethodsDescriptor = new BooleanProperty("checkNonStaticMethods", "Check for non-static methods.", true, 1.0f);
    private static final PropertyDescriptor checkNonStaticFieldsDescriptor = new BooleanProperty("checkNonStaticFields", "Check for non-static fields.", true, 2.0f);
    private static final Map propertyDescriptorsByName = NonThreadSafeSingleton.asFixedMap(new PropertyDescriptor[]{checkNonStaticMethodsDescriptor, checkNonStaticFieldsDescriptor});
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTSynchronizedStatement;
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTNullLiteral;
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTName;
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTAssignmentOperator;
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTStatementExpression;
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTPrimaryExpression;
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTPrimaryPrefix;
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTPrimarySuffix;

    public Object visit(ASTCompilationUnit node, Object data) {
        this.fieldDecls.clear();
        this.checkNonStaticMethods = this.getBooleanProperty(checkNonStaticMethodsDescriptor);
        this.checkNonStaticFields = this.getBooleanProperty(checkNonStaticFieldsDescriptor);
        return super.visit(node, data);
    }

    public Object visit(ASTFieldDeclaration node, Object data) {
        if (this.checkNonStaticFields || node.isStatic()) {
            this.fieldDecls.put(node.getVariableName(), node);
        }
        return super.visit(node, data);
    }

    public Object visit(ASTMethodDeclaration node, Object data) {
        if (this.checkNonStaticMethods && !node.isStatic() || node.isSynchronized()) {
            return super.visit(node, data);
        }
        List ifStatements = node.findChildrenOfType(ASTIfStatement.class);
        Iterator iter = ifStatements.iterator();
        while (iter.hasNext()) {
            ASTName Name;
            ASTNullLiteral NullLiteral;
            ASTIfStatement ifStatement = (ASTIfStatement)iter.next();
            if (ifStatement.getFirstParentOfType(class$net$sourceforge$pmd$ast$ASTSynchronizedStatement == null ? NonThreadSafeSingleton.class$("net.sourceforge.pmd.ast.ASTSynchronizedStatement") : class$net$sourceforge$pmd$ast$ASTSynchronizedStatement) != null || (NullLiteral = (ASTNullLiteral)ifStatement.getFirstChildOfType(class$net$sourceforge$pmd$ast$ASTNullLiteral == null ? NonThreadSafeSingleton.class$("net.sourceforge.pmd.ast.ASTNullLiteral") : class$net$sourceforge$pmd$ast$ASTNullLiteral)) == null || (Name = (ASTName)ifStatement.getFirstChildOfType(class$net$sourceforge$pmd$ast$ASTName == null ? NonThreadSafeSingleton.class$("net.sourceforge.pmd.ast.ASTName") : class$net$sourceforge$pmd$ast$ASTName)) == null || !this.fieldDecls.containsKey(Name.getImage())) continue;
            List assigmnents = ifStatement.findChildrenOfType(class$net$sourceforge$pmd$ast$ASTAssignmentOperator == null ? NonThreadSafeSingleton.class$("net.sourceforge.pmd.ast.ASTAssignmentOperator") : class$net$sourceforge$pmd$ast$ASTAssignmentOperator);
            boolean violation = false;
            for (int ix = 0; ix < assigmnents.size(); ++ix) {
                ASTStatementExpression expr;
                ASTAssignmentOperator oper = (ASTAssignmentOperator)assigmnents.get(ix);
                if (!oper.jjtGetParent().getClass().equals(class$net$sourceforge$pmd$ast$ASTStatementExpression == null ? NonThreadSafeSingleton.class$("net.sourceforge.pmd.ast.ASTStatementExpression") : class$net$sourceforge$pmd$ast$ASTStatementExpression) || !(expr = (ASTStatementExpression)oper.jjtGetParent()).jjtGetChild(0).getClass().equals(class$net$sourceforge$pmd$ast$ASTPrimaryExpression == null ? NonThreadSafeSingleton.class$("net.sourceforge.pmd.ast.ASTPrimaryExpression") : class$net$sourceforge$pmd$ast$ASTPrimaryExpression) || !((ASTPrimaryExpression)expr.jjtGetChild(0)).jjtGetChild(0).getClass().equals(class$net$sourceforge$pmd$ast$ASTPrimaryPrefix == null ? NonThreadSafeSingleton.class$("net.sourceforge.pmd.ast.ASTPrimaryPrefix") : class$net$sourceforge$pmd$ast$ASTPrimaryPrefix)) continue;
                ASTPrimaryPrefix pp = (ASTPrimaryPrefix)((ASTPrimaryExpression)expr.jjtGetChild(0)).jjtGetChild(0);
                String name = null;
                if (pp.usesThisModifier()) {
                    ASTPrimarySuffix priSuf = (ASTPrimarySuffix)expr.getFirstChildOfType(class$net$sourceforge$pmd$ast$ASTPrimarySuffix == null ? NonThreadSafeSingleton.class$("net.sourceforge.pmd.ast.ASTPrimarySuffix") : class$net$sourceforge$pmd$ast$ASTPrimarySuffix);
                    name = priSuf.getImage();
                } else {
                    ASTName astName = (ASTName)pp.jjtGetChild(0);
                    name = astName.getImage();
                }
                if (!this.fieldDecls.containsKey(name)) continue;
                violation = true;
            }
            if (!violation) continue;
            this.addViolation(data, ifStatement);
        }
        return super.visit(node, data);
    }

    protected Map propertiesByName() {
        return propertyDescriptorsByName;
    }
}

