/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.SourceType;
import net.sourceforge.pmd.TargetJDK1_3;
import net.sourceforge.pmd.TargetJDK1_4;
import net.sourceforge.pmd.TargetJDK1_5;
import net.sourceforge.pmd.TargetJDK1_6;
import net.sourceforge.pmd.ast.Node;
import net.sourceforge.pmd.ast.ParseException;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.jaxen.DocumentNavigator;
import net.sourceforge.pmd.jaxen.MatchesFunction;
import net.sourceforge.pmd.jsp.ast.JspCharStream;
import net.sourceforge.pmd.jsp.ast.JspParser;
import net.sourceforge.pmd.util.NumericConstants;
import net.sourceforge.pmd.util.StringUtil;
import net.sourceforge.pmd.util.designer.CodeEditorTextPane;
import net.sourceforge.pmd.util.designer.CreateXMLRulePanel;
import net.sourceforge.pmd.util.designer.DFAGraphRule;
import net.sourceforge.pmd.util.designer.DFAPanel;
import net.sourceforge.pmd.util.designer.MyPrintStream;
import org.jaxen.BaseXPath;
import org.jaxen.JaxenException;

public class Designer
implements ClipboardOwner {
    private static final char LABEL_IMAGE_SEPARATOR = ':';
    private static final Color IMAGE_TEXT_COLOR = Color.BLUE;
    private static final Parser jdkParser1_3 = new Parser(){

        public SimpleNode parse(StringReader sr) {
            return new TargetJDK1_3().createParser(sr).CompilationUnit();
        }
    };
    private static final Parser jdkParser1_4 = new Parser(){

        public SimpleNode parse(StringReader sr) {
            return new TargetJDK1_4().createParser(sr).CompilationUnit();
        }
    };
    private static final Parser jdkParser1_5 = new Parser(){

        public SimpleNode parse(StringReader sr) {
            return new TargetJDK1_5().createParser(sr).CompilationUnit();
        }
    };
    private static final Parser jdkParser1_6 = new Parser(){

        public SimpleNode parse(StringReader sr) {
            return new TargetJDK1_6().createParser(sr).CompilationUnit();
        }
    };
    private static final Parser jspParser = new Parser(){

        public SimpleNode parse(StringReader sr) {
            return new JspParser(new JspCharStream(sr)).CompilationUnit();
        }
    };
    private static final Object[][] sourceTypeSets = new Object[][]{{"JDK 1.3", SourceType.JAVA_13, jdkParser1_3}, {"JDK 1.4", SourceType.JAVA_14, jdkParser1_4}, {"JDK 1.5", SourceType.JAVA_15, jdkParser1_5}, {"JDK 1.6", SourceType.JAVA_16, jdkParser1_6}, {"JSP", SourceType.JSP, jspParser}};
    private static final int defaultSourceTypeSelectionIndex = 1;
    private final CodeEditorTextPane codeEditorPane = new CodeEditorTextPane();
    private final ASTTreeWidget astWidget = new ASTTreeWidget(new Vector());
    private DefaultListModel xpathResults = new DefaultListModel();
    private final JList xpathResultList = new JList(this.xpathResults);
    private final JTextArea xpathQueryArea = new JTextArea(15, 30);
    private final JFrame frame = new JFrame("PMD Rule Designer");
    private final DFAPanel dfaPanel = new DFAPanel();
    private final JRadioButtonMenuItem[] sourceTypeMenuItems = new JRadioButtonMenuItem[sourceTypeSets.length];

    private SimpleNode getCompilationUnit() {
        Parser parser = (Parser)sourceTypeSets[this.selectedSourceTypeIndex()][2];
        return parser.parse(new StringReader(this.codeEditorPane.getText()));
    }

    private SourceType getSourceType() {
        return (SourceType)sourceTypeSets[this.selectedSourceTypeIndex()][1];
    }

    private int selectedSourceTypeIndex() {
        for (int i = 0; i < this.sourceTypeMenuItems.length; ++i) {
            if (!this.sourceTypeMenuItems[i].isSelected()) continue;
            return i;
        }
        throw new RuntimeException("Initial default source type not specified");
    }

    private void loadTreeData(TreeNode rootNode) {
        this.astWidget.setModel(new DefaultTreeModel(rootNode));
        this.astWidget.expandAll(true);
    }

    public Designer() {
        MatchesFunction.registerSelfInSimpleContext();
        this.xpathQueryArea.setFont(new Font("Verdana", 0, 16));
        Designer.makeTextComponentUndoable(this.codeEditorPane);
        JSplitPane controlSplitPane = new JSplitPane(1, new JScrollPane(this.codeEditorPane), this.createXPathQueryPanel());
        JSplitPane resultsSplitPane = new JSplitPane(1, this.createASTPanel(), this.createXPathResultPanel());
        JTabbedPane tabbed = new JTabbedPane();
        tabbed.addTab("Abstract Syntax Tree / XPath", resultsSplitPane);
        tabbed.addTab("Data Flow Analysis", this.dfaPanel);
        try {
            Method setMnemonicAt = JTabbedPane.class.getMethod("setMnemonicAt", Integer.TYPE, Integer.TYPE);
            if (setMnemonicAt != null) {
                setMnemonicAt.invoke((Object)tabbed, NumericConstants.ZERO, new Integer(65));
                setMnemonicAt.invoke((Object)tabbed, NumericConstants.ONE, new Integer(68));
            }
        }
        catch (NoSuchMethodException nsme) {
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new InternalError("Runtime reports to be >= JDK 1.4 yet String.split(java.lang.String) is broken.");
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new InternalError("Runtime reports to be >= JDK 1.4 yet String.split(java.lang.String) is broken.");
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            throw new InternalError("Runtime reports to be >= JDK 1.4 yet String.split(java.lang.String) is broken.");
        }
        JSplitPane containerSplitPane = new JSplitPane(0, controlSplitPane, tabbed);
        containerSplitPane.setContinuousLayout(true);
        JMenuBar menuBar = this.createMenuBar();
        this.frame.setJMenuBar(menuBar);
        this.frame.getContentPane().add(containerSplitPane);
        this.frame.setDefaultCloseOperation(3);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int screenHeight = screenSize.height;
        int screenWidth = screenSize.width;
        this.frame.pack();
        this.frame.setSize(screenWidth * 3 / 4, screenHeight * 3 / 4);
        this.frame.setLocation((screenWidth - this.frame.getWidth()) / 2, (screenHeight - this.frame.getHeight()) / 2);
        this.frame.setVisible(true);
        resultsSplitPane.setDividerLocation(resultsSplitPane.getMaximumDividerLocation() - resultsSplitPane.getMaximumDividerLocation() / 2);
        containerSplitPane.setDividerLocation(containerSplitPane.getMaximumDividerLocation() / 2);
    }

    private JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("JDK");
        ButtonGroup group = new ButtonGroup();
        for (int i = 0; i < sourceTypeSets.length; ++i) {
            JRadioButtonMenuItem button;
            this.sourceTypeMenuItems[i] = button = new JRadioButtonMenuItem(sourceTypeSets[i][0].toString());
            group.add(button);
            menu.add(button);
        }
        this.sourceTypeMenuItems[1].setSelected(true);
        menuBar.add(menu);
        JMenu actionsMenu = new JMenu("Actions");
        JMenuItem copyXMLItem = new JMenuItem("Copy xml to clipboard");
        copyXMLItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Designer.this.copyXmlToClipboard();
            }
        });
        actionsMenu.add(copyXMLItem);
        JMenuItem createRuleXMLItem = new JMenuItem("Create rule XML");
        createRuleXMLItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Designer.this.createRuleXML();
            }
        });
        actionsMenu.add(createRuleXMLItem);
        menuBar.add(actionsMenu);
        return menuBar;
    }

    private void createRuleXML() {
        CreateXMLRulePanel rulePanel = new CreateXMLRulePanel(this.xpathQueryArea, this.codeEditorPane);
        JFrame xmlframe = new JFrame("Create XML Rule");
        xmlframe.setContentPane(rulePanel);
        xmlframe.setDefaultCloseOperation(2);
        xmlframe.setSize(new Dimension(600, 700));
        xmlframe.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                JFrame tmp = (JFrame)e.getSource();
                if (tmp.getWidth() < 600 || tmp.getHeight() < 700) {
                    tmp.setSize(600, 700);
                }
            }
        });
        int screenHeight = Toolkit.getDefaultToolkit().getScreenSize().height;
        int screenWidth = Toolkit.getDefaultToolkit().getScreenSize().width;
        xmlframe.pack();
        xmlframe.setLocation((screenWidth - xmlframe.getWidth()) / 2, (screenHeight - xmlframe.getHeight()) / 2);
        xmlframe.setVisible(true);
    }

    private JComponent createASTPanel() {
        this.astWidget.setCellRenderer(new ASTCellRenderer());
        return new JScrollPane(this.astWidget);
    }

    private JComponent createXPathResultPanel() {
        this.xpathResults.addElement("No results yet");
        this.xpathResultList.setBorder(BorderFactory.createLineBorder(Color.black));
        this.xpathResultList.setFixedCellWidth(300);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getViewport().setView(this.xpathResultList);
        return scrollPane;
    }

    private JPanel createXPathQueryPanel() {
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        this.xpathQueryArea.setBorder(BorderFactory.createLineBorder(Color.black));
        Designer.makeTextComponentUndoable(this.xpathQueryArea);
        JScrollPane scrollPane = new JScrollPane(this.xpathQueryArea);
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setVerticalScrollBarPolicy(20);
        JButton b = this.createGoButton();
        p.add((Component)new JLabel("XPath Query (if any)"), "North");
        p.add((Component)scrollPane, "Center");
        p.add((Component)b, "South");
        return p;
    }

    private JButton createGoButton() {
        JButton b = new JButton("Go");
        b.setMnemonic('g');
        b.addActionListener(new ShowListener());
        b.addActionListener(this.codeEditorPane);
        b.addActionListener(new XPathListener());
        b.addActionListener(new DFAListener());
        return b;
    }

    private static void makeTextComponentUndoable(JTextComponent textConponent) {
        final UndoManager undoManager = new UndoManager();
        textConponent.getDocument().addUndoableEditListener(new UndoableEditListener(){

            public void undoableEditHappened(UndoableEditEvent evt) {
                undoManager.addEdit(evt.getEdit());
            }
        });
        ActionMap actionMap = textConponent.getActionMap();
        InputMap inputMap = textConponent.getInputMap();
        actionMap.put("Undo", new AbstractAction("Undo"){

            public void actionPerformed(ActionEvent evt) {
                try {
                    if (undoManager.canUndo()) {
                        undoManager.undo();
                    }
                }
                catch (CannotUndoException cannotUndoException) {
                    // empty catch block
                }
            }
        });
        inputMap.put(KeyStroke.getKeyStroke("control Z"), "Undo");
        actionMap.put("Redo", new AbstractAction("Redo"){

            public void actionPerformed(ActionEvent evt) {
                try {
                    if (undoManager.canRedo()) {
                        undoManager.redo();
                    }
                }
                catch (CannotRedoException cannotRedoException) {
                    // empty catch block
                }
            }
        });
        inputMap.put(KeyStroke.getKeyStroke("control Y"), "Redo");
    }

    public static void main(String[] args) {
        new Designer();
    }

    private final void copyXmlToClipboard() {
        if (this.codeEditorPane.getText() != null && this.codeEditorPane.getText().trim().length() > 0) {
            String xml = "";
            SimpleNode cu = this.getCompilationUnit();
            if (cu != null) {
                try {
                    xml = this.getXmlString(cu);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    xml = "Error trying to construct XML representation";
                }
            }
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(xml), this);
        }
    }

    private String getXmlString(SimpleNode node) throws IOException {
        return "FIXME";
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    private class XPathListener
    implements ActionListener {
        private XPathListener() {
        }

        public void actionPerformed(ActionEvent ae) {
            Designer.this.xpathResults.clear();
            if (Designer.this.xpathQueryArea.getText().length() == 0) {
                Designer.this.xpathResults.addElement("XPath query field is empty");
                Designer.this.xpathResultList.repaint();
                Designer.this.codeEditorPane.requestFocus();
                return;
            }
            SimpleNode c = Designer.this.getCompilationUnit();
            try {
                BaseXPath xpath = new BaseXPath(Designer.this.xpathQueryArea.getText(), new DocumentNavigator());
                Iterator iter = xpath.selectNodes(c).iterator();
                while (iter.hasNext()) {
                    StringBuffer sb = new StringBuffer();
                    Object obj = iter.next();
                    if (obj instanceof String) {
                        System.out.println("Result was a string: " + (String)obj);
                        continue;
                    }
                    if (obj instanceof Boolean) continue;
                    SimpleNode node = (SimpleNode)obj;
                    String name = node.getClass().getName().substring(node.getClass().getName().lastIndexOf(46) + 1);
                    String line = " at line " + node.getBeginLine();
                    sb.append(name).append(line).append(PMD.EOL);
                    Designer.this.xpathResults.addElement(sb.toString().trim());
                }
                if (Designer.this.xpathResults.isEmpty()) {
                    Designer.this.xpathResults.addElement("No matching nodes " + System.currentTimeMillis());
                }
            }
            catch (ParseException pe) {
                Designer.this.xpathResults.addElement(pe.fillInStackTrace().getMessage());
            }
            catch (JaxenException je) {
                Designer.this.xpathResults.addElement(je.fillInStackTrace().getMessage());
            }
            Designer.this.xpathResultList.repaint();
            Designer.this.xpathQueryArea.requestFocus();
        }
    }

    private class DFAListener
    implements ActionListener {
        private DFAListener() {
        }

        public void actionPerformed(ActionEvent ae) {
            DFAGraphRule dfaGraphRule = new DFAGraphRule();
            RuleSet rs = new RuleSet();
            SourceType sourceType = Designer.this.getSourceType();
            if (!sourceType.equals(SourceType.JSP)) {
                rs.addRule(dfaGraphRule);
            }
            RuleContext ctx = new RuleContext();
            ctx.setSourceCodeFilename("[no filename]");
            StringReader reader = new StringReader(Designer.this.codeEditorPane.getText());
            PMD pmd = new PMD();
            pmd.setJavaVersion(sourceType);
            try {
                pmd.processFile((Reader)reader, rs, ctx);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            List methods = dfaGraphRule.getMethods();
            if (methods != null && !methods.isEmpty()) {
                Designer.this.dfaPanel.resetTo(methods, Designer.this.codeEditorPane);
                Designer.this.dfaPanel.repaint();
            }
        }
    }

    private class ShowListener
    implements ActionListener {
        private ShowListener() {
        }

        public void actionPerformed(ActionEvent ae) {
            TreeNode tn;
            MyPrintStream ps = new MyPrintStream();
            System.setOut(ps);
            try {
                SimpleNode lastCompilationUnit = Designer.this.getCompilationUnit();
                tn = new ASTTreeNode(lastCompilationUnit);
            }
            catch (ParseException pe) {
                tn = new ExceptionNode(pe);
            }
            Designer.this.loadTreeData(tn);
        }
    }

    private class ASTTreeWidget
    extends JTree {
        public ASTTreeWidget(Vector items) {
            super(items);
        }

        public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value == null) {
                return "";
            }
            if (value instanceof ASTTreeNode) {
                return ((ASTTreeNode)value).label();
            }
            if (value instanceof ExceptionNode) {
                return ((ExceptionNode)value).label();
            }
            return value.toString();
        }

        public void expandAll(boolean expand) {
            TreeNode root = (TreeNode)this.getModel().getRoot();
            this.expandAll(new TreePath(root), expand);
        }

        private void expandAll(TreePath parent, boolean expand) {
            TreeNode node = (TreeNode)parent.getLastPathComponent();
            if (node.getChildCount() >= 0) {
                Enumeration<? extends TreeNode> e = node.children();
                while (e.hasMoreElements()) {
                    TreeNode n = e.nextElement();
                    TreePath path = parent.pathByAddingChild(n);
                    this.expandAll(path, expand);
                }
            }
            if (expand) {
                this.expandPath(parent);
            } else {
                this.collapsePath(parent);
            }
        }
    }

    private class ASTCellRenderer
    extends DefaultTreeCellRenderer {
        private ASTTreeNode node;

        private ASTCellRenderer() {
        }

        public Icon getIcon() {
            return null;
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value instanceof ASTTreeNode) {
                this.node = (ASTTreeNode)value;
            }
            return super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        }

        public void paint(Graphics g) {
            super.paint(g);
            if (this.node == null) {
                return;
            }
            String text = this.node.label();
            int separatorPos = text.indexOf(58);
            if (separatorPos < 0) {
                return;
            }
            String label = text.substring(0, separatorPos + 1);
            String image = text.substring(separatorPos + 1);
            FontMetrics fm = g.getFontMetrics();
            int width = SwingUtilities.computeStringWidth(fm, label);
            g.setColor(IMAGE_TEXT_COLOR);
            g.drawString(image, width, fm.getMaxAscent());
        }
    }

    private class ASTTreeNode
    implements TreeNode {
        private Node node;
        private ASTTreeNode parent;
        private ASTTreeNode[] kids;

        public ASTTreeNode(Node theNode) {
            this.node = theNode;
            Node prnt = this.node.jjtGetParent();
            if (prnt != null) {
                this.parent = new ASTTreeNode(prnt);
            }
        }

        public int getChildCount() {
            return this.node.jjtGetNumChildren();
        }

        public boolean getAllowsChildren() {
            return false;
        }

        public boolean isLeaf() {
            return this.node.jjtGetNumChildren() == 0;
        }

        public TreeNode getParent() {
            return this.parent;
        }

        public Enumeration children() {
            if (this.getChildCount() > 0) {
                this.getChildAt(0);
            }
            Enumeration e = new Enumeration(this){
                int i;
                private final /* synthetic */ ASTTreeNode this$1;
                {
                    this.this$1 = this$1;
                    this.i = 0;
                }

                public boolean hasMoreElements() {
                    return ASTTreeNode.access$100(this.this$1) != null && this.i < ASTTreeNode.access$100(this.this$1).length;
                }

                public Object nextElement() {
                    return ASTTreeNode.access$100(this.this$1)[this.i++];
                }
            };
            return e;
        }

        public TreeNode getChildAt(int childIndex) {
            if (this.kids == null) {
                this.kids = new ASTTreeNode[this.node.jjtGetNumChildren()];
                for (int i = 0; i < this.kids.length; ++i) {
                    this.kids[i] = new ASTTreeNode(this.node.jjtGetChild(i));
                }
            }
            return this.kids[childIndex];
        }

        public int getIndex(TreeNode node) {
            for (int i = 0; i < this.kids.length; ++i) {
                if (this.kids[i] != node) continue;
                return i;
            }
            return -1;
        }

        public String label() {
            if (this.node instanceof SimpleNode) {
                SimpleNode sn = (SimpleNode)this.node;
                if (sn.getLabel() != null) {
                    return this.node.toString() + ':' + sn.getLabel();
                }
                if (sn.getImage() == null) {
                    return this.node.toString();
                }
                return this.node.toString() + ':' + sn.getImage();
            }
            return this.node.toString();
        }

        static /* synthetic */ ASTTreeNode[] access$100(ASTTreeNode x0) {
            return x0.kids;
        }
    }

    private class ExceptionNode
    implements TreeNode {
        private Object item;
        private ExceptionNode[] kids;

        public ExceptionNode(Object theItem) {
            this.item = theItem;
            if (this.item instanceof ParseException) {
                this.createKids();
            }
        }

        private void createKids() {
            String message = ((ParseException)this.item).getMessage();
            String[] lines = StringUtil.substringsOf(message, PMD.EOL);
            this.kids = new ExceptionNode[lines.length];
            for (int i = 0; i < lines.length; ++i) {
                this.kids[i] = new ExceptionNode(lines[i]);
            }
        }

        public int getChildCount() {
            return this.kids == null ? 0 : this.kids.length;
        }

        public boolean getAllowsChildren() {
            return false;
        }

        public boolean isLeaf() {
            return this.kids == null;
        }

        public TreeNode getParent() {
            return null;
        }

        public TreeNode getChildAt(int childIndex) {
            return this.kids[childIndex];
        }

        public String label() {
            return this.item.toString();
        }

        public Enumeration children() {
            Enumeration e = new Enumeration(this){
                int i;
                private final /* synthetic */ ExceptionNode this$1;
                {
                    this.this$1 = this$1;
                    this.i = 0;
                }

                public boolean hasMoreElements() {
                    return ExceptionNode.access$000(this.this$1) != null && this.i < ExceptionNode.access$000(this.this$1).length;
                }

                public Object nextElement() {
                    return ExceptionNode.access$000(this.this$1)[this.i++];
                }
            };
            return e;
        }

        public int getIndex(TreeNode node) {
            for (int i = 0; i < this.kids.length; ++i) {
                if (this.kids[i] != node) continue;
                return i;
            }
            return -1;
        }

        static /* synthetic */ ExceptionNode[] access$000(ExceptionNode x0) {
            return x0.kids;
        }
    }

    private static interface Parser {
        public SimpleNode parse(StringReader var1);
    }
}

