/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunction;
import org.mozilla.javascript.IdScriptable;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;

final class NativeBoolean
extends IdScriptable {
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_toSource = 3;
    private static final int Id_valueOf = 4;
    private static final int MAX_PROTOTYPE_ID = 4;
    private boolean booleanValue;
    private boolean prototypeFlag;

    static void init(Context cx, Scriptable scope, boolean sealed) {
        NativeBoolean obj = new NativeBoolean(false);
        obj.prototypeFlag = true;
        obj.addAsPrototype(4, cx, scope, sealed);
    }

    private NativeBoolean(boolean b) {
        this.booleanValue = b;
    }

    public String getClassName() {
        return "Boolean";
    }

    public Object getDefaultValue(Class typeHint) {
        if (typeHint == ScriptRuntime.BooleanClass) {
            return this.wrap_boolean(this.booleanValue);
        }
        return super.getDefaultValue(typeHint);
    }

    public int methodArity(int methodId) {
        if (this.prototypeFlag) {
            if (methodId == 1) {
                return 1;
            }
            if (methodId == 2) {
                return 0;
            }
            if (methodId == 3) {
                return 0;
            }
            if (methodId == 4) {
                return 0;
            }
        }
        return super.methodArity(methodId);
    }

    public Object execMethod(int methodId, IdFunction f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        if (this.prototypeFlag) {
            if (methodId == 1) {
                boolean b = ScriptRuntime.toBoolean(args, 0);
                if (thisObj == null) {
                    return new NativeBoolean(b);
                }
                return this.wrap_boolean(b);
            }
            if (methodId == 2) {
                return NativeBoolean.realThisBoolean(thisObj, f) ? "true" : "false";
            }
            if (methodId == 3) {
                if (NativeBoolean.realThisBoolean(thisObj, f)) {
                    return "(new Boolean(true))";
                }
                return "(new Boolean(false))";
            }
            if (methodId == 4) {
                return this.wrap_boolean(NativeBoolean.realThisBoolean(thisObj, f));
            }
        }
        return super.execMethod(methodId, f, cx, scope, thisObj, args);
    }

    private static boolean realThisBoolean(Scriptable thisObj, IdFunction f) {
        if (!(thisObj instanceof NativeBoolean)) {
            throw IdScriptable.incompatibleCallError(f);
        }
        return ((NativeBoolean)thisObj).booleanValue;
    }

    protected String getIdName(int id) {
        if (this.prototypeFlag) {
            if (id == 1) {
                return "constructor";
            }
            if (id == 2) {
                return "toString";
            }
            if (id == 3) {
                return "toSource";
            }
            if (id == 4) {
                return "valueOf";
            }
        }
        return null;
    }

    protected int mapNameToId(String s) {
        if (!this.prototypeFlag) {
            return 0;
        }
        int id = 0;
        String X = null;
        int s_length = s.length();
        if (s_length == 7) {
            X = "valueOf";
            id = 4;
        } else if (s_length == 8) {
            char c = s.charAt(3);
            if (c == 'o') {
                X = "toSource";
                id = 3;
            } else if (c == 't') {
                X = "toString";
                id = 2;
            }
        } else if (s_length == 11) {
            X = "constructor";
            id = 1;
        }
        if (X != null && X != s && !X.equals(s)) {
            id = 0;
        }
        return id;
    }
}

