/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.openjpa.lib.jdbc.ConnectionDecorator;
import org.apache.openjpa.lib.jdbc.DelegatingConnection;
import org.apache.openjpa.lib.jdbc.DelegatingPreparedStatement;
import org.apache.openjpa.lib.jdbc.DelegatingStatement;
import org.apache.openjpa.lib.jdbc.JDBCEvent;
import org.apache.openjpa.lib.jdbc.JDBCListener;
import org.apache.openjpa.lib.util.concurrent.AbstractConcurrentEventManager;

public class JDBCEventConnectionDecorator
extends AbstractConcurrentEventManager
implements ConnectionDecorator {
    public Connection decorate(Connection conn) {
        if (!this.hasListeners()) {
            return conn;
        }
        return new EventConnection(conn);
    }

    private JDBCEvent fireEvent(Connection source, short type, JDBCEvent associatedEvent, Statement stmnt, String sql2) {
        if (!this.hasListeners()) {
            return null;
        }
        JDBCEvent event = new JDBCEvent(source, type, associatedEvent, stmnt, sql2);
        this.fireEvent(event);
        return event;
    }

    protected void fireEvent(Object event, Object listener) {
        JDBCListener listen = (JDBCListener)listener;
        JDBCEvent ev = (JDBCEvent)event;
        switch (ev.getType()) {
            case 1: {
                listen.beforePrepareStatement(ev);
                break;
            }
            case 2: {
                listen.afterPrepareStatement(ev);
                break;
            }
            case 3: {
                listen.beforeCreateStatement(ev);
                break;
            }
            case 4: {
                listen.afterCreateStatement(ev);
                break;
            }
            case 5: {
                listen.beforeExecuteStatement(ev);
                break;
            }
            case 6: {
                listen.afterExecuteStatement(ev);
                break;
            }
            case 7: {
                listen.beforeCommit(ev);
                break;
            }
            case 8: {
                listen.afterCommit(ev);
                break;
            }
            case 9: {
                listen.beforeRollback(ev);
                break;
            }
            case 10: {
                listen.afterRollback(ev);
                break;
            }
            case 11: {
                listen.afterConnect(ev);
                break;
            }
            case 12: {
                listen.beforeClose(ev);
            }
        }
    }

    private class EventStatement
    extends DelegatingStatement {
        private final EventConnection _conn;

        public EventStatement(Statement stmnt, EventConnection conn) {
            super(stmnt, conn);
            this._conn = conn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int executeUpdate(String sql2) throws SQLException {
            JDBCEvent before = JDBCEventConnectionDecorator.this.fireEvent(this._conn.getDelegate(), (short)5, null, this.getDelegate(), sql2);
            try {
                int n = super.executeUpdate(sql2);
                return n;
            }
            finally {
                JDBCEventConnectionDecorator.this.fireEvent(this._conn.getDelegate(), (short)6, before, this.getDelegate(), sql2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ResultSet executeQuery(String sql2, boolean wrap) throws SQLException {
            JDBCEvent before = JDBCEventConnectionDecorator.this.fireEvent(this._conn.getDelegate(), (short)5, null, this.getDelegate(), sql2);
            try {
                ResultSet resultSet = super.executeQuery(sql2, wrap);
                return resultSet;
            }
            finally {
                JDBCEventConnectionDecorator.this.fireEvent(this._conn.getDelegate(), (short)6, before, this.getDelegate(), sql2);
            }
        }
    }

    private class EventPreparedStatement
    extends DelegatingPreparedStatement {
        private final EventConnection _conn;
        private final String _sql;

        public EventPreparedStatement(PreparedStatement ps, EventConnection conn, String sql2) {
            super(ps, conn);
            this._conn = conn;
            this._sql = sql2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int executeUpdate() throws SQLException {
            JDBCEvent before = JDBCEventConnectionDecorator.this.fireEvent(this._conn.getDelegate(), (short)5, null, this.getDelegate(), this._sql);
            try {
                int n = super.executeUpdate();
                return n;
            }
            finally {
                JDBCEventConnectionDecorator.this.fireEvent(this._conn.getDelegate(), (short)6, before, this.getDelegate(), this._sql);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ResultSet executeQuery(boolean wrap) throws SQLException {
            JDBCEvent before = JDBCEventConnectionDecorator.this.fireEvent(this._conn.getDelegate(), (short)5, null, this.getDelegate(), this._sql);
            try {
                ResultSet resultSet = super.executeQuery(wrap);
                return resultSet;
            }
            finally {
                JDBCEventConnectionDecorator.this.fireEvent(this._conn.getDelegate(), (short)6, before, this.getDelegate(), this._sql);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int[] executeBatch() throws SQLException {
            JDBCEvent before = JDBCEventConnectionDecorator.this.fireEvent(this._conn.getDelegate(), (short)5, null, this.getDelegate(), this._sql);
            try {
                int[] nArray = super.executeBatch();
                return nArray;
            }
            finally {
                JDBCEventConnectionDecorator.this.fireEvent(this._conn.getDelegate(), (short)6, before, this.getDelegate(), this._sql);
            }
        }
    }

    private class EventConnection
    extends DelegatingConnection {
        public EventConnection(Connection conn) {
            super(conn);
            JDBCEventConnectionDecorator.this.fireEvent(this.getDelegate(), (short)11, null, null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void commit() throws SQLException {
            JDBCEvent before = JDBCEventConnectionDecorator.this.fireEvent(this.getDelegate(), (short)7, null, null, null);
            try {
                super.commit();
            }
            finally {
                JDBCEventConnectionDecorator.this.fireEvent(this.getDelegate(), (short)8, before, null, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void rollback() throws SQLException {
            JDBCEvent before = JDBCEventConnectionDecorator.this.fireEvent(this.getDelegate(), (short)9, null, null, null);
            try {
                super.rollback();
            }
            finally {
                JDBCEventConnectionDecorator.this.fireEvent(this.getDelegate(), (short)10, before, null, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Statement createStatement(boolean wrap) throws SQLException {
            JDBCEvent before = JDBCEventConnectionDecorator.this.fireEvent(this.getDelegate(), (short)3, null, null, null);
            EventStatement stmnt = null;
            try {
                stmnt = new EventStatement(super.createStatement(false), this);
            }
            finally {
                JDBCEventConnectionDecorator.this.fireEvent(this.getDelegate(), (short)4, before, stmnt, null);
            }
            return stmnt;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Statement createStatement(int rsType, int rsConcur, boolean wrap) throws SQLException {
            JDBCEvent before = JDBCEventConnectionDecorator.this.fireEvent(this.getDelegate(), (short)3, null, null, null);
            EventStatement stmnt = null;
            try {
                stmnt = new EventStatement(super.createStatement(rsType, rsConcur, false), this);
            }
            catch (Throwable throwable) {
                JDBCEventConnectionDecorator.this.fireEvent(this.getDelegate(), (short)4, before, stmnt, null);
                throw throwable;
            }
            JDBCEventConnectionDecorator.this.fireEvent(this.getDelegate(), (short)4, before, stmnt, null);
            return stmnt;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected PreparedStatement prepareStatement(String sql2, boolean wrap) throws SQLException {
            JDBCEvent before = JDBCEventConnectionDecorator.this.fireEvent(this.getDelegate(), (short)1, null, null, sql2);
            EventPreparedStatement stmnt = null;
            try {
                stmnt = new EventPreparedStatement(super.prepareStatement(sql2, false), this, sql2);
            }
            catch (Throwable throwable) {
                JDBCEventConnectionDecorator.this.fireEvent(this.getDelegate(), (short)2, before, stmnt, sql2);
                throw throwable;
            }
            JDBCEventConnectionDecorator.this.fireEvent(this.getDelegate(), (short)2, before, stmnt, sql2);
            return stmnt;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected PreparedStatement prepareStatement(String sql2, int rsType, int rsConcur, boolean wrap) throws SQLException {
            JDBCEvent before = JDBCEventConnectionDecorator.this.fireEvent(this.getDelegate(), (short)1, null, null, sql2);
            EventPreparedStatement stmnt = null;
            try {
                stmnt = new EventPreparedStatement(super.prepareStatement(sql2, rsType, rsConcur, false), this, sql2);
            }
            catch (Throwable throwable) {
                JDBCEventConnectionDecorator.this.fireEvent(this.getDelegate(), (short)2, before, stmnt, sql2);
                throw throwable;
            }
            JDBCEventConnectionDecorator.this.fireEvent(this.getDelegate(), (short)2, before, stmnt, sql2);
            return stmnt;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws SQLException {
            try {
                JDBCEventConnectionDecorator.this.fireEvent(this.getDelegate(), (short)12, null, null, null);
            }
            finally {
                super.close();
            }
        }
    }
}

