/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler;

import org.jruby.ast.FCallNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.Node;
import org.jruby.compiler.ClosureCallback;
import org.jruby.compiler.Compiler;
import org.jruby.compiler.NodeCompiler;
import org.jruby.compiler.NodeCompilerFactory;
import org.jruby.compiler.NotCompilableException;
import org.jruby.runtime.CallType;

public class FCallNodeCompiler
implements NodeCompiler {
    public void compile(Node node, Compiler context) {
        context.lineNumber(node.getPosition());
        FCallNode fcallNode = (FCallNode)node;
        if (NodeCompilerFactory.SAFE && NodeCompilerFactory.UNSAFE_CALLS.contains(fcallNode.getName())) {
            throw new NotCompilableException("Can't compile call safely: " + node);
        }
        if (fcallNode.getIterNode() == null) {
            if (fcallNode.getArgsNode() != null) {
                NodeCompiler argsCompiler = NodeCompilerFactory.getArgumentsCompiler(fcallNode.getArgsNode());
                argsCompiler.compile(fcallNode.getArgsNode(), context);
                context.invokeDynamic(fcallNode.getName(), false, true, CallType.FUNCTIONAL, null, false);
            } else {
                context.invokeDynamic(fcallNode.getName(), false, false, CallType.FUNCTIONAL, null, false);
            }
        } else {
            final IterNode iterNode = (IterNode)fcallNode.getIterNode();
            ClosureCallback closureArg = new ClosureCallback(){

                public void compile(Compiler context) {
                    NodeCompilerFactory.getCompiler(iterNode).compile(iterNode, context);
                }
            };
            if (fcallNode.getArgsNode() != null) {
                NodeCompiler argsCompiler = NodeCompilerFactory.getArgumentsCompiler(fcallNode.getArgsNode());
                argsCompiler.compile(fcallNode.getArgsNode(), context);
                context.invokeDynamic(fcallNode.getName(), false, true, CallType.FUNCTIONAL, closureArg, false);
            } else {
                context.invokeDynamic(fcallNode.getName(), false, false, CallType.FUNCTIONAL, closureArg, false);
            }
        }
    }
}

