/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.util.ArrayList;
import java.util.Collection;
import org.aspectj.apache.bcel.classfile.GenericSignatureParser;
import org.aspectj.apache.bcel.classfile.Signature;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.weaver.AnnotationAJ;
import org.aspectj.weaver.AnnotationTargetKind;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.ReferenceType;
import org.aspectj.weaver.ReferenceTypeDelegate;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.SourceContextImpl;
import org.aspectj.weaver.TypeVariable;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.WeaverStateInfo;
import org.aspectj.weaver.patterns.PerClause;

public abstract class AbstractReferenceTypeDelegate
implements ReferenceTypeDelegate {
    public static final String UNKNOWN_SOURCE_FILE = "<Unknown>";
    private String sourcefilename = "<Unknown>";
    protected boolean exposedToWeaver;
    protected ReferenceType resolvedTypeX;
    private ISourceContext sourceContext = SourceContextImpl.UNKNOWN_SOURCE_CONTEXT;
    protected Signature.ClassSignature cachedGenericClassTypeSignature;

    public AbstractReferenceTypeDelegate(ReferenceType resolvedTypeX, boolean exposedToWeaver) {
        this.resolvedTypeX = resolvedTypeX;
        this.exposedToWeaver = exposedToWeaver;
    }

    public final boolean isClass() {
        return !this.isAspect() && !this.isInterface();
    }

    public boolean doesNotExposeShadowMungers() {
        return false;
    }

    public boolean isExposedToWeaver() {
        return this.exposedToWeaver;
    }

    public ReferenceType getResolvedTypeX() {
        return this.resolvedTypeX;
    }

    public final String getSourcefilename() {
        return this.sourcefilename;
    }

    public final void setSourcefilename(String sourceFileName) {
        this.sourcefilename = sourceFileName;
        if (sourceFileName != null && sourceFileName.equals(UNKNOWN_SOURCE_FILE)) {
            this.sourcefilename = "Type '" + this.getResolvedTypeX().getName() + "' (no debug info available)";
        } else {
            String pname = this.getResolvedTypeX().getPackageName();
            if (pname != null) {
                this.sourcefilename = pname.replace('.', '/') + '/' + sourceFileName;
            }
        }
        if (this.sourcefilename != null && this.sourceContext instanceof SourceContextImpl) {
            ((SourceContextImpl)this.sourceContext).setSourceFileName(this.sourcefilename);
        }
    }

    public ISourceLocation getSourceLocation() {
        return this.getSourceContext().makeSourceLocation(0, 0);
    }

    public ISourceContext getSourceContext() {
        return this.sourceContext;
    }

    public void setSourceContext(ISourceContext isc) {
        this.sourceContext = isc;
    }

    public Signature.ClassSignature getGenericClassTypeSignature() {
        String sig;
        if (this.cachedGenericClassTypeSignature == null && (sig = this.getDeclaredGenericSignature()) != null) {
            GenericSignatureParser parser = new GenericSignatureParser();
            this.cachedGenericClassTypeSignature = parser.parseAsClassSignature(sig);
        }
        return this.cachedGenericClassTypeSignature;
    }

    protected Signature.FormalTypeParameter[] getFormalTypeParametersFromOuterClass() {
        Signature.ClassSignature outerSig;
        int i;
        ArrayList<Signature.FormalTypeParameter> typeParameters = new ArrayList<Signature.FormalTypeParameter>();
        ReferenceType outer = (ReferenceType)this.getOuterClass();
        ReferenceTypeDelegate outerDelegate = outer.getDelegate();
        AbstractReferenceTypeDelegate outerObjectType = (AbstractReferenceTypeDelegate)outerDelegate;
        if (outerObjectType.isNested()) {
            Signature.FormalTypeParameter[] parentParams = outerObjectType.getFormalTypeParametersFromOuterClass();
            for (i = 0; i < parentParams.length; ++i) {
                typeParameters.add(parentParams[i]);
            }
        }
        if ((outerSig = outerObjectType.getGenericClassTypeSignature()) != null) {
            for (i = 0; i < outerSig.formalTypeParameters.length; ++i) {
                typeParameters.add(outerSig.formalTypeParameters[i]);
            }
        }
        Signature.FormalTypeParameter[] ret = new Signature.FormalTypeParameter[typeParameters.size()];
        typeParameters.toArray(ret);
        return ret;
    }

    public abstract /* synthetic */ ResolvedType getOuterClass();

    public abstract /* synthetic */ String getDeclaredGenericSignature();

    public abstract /* synthetic */ WeaverStateInfo getWeaverState();

    public abstract /* synthetic */ ResolvedType getSuperclass();

    public abstract /* synthetic */ int getModifiers();

    public abstract /* synthetic */ Collection getPrivilegedAccesses();

    public abstract /* synthetic */ Collection getTypeMungers();

    public abstract /* synthetic */ Collection getDeclares();

    public abstract /* synthetic */ PerClause getPerClause();

    public abstract /* synthetic */ TypeVariable[] getTypeVariables();

    public abstract /* synthetic */ ResolvedMember[] getDeclaredPointcuts();

    public abstract /* synthetic */ ResolvedMember[] getDeclaredMethods();

    public abstract /* synthetic */ ResolvedType[] getDeclaredInterfaces();

    public abstract /* synthetic */ ResolvedMember[] getDeclaredFields();

    public abstract /* synthetic */ ResolvedType[] getAnnotationTypes();

    public abstract /* synthetic */ AnnotationAJ[] getAnnotations();

    public abstract /* synthetic */ boolean hasAnnotation(UnresolvedType var1);

    public abstract /* synthetic */ boolean isNested();

    public abstract /* synthetic */ boolean isAnonymous();

    public abstract /* synthetic */ boolean isGeneric();

    public abstract /* synthetic */ boolean isAnnotationWithRuntimeRetention();

    public abstract /* synthetic */ AnnotationTargetKind[] getAnnotationTargetKinds();

    public abstract /* synthetic */ boolean canAnnotationTargetType();

    public abstract /* synthetic */ String getRetentionPolicy();

    public abstract /* synthetic */ boolean isAnnotation();

    public abstract /* synthetic */ boolean isEnum();

    public abstract /* synthetic */ boolean isInterface();

    public abstract /* synthetic */ boolean isAnnotationStyleAspect();

    public abstract /* synthetic */ boolean isAspect();

    public abstract /* synthetic */ void ensureDelegateConsistent();

    public abstract /* synthetic */ void addAnnotation(AnnotationAJ var1);
}

