/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.context.support.AbstractMessageSource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class ResourceBundleMessageSource
extends AbstractMessageSource
implements BeanClassLoaderAware {
    private String[] basenames = new String[0];
    private ClassLoader bundleClassLoader;
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private final Map<String, Map<Locale, ResourceBundle>> cachedResourceBundles = new HashMap<String, Map<Locale, ResourceBundle>>();
    private final Map<ResourceBundle, Map<String, Map<Locale, MessageFormat>>> cachedBundleMessageFormats = new HashMap<ResourceBundle, Map<String, Map<Locale, MessageFormat>>>();

    public void setBasename(String basename) {
        this.setBasenames(basename);
    }

    public void setBasenames(String ... basenames) {
        if (basenames != null) {
            this.basenames = new String[basenames.length];
            int i = 0;
            while (i < basenames.length) {
                String basename = basenames[i];
                Assert.hasText((String)basename, (String)"Basename must not be empty");
                this.basenames[i] = basename.trim();
                ++i;
            }
        } else {
            this.basenames = new String[0];
        }
    }

    public void setBundleClassLoader(ClassLoader classLoader) {
        this.bundleClassLoader = classLoader;
    }

    protected ClassLoader getBundleClassLoader() {
        return this.bundleClassLoader != null ? this.bundleClassLoader : this.beanClassLoader;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader != null ? classLoader : ClassUtils.getDefaultClassLoader();
    }

    protected String resolveCodeWithoutArguments(String code, Locale locale) {
        String result = null;
        int i = 0;
        while (result == null && i < this.basenames.length) {
            ResourceBundle bundle = this.getResourceBundle(this.basenames[i], locale);
            if (bundle != null) {
                result = this.getStringOrNull(bundle, code);
            }
            ++i;
        }
        return result;
    }

    protected MessageFormat resolveCode(String code, Locale locale) {
        MessageFormat messageFormat = null;
        int i = 0;
        while (messageFormat == null && i < this.basenames.length) {
            ResourceBundle bundle = this.getResourceBundle(this.basenames[i], locale);
            if (bundle != null) {
                messageFormat = this.getMessageFormat(bundle, code, locale);
            }
            ++i;
        }
        return messageFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResourceBundle getResourceBundle(String basename, Locale locale) {
        Map<String, Map<Locale, ResourceBundle>> map = this.cachedResourceBundles;
        synchronized (map) {
            ResourceBundle bundle;
            Map<Locale, ResourceBundle> localeMap = this.cachedResourceBundles.get(basename);
            if (localeMap != null && (bundle = localeMap.get(locale)) != null) {
                return bundle;
            }
            try {
                bundle = this.doGetBundle(basename, locale);
                if (localeMap == null) {
                    localeMap = new HashMap<Locale, ResourceBundle>();
                    this.cachedResourceBundles.put(basename, localeMap);
                }
                localeMap.put(locale, bundle);
                return bundle;
            }
            catch (MissingResourceException ex) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn((Object)("ResourceBundle [" + basename + "] not found for MessageSource: " + ex.getMessage()));
                }
                return null;
            }
        }
    }

    protected ResourceBundle doGetBundle(String basename, Locale locale) throws MissingResourceException {
        return ResourceBundle.getBundle(basename, locale, this.getBundleClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MessageFormat getMessageFormat(ResourceBundle bundle, String code, Locale locale) throws MissingResourceException {
        Map<ResourceBundle, Map<String, Map<Locale, MessageFormat>>> map = this.cachedBundleMessageFormats;
        synchronized (map) {
            MessageFormat result;
            Map<String, Map<Locale, MessageFormat>> codeMap = this.cachedBundleMessageFormats.get(bundle);
            Map<Locale, MessageFormat> localeMap = null;
            if (codeMap != null && (localeMap = codeMap.get(code)) != null && (result = localeMap.get(locale)) != null) {
                return result;
            }
            String msg = this.getStringOrNull(bundle, code);
            if (msg != null) {
                if (codeMap == null) {
                    codeMap = new HashMap<String, Map<Locale, MessageFormat>>();
                    this.cachedBundleMessageFormats.put(bundle, codeMap);
                }
                if (localeMap == null) {
                    localeMap = new HashMap<Locale, MessageFormat>();
                    codeMap.put(code, localeMap);
                }
                MessageFormat result2 = this.createMessageFormat(msg, locale);
                localeMap.put(locale, result2);
                return result2;
            }
            return null;
        }
    }

    private String getStringOrNull(ResourceBundle bundle, String key) {
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + ": basenames=[" + StringUtils.arrayToCommaDelimitedString((Object[])this.basenames) + "]";
    }
}

