/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.Spacer;

public class PeriodAxisLabelInfo
implements Cloneable,
Serializable {
    private Class periodClass;
    private Spacer spacer;
    private DateFormat dateFormat;
    private Font labelFont;
    private transient Paint labelPaint;
    private boolean drawDividers;
    private transient Stroke dividerStroke;
    private transient Paint dividerPaint;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$util$TimeZone;

    public PeriodAxisLabelInfo(Class periodClass, String dateFormat) {
        this(periodClass, dateFormat, new Spacer(1, 2.0, 2.0, 2.0, 2.0), new Font("SansSerif", 0, 10), Color.black, true, new BasicStroke(0.5f), Color.gray);
    }

    public PeriodAxisLabelInfo(Class periodClass, String dateFormat, Spacer spacer, Font labelFont, Paint labelPaint, boolean drawDividers, Stroke dividerStroke, Paint dividerPaint) {
        this.periodClass = periodClass;
        this.dateFormat = new SimpleDateFormat(dateFormat);
        this.spacer = spacer;
        this.labelFont = labelFont;
        this.labelPaint = labelPaint;
        this.drawDividers = drawDividers;
        this.dividerStroke = dividerStroke;
        this.dividerPaint = dividerPaint;
    }

    public Class getPeriodClass() {
        return this.periodClass;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public Spacer getSpacer() {
        return this.spacer;
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public Paint getLabelPaint() {
        return this.labelPaint;
    }

    public boolean getDrawDividers() {
        return this.drawDividers;
    }

    public Stroke getDividerStroke() {
        return this.dividerStroke;
    }

    public Paint getDividerPaint() {
        return this.dividerPaint;
    }

    public RegularTimePeriod createInstance(Date millisecond, TimeZone zone) {
        RegularTimePeriod result = null;
        try {
            Constructor c = this.periodClass.getDeclaredConstructor(class$java$util$Date == null ? (class$java$util$Date = PeriodAxisLabelInfo.class$("java.util.Date")) : class$java$util$Date, class$java$util$TimeZone == null ? (class$java$util$TimeZone = PeriodAxisLabelInfo.class$("java.util.TimeZone")) : class$java$util$TimeZone);
            result = (RegularTimePeriod)c.newInstance(millisecond, zone);
        }
        catch (Exception e) {
            // empty catch block
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PeriodAxisLabelInfo) {
            PeriodAxisLabelInfo info = (PeriodAxisLabelInfo)obj;
            if (!info.periodClass.equals(this.periodClass)) {
                return false;
            }
            if (!info.dateFormat.equals(this.dateFormat)) {
                return false;
            }
            if (!info.spacer.equals((Object)this.spacer)) {
                return false;
            }
            if (!info.labelFont.equals(this.labelFont)) {
                return false;
            }
            if (!info.labelPaint.equals(this.labelPaint)) {
                return false;
            }
            if (info.drawDividers != this.drawDividers) {
                return false;
            }
            if (!info.dividerStroke.equals(this.dividerStroke)) {
                return false;
            }
            return info.dividerPaint.equals(this.dividerPaint);
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        PeriodAxisLabelInfo clone = (PeriodAxisLabelInfo)super.clone();
        return clone;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        SerialUtilities.writePaint((Paint)this.labelPaint, (ObjectOutputStream)stream);
        SerialUtilities.writeStroke((Stroke)this.dividerStroke, (ObjectOutputStream)stream);
        SerialUtilities.writePaint((Paint)this.dividerPaint, (ObjectOutputStream)stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.labelPaint = SerialUtilities.readPaint((ObjectInputStream)stream);
        this.dividerStroke = SerialUtilities.readStroke((ObjectInputStream)stream);
        this.dividerPaint = SerialUtilities.readPaint((ObjectInputStream)stream);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

