/**
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * Autogenerated by Thrift Compiler (0.9.3)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
package org.apache.airavata.model.process;

import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;

import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TException;
import org.apache.thrift.async.AsyncMethodCallback;
import org.apache.thrift.server.AbstractNonblockingServer.*;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.EnumMap;
import java.util.Set;
import java.util.HashSet;
import java.util.EnumSet;
import java.util.Collections;
import java.util.BitSet;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.annotation.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings({"cast", "rawtypes", "serial", "unchecked"})
/**
 * ProcessModel: A structure holding the process details. The infromation is derived based on user provided
 *          configuration data or system inferred information from scheduling and QoS parameters.
 * 
 * processDetail:
 *   A friendly description of the process, usally used to communicate information to users.
 * 
 * 
 */
@Generated(value = "Autogenerated by Thrift Compiler (0.9.3)")
public class ProcessModel implements org.apache.thrift.TBase<ProcessModel, ProcessModel._Fields>, java.io.Serializable, Cloneable, Comparable<ProcessModel> {
  private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("ProcessModel");

  private static final org.apache.thrift.protocol.TField PROCESS_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("processId", org.apache.thrift.protocol.TType.STRING, (short)1);
  private static final org.apache.thrift.protocol.TField EXPERIMENT_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("experimentId", org.apache.thrift.protocol.TType.STRING, (short)2);
  private static final org.apache.thrift.protocol.TField CREATION_TIME_FIELD_DESC = new org.apache.thrift.protocol.TField("creationTime", org.apache.thrift.protocol.TType.I64, (short)3);
  private static final org.apache.thrift.protocol.TField LAST_UPDATE_TIME_FIELD_DESC = new org.apache.thrift.protocol.TField("lastUpdateTime", org.apache.thrift.protocol.TType.I64, (short)4);
  private static final org.apache.thrift.protocol.TField PROCESS_STATUSES_FIELD_DESC = new org.apache.thrift.protocol.TField("processStatuses", org.apache.thrift.protocol.TType.LIST, (short)5);
  private static final org.apache.thrift.protocol.TField PROCESS_DETAIL_FIELD_DESC = new org.apache.thrift.protocol.TField("processDetail", org.apache.thrift.protocol.TType.STRING, (short)6);
  private static final org.apache.thrift.protocol.TField APPLICATION_INTERFACE_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("applicationInterfaceId", org.apache.thrift.protocol.TType.STRING, (short)7);
  private static final org.apache.thrift.protocol.TField APPLICATION_DEPLOYMENT_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("applicationDeploymentId", org.apache.thrift.protocol.TType.STRING, (short)8);
  private static final org.apache.thrift.protocol.TField COMPUTE_RESOURCE_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("computeResourceId", org.apache.thrift.protocol.TType.STRING, (short)9);
  private static final org.apache.thrift.protocol.TField PROCESS_INPUTS_FIELD_DESC = new org.apache.thrift.protocol.TField("processInputs", org.apache.thrift.protocol.TType.LIST, (short)10);
  private static final org.apache.thrift.protocol.TField PROCESS_OUTPUTS_FIELD_DESC = new org.apache.thrift.protocol.TField("processOutputs", org.apache.thrift.protocol.TType.LIST, (short)11);
  private static final org.apache.thrift.protocol.TField PROCESS_RESOURCE_SCHEDULE_FIELD_DESC = new org.apache.thrift.protocol.TField("processResourceSchedule", org.apache.thrift.protocol.TType.STRUCT, (short)12);
  private static final org.apache.thrift.protocol.TField TASKS_FIELD_DESC = new org.apache.thrift.protocol.TField("tasks", org.apache.thrift.protocol.TType.LIST, (short)13);
  private static final org.apache.thrift.protocol.TField TASK_DAG_FIELD_DESC = new org.apache.thrift.protocol.TField("taskDag", org.apache.thrift.protocol.TType.STRING, (short)14);
  private static final org.apache.thrift.protocol.TField PROCESS_ERRORS_FIELD_DESC = new org.apache.thrift.protocol.TField("processErrors", org.apache.thrift.protocol.TType.LIST, (short)15);
  private static final org.apache.thrift.protocol.TField GATEWAY_EXECUTION_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("gatewayExecutionId", org.apache.thrift.protocol.TType.STRING, (short)16);
  private static final org.apache.thrift.protocol.TField ENABLE_EMAIL_NOTIFICATION_FIELD_DESC = new org.apache.thrift.protocol.TField("enableEmailNotification", org.apache.thrift.protocol.TType.BOOL, (short)17);
  private static final org.apache.thrift.protocol.TField EMAIL_ADDRESSES_FIELD_DESC = new org.apache.thrift.protocol.TField("emailAddresses", org.apache.thrift.protocol.TType.LIST, (short)18);
  private static final org.apache.thrift.protocol.TField STORAGE_RESOURCE_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("storageResourceId", org.apache.thrift.protocol.TType.STRING, (short)19);
  private static final org.apache.thrift.protocol.TField USER_DN_FIELD_DESC = new org.apache.thrift.protocol.TField("userDn", org.apache.thrift.protocol.TType.STRING, (short)20);
  private static final org.apache.thrift.protocol.TField GENERATE_CERT_FIELD_DESC = new org.apache.thrift.protocol.TField("generateCert", org.apache.thrift.protocol.TType.BOOL, (short)21);
  private static final org.apache.thrift.protocol.TField EXPERIMENT_DATA_DIR_FIELD_DESC = new org.apache.thrift.protocol.TField("experimentDataDir", org.apache.thrift.protocol.TType.STRING, (short)22);
  private static final org.apache.thrift.protocol.TField USER_NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("userName", org.apache.thrift.protocol.TType.STRING, (short)23);
  private static final org.apache.thrift.protocol.TField USE_USER_CRPREF_FIELD_DESC = new org.apache.thrift.protocol.TField("useUserCRPref", org.apache.thrift.protocol.TType.BOOL, (short)24);

  private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
  static {
    schemes.put(StandardScheme.class, new ProcessModelStandardSchemeFactory());
    schemes.put(TupleScheme.class, new ProcessModelTupleSchemeFactory());
  }

  private String processId; // required
  private String experimentId; // required
  private long creationTime; // optional
  private long lastUpdateTime; // optional
  private List<org.apache.airavata.model.status.ProcessStatus> processStatuses; // optional
  private String processDetail; // optional
  private String applicationInterfaceId; // optional
  private String applicationDeploymentId; // optional
  private String computeResourceId; // optional
  private List<org.apache.airavata.model.application.io.InputDataObjectType> processInputs; // optional
  private List<org.apache.airavata.model.application.io.OutputDataObjectType> processOutputs; // optional
  private org.apache.airavata.model.scheduling.ComputationalResourceSchedulingModel processResourceSchedule; // optional
  private List<org.apache.airavata.model.task.TaskModel> tasks; // optional
  private String taskDag; // optional
  private List<org.apache.airavata.model.commons.ErrorModel> processErrors; // optional
  private String gatewayExecutionId; // optional
  private boolean enableEmailNotification; // optional
  private List<String> emailAddresses; // optional
  private String storageResourceId; // optional
  private String userDn; // optional
  private boolean generateCert; // optional
  private String experimentDataDir; // optional
  private String userName; // optional
  private boolean useUserCRPref; // optional

  /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
  public enum _Fields implements org.apache.thrift.TFieldIdEnum {
    PROCESS_ID((short)1, "processId"),
    EXPERIMENT_ID((short)2, "experimentId"),
    CREATION_TIME((short)3, "creationTime"),
    LAST_UPDATE_TIME((short)4, "lastUpdateTime"),
    PROCESS_STATUSES((short)5, "processStatuses"),
    PROCESS_DETAIL((short)6, "processDetail"),
    APPLICATION_INTERFACE_ID((short)7, "applicationInterfaceId"),
    APPLICATION_DEPLOYMENT_ID((short)8, "applicationDeploymentId"),
    COMPUTE_RESOURCE_ID((short)9, "computeResourceId"),
    PROCESS_INPUTS((short)10, "processInputs"),
    PROCESS_OUTPUTS((short)11, "processOutputs"),
    PROCESS_RESOURCE_SCHEDULE((short)12, "processResourceSchedule"),
    TASKS((short)13, "tasks"),
    TASK_DAG((short)14, "taskDag"),
    PROCESS_ERRORS((short)15, "processErrors"),
    GATEWAY_EXECUTION_ID((short)16, "gatewayExecutionId"),
    ENABLE_EMAIL_NOTIFICATION((short)17, "enableEmailNotification"),
    EMAIL_ADDRESSES((short)18, "emailAddresses"),
    STORAGE_RESOURCE_ID((short)19, "storageResourceId"),
    USER_DN((short)20, "userDn"),
    GENERATE_CERT((short)21, "generateCert"),
    EXPERIMENT_DATA_DIR((short)22, "experimentDataDir"),
    USER_NAME((short)23, "userName"),
    USE_USER_CRPREF((short)24, "useUserCRPref");

    private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

    static {
      for (_Fields field : EnumSet.allOf(_Fields.class)) {
        byName.put(field.getFieldName(), field);
      }
    }

    /**
     * Find the _Fields constant that matches fieldId, or null if its not found.
     */
    public static _Fields findByThriftId(int fieldId) {
      switch(fieldId) {
        case 1: // PROCESS_ID
          return PROCESS_ID;
        case 2: // EXPERIMENT_ID
          return EXPERIMENT_ID;
        case 3: // CREATION_TIME
          return CREATION_TIME;
        case 4: // LAST_UPDATE_TIME
          return LAST_UPDATE_TIME;
        case 5: // PROCESS_STATUSES
          return PROCESS_STATUSES;
        case 6: // PROCESS_DETAIL
          return PROCESS_DETAIL;
        case 7: // APPLICATION_INTERFACE_ID
          return APPLICATION_INTERFACE_ID;
        case 8: // APPLICATION_DEPLOYMENT_ID
          return APPLICATION_DEPLOYMENT_ID;
        case 9: // COMPUTE_RESOURCE_ID
          return COMPUTE_RESOURCE_ID;
        case 10: // PROCESS_INPUTS
          return PROCESS_INPUTS;
        case 11: // PROCESS_OUTPUTS
          return PROCESS_OUTPUTS;
        case 12: // PROCESS_RESOURCE_SCHEDULE
          return PROCESS_RESOURCE_SCHEDULE;
        case 13: // TASKS
          return TASKS;
        case 14: // TASK_DAG
          return TASK_DAG;
        case 15: // PROCESS_ERRORS
          return PROCESS_ERRORS;
        case 16: // GATEWAY_EXECUTION_ID
          return GATEWAY_EXECUTION_ID;
        case 17: // ENABLE_EMAIL_NOTIFICATION
          return ENABLE_EMAIL_NOTIFICATION;
        case 18: // EMAIL_ADDRESSES
          return EMAIL_ADDRESSES;
        case 19: // STORAGE_RESOURCE_ID
          return STORAGE_RESOURCE_ID;
        case 20: // USER_DN
          return USER_DN;
        case 21: // GENERATE_CERT
          return GENERATE_CERT;
        case 22: // EXPERIMENT_DATA_DIR
          return EXPERIMENT_DATA_DIR;
        case 23: // USER_NAME
          return USER_NAME;
        case 24: // USE_USER_CRPREF
          return USE_USER_CRPREF;
        default:
          return null;
      }
    }

    /**
     * Find the _Fields constant that matches fieldId, throwing an exception
     * if it is not found.
     */
    public static _Fields findByThriftIdOrThrow(int fieldId) {
      _Fields fields = findByThriftId(fieldId);
      if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
      return fields;
    }

    /**
     * Find the _Fields constant that matches name, or null if its not found.
     */
    public static _Fields findByName(String name) {
      return byName.get(name);
    }

    private final short _thriftId;
    private final String _fieldName;

    _Fields(short thriftId, String fieldName) {
      _thriftId = thriftId;
      _fieldName = fieldName;
    }

    public short getThriftFieldId() {
      return _thriftId;
    }

    public String getFieldName() {
      return _fieldName;
    }
  }

  // isset id assignments
  private static final int __CREATIONTIME_ISSET_ID = 0;
  private static final int __LASTUPDATETIME_ISSET_ID = 1;
  private static final int __ENABLEEMAILNOTIFICATION_ISSET_ID = 2;
  private static final int __GENERATECERT_ISSET_ID = 3;
  private static final int __USEUSERCRPREF_ISSET_ID = 4;
  private byte __isset_bitfield = 0;
  private static final _Fields optionals[] = {_Fields.CREATION_TIME,_Fields.LAST_UPDATE_TIME,_Fields.PROCESS_STATUSES,_Fields.PROCESS_DETAIL,_Fields.APPLICATION_INTERFACE_ID,_Fields.APPLICATION_DEPLOYMENT_ID,_Fields.COMPUTE_RESOURCE_ID,_Fields.PROCESS_INPUTS,_Fields.PROCESS_OUTPUTS,_Fields.PROCESS_RESOURCE_SCHEDULE,_Fields.TASKS,_Fields.TASK_DAG,_Fields.PROCESS_ERRORS,_Fields.GATEWAY_EXECUTION_ID,_Fields.ENABLE_EMAIL_NOTIFICATION,_Fields.EMAIL_ADDRESSES,_Fields.STORAGE_RESOURCE_ID,_Fields.USER_DN,_Fields.GENERATE_CERT,_Fields.EXPERIMENT_DATA_DIR,_Fields.USER_NAME,_Fields.USE_USER_CRPREF};
  public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
  static {
    Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
    tmpMap.put(_Fields.PROCESS_ID, new org.apache.thrift.meta_data.FieldMetaData("processId", org.apache.thrift.TFieldRequirementType.REQUIRED, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
    tmpMap.put(_Fields.EXPERIMENT_ID, new org.apache.thrift.meta_data.FieldMetaData("experimentId", org.apache.thrift.TFieldRequirementType.REQUIRED, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
    tmpMap.put(_Fields.CREATION_TIME, new org.apache.thrift.meta_data.FieldMetaData("creationTime", org.apache.thrift.TFieldRequirementType.OPTIONAL, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
    tmpMap.put(_Fields.LAST_UPDATE_TIME, new org.apache.thrift.meta_data.FieldMetaData("lastUpdateTime", org.apache.thrift.TFieldRequirementType.OPTIONAL, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
    tmpMap.put(_Fields.PROCESS_STATUSES, new org.apache.thrift.meta_data.FieldMetaData("processStatuses", org.apache.thrift.TFieldRequirementType.OPTIONAL, 
        new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
            new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.airavata.model.status.ProcessStatus.class))));
    tmpMap.put(_Fields.PROCESS_DETAIL, new org.apache.thrift.meta_data.FieldMetaData("processDetail", org.apache.thrift.TFieldRequirementType.OPTIONAL, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
    tmpMap.put(_Fields.APPLICATION_INTERFACE_ID, new org.apache.thrift.meta_data.FieldMetaData("applicationInterfaceId", org.apache.thrift.TFieldRequirementType.OPTIONAL, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
    tmpMap.put(_Fields.APPLICATION_DEPLOYMENT_ID, new org.apache.thrift.meta_data.FieldMetaData("applicationDeploymentId", org.apache.thrift.TFieldRequirementType.OPTIONAL, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
    tmpMap.put(_Fields.COMPUTE_RESOURCE_ID, new org.apache.thrift.meta_data.FieldMetaData("computeResourceId", org.apache.thrift.TFieldRequirementType.OPTIONAL, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
    tmpMap.put(_Fields.PROCESS_INPUTS, new org.apache.thrift.meta_data.FieldMetaData("processInputs", org.apache.thrift.TFieldRequirementType.OPTIONAL, 
        new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
            new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.airavata.model.application.io.InputDataObjectType.class))));
    tmpMap.put(_Fields.PROCESS_OUTPUTS, new org.apache.thrift.meta_data.FieldMetaData("processOutputs", org.apache.thrift.TFieldRequirementType.OPTIONAL, 
        new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
            new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.airavata.model.application.io.OutputDataObjectType.class))));
    tmpMap.put(_Fields.PROCESS_RESOURCE_SCHEDULE, new org.apache.thrift.meta_data.FieldMetaData("processResourceSchedule", org.apache.thrift.TFieldRequirementType.OPTIONAL, 
        new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.airavata.model.scheduling.ComputationalResourceSchedulingModel.class)));
    tmpMap.put(_Fields.TASKS, new org.apache.thrift.meta_data.FieldMetaData("tasks", org.apache.thrift.TFieldRequirementType.OPTIONAL, 
        new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
            new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.airavata.model.task.TaskModel.class))));
    tmpMap.put(_Fields.TASK_DAG, new org.apache.thrift.meta_data.FieldMetaData("taskDag", org.apache.thrift.TFieldRequirementType.OPTIONAL, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
    tmpMap.put(_Fields.PROCESS_ERRORS, new org.apache.thrift.meta_data.FieldMetaData("processErrors", org.apache.thrift.TFieldRequirementType.OPTIONAL, 
        new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
            new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.airavata.model.commons.ErrorModel.class))));
    tmpMap.put(_Fields.GATEWAY_EXECUTION_ID, new org.apache.thrift.meta_data.FieldMetaData("gatewayExecutionId", org.apache.thrift.TFieldRequirementType.OPTIONAL, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
    tmpMap.put(_Fields.ENABLE_EMAIL_NOTIFICATION, new org.apache.thrift.meta_data.FieldMetaData("enableEmailNotification", org.apache.thrift.TFieldRequirementType.OPTIONAL, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
    tmpMap.put(_Fields.EMAIL_ADDRESSES, new org.apache.thrift.meta_data.FieldMetaData("emailAddresses", org.apache.thrift.TFieldRequirementType.OPTIONAL, 
        new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
            new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING))));
    tmpMap.put(_Fields.STORAGE_RESOURCE_ID, new org.apache.thrift.meta_data.FieldMetaData("storageResourceId", org.apache.thrift.TFieldRequirementType.OPTIONAL, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
    tmpMap.put(_Fields.USER_DN, new org.apache.thrift.meta_data.FieldMetaData("userDn", org.apache.thrift.TFieldRequirementType.OPTIONAL, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
    tmpMap.put(_Fields.GENERATE_CERT, new org.apache.thrift.meta_data.FieldMetaData("generateCert", org.apache.thrift.TFieldRequirementType.OPTIONAL, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
    tmpMap.put(_Fields.EXPERIMENT_DATA_DIR, new org.apache.thrift.meta_data.FieldMetaData("experimentDataDir", org.apache.thrift.TFieldRequirementType.OPTIONAL, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
    tmpMap.put(_Fields.USER_NAME, new org.apache.thrift.meta_data.FieldMetaData("userName", org.apache.thrift.TFieldRequirementType.OPTIONAL, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
    tmpMap.put(_Fields.USE_USER_CRPREF, new org.apache.thrift.meta_data.FieldMetaData("useUserCRPref", org.apache.thrift.TFieldRequirementType.OPTIONAL, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
    metaDataMap = Collections.unmodifiableMap(tmpMap);
    org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(ProcessModel.class, metaDataMap);
  }

  public ProcessModel() {
    this.processId = "DO_NOT_SET_AT_CLIENTS";

    this.generateCert = false;

  }

  public ProcessModel(
    String processId,
    String experimentId)
  {
    this();
    this.processId = processId;
    this.experimentId = experimentId;
  }

  /**
   * Performs a deep copy on <i>other</i>.
   */
  public ProcessModel(ProcessModel other) {
    __isset_bitfield = other.__isset_bitfield;
    if (other.isSetProcessId()) {
      this.processId = other.processId;
    }
    if (other.isSetExperimentId()) {
      this.experimentId = other.experimentId;
    }
    this.creationTime = other.creationTime;
    this.lastUpdateTime = other.lastUpdateTime;
    if (other.isSetProcessStatuses()) {
      List<org.apache.airavata.model.status.ProcessStatus> __this__processStatuses = new ArrayList<org.apache.airavata.model.status.ProcessStatus>(other.processStatuses.size());
      for (org.apache.airavata.model.status.ProcessStatus other_element : other.processStatuses) {
        __this__processStatuses.add(new org.apache.airavata.model.status.ProcessStatus(other_element));
      }
      this.processStatuses = __this__processStatuses;
    }
    if (other.isSetProcessDetail()) {
      this.processDetail = other.processDetail;
    }
    if (other.isSetApplicationInterfaceId()) {
      this.applicationInterfaceId = other.applicationInterfaceId;
    }
    if (other.isSetApplicationDeploymentId()) {
      this.applicationDeploymentId = other.applicationDeploymentId;
    }
    if (other.isSetComputeResourceId()) {
      this.computeResourceId = other.computeResourceId;
    }
    if (other.isSetProcessInputs()) {
      List<org.apache.airavata.model.application.io.InputDataObjectType> __this__processInputs = new ArrayList<org.apache.airavata.model.application.io.InputDataObjectType>(other.processInputs.size());
      for (org.apache.airavata.model.application.io.InputDataObjectType other_element : other.processInputs) {
        __this__processInputs.add(new org.apache.airavata.model.application.io.InputDataObjectType(other_element));
      }
      this.processInputs = __this__processInputs;
    }
    if (other.isSetProcessOutputs()) {
      List<org.apache.airavata.model.application.io.OutputDataObjectType> __this__processOutputs = new ArrayList<org.apache.airavata.model.application.io.OutputDataObjectType>(other.processOutputs.size());
      for (org.apache.airavata.model.application.io.OutputDataObjectType other_element : other.processOutputs) {
        __this__processOutputs.add(new org.apache.airavata.model.application.io.OutputDataObjectType(other_element));
      }
      this.processOutputs = __this__processOutputs;
    }
    if (other.isSetProcessResourceSchedule()) {
      this.processResourceSchedule = new org.apache.airavata.model.scheduling.ComputationalResourceSchedulingModel(other.processResourceSchedule);
    }
    if (other.isSetTasks()) {
      List<org.apache.airavata.model.task.TaskModel> __this__tasks = new ArrayList<org.apache.airavata.model.task.TaskModel>(other.tasks.size());
      for (org.apache.airavata.model.task.TaskModel other_element : other.tasks) {
        __this__tasks.add(new org.apache.airavata.model.task.TaskModel(other_element));
      }
      this.tasks = __this__tasks;
    }
    if (other.isSetTaskDag()) {
      this.taskDag = other.taskDag;
    }
    if (other.isSetProcessErrors()) {
      List<org.apache.airavata.model.commons.ErrorModel> __this__processErrors = new ArrayList<org.apache.airavata.model.commons.ErrorModel>(other.processErrors.size());
      for (org.apache.airavata.model.commons.ErrorModel other_element : other.processErrors) {
        __this__processErrors.add(new org.apache.airavata.model.commons.ErrorModel(other_element));
      }
      this.processErrors = __this__processErrors;
    }
    if (other.isSetGatewayExecutionId()) {
      this.gatewayExecutionId = other.gatewayExecutionId;
    }
    this.enableEmailNotification = other.enableEmailNotification;
    if (other.isSetEmailAddresses()) {
      List<String> __this__emailAddresses = new ArrayList<String>(other.emailAddresses);
      this.emailAddresses = __this__emailAddresses;
    }
    if (other.isSetStorageResourceId()) {
      this.storageResourceId = other.storageResourceId;
    }
    if (other.isSetUserDn()) {
      this.userDn = other.userDn;
    }
    this.generateCert = other.generateCert;
    if (other.isSetExperimentDataDir()) {
      this.experimentDataDir = other.experimentDataDir;
    }
    if (other.isSetUserName()) {
      this.userName = other.userName;
    }
    this.useUserCRPref = other.useUserCRPref;
  }

  public ProcessModel deepCopy() {
    return new ProcessModel(this);
  }

  @Override
  public void clear() {
    this.processId = "DO_NOT_SET_AT_CLIENTS";

    this.experimentId = null;
    setCreationTimeIsSet(false);
    this.creationTime = 0;
    setLastUpdateTimeIsSet(false);
    this.lastUpdateTime = 0;
    this.processStatuses = null;
    this.processDetail = null;
    this.applicationInterfaceId = null;
    this.applicationDeploymentId = null;
    this.computeResourceId = null;
    this.processInputs = null;
    this.processOutputs = null;
    this.processResourceSchedule = null;
    this.tasks = null;
    this.taskDag = null;
    this.processErrors = null;
    this.gatewayExecutionId = null;
    setEnableEmailNotificationIsSet(false);
    this.enableEmailNotification = false;
    this.emailAddresses = null;
    this.storageResourceId = null;
    this.userDn = null;
    this.generateCert = false;

    this.experimentDataDir = null;
    this.userName = null;
    setUseUserCRPrefIsSet(false);
    this.useUserCRPref = false;
  }

  public String getProcessId() {
    return this.processId;
  }

  public void setProcessId(String processId) {
    this.processId = processId;
  }

  public void unsetProcessId() {
    this.processId = null;
  }

  /** Returns true if field processId is set (has been assigned a value) and false otherwise */
  public boolean isSetProcessId() {
    return this.processId != null;
  }

  public void setProcessIdIsSet(boolean value) {
    if (!value) {
      this.processId = null;
    }
  }

  public String getExperimentId() {
    return this.experimentId;
  }

  public void setExperimentId(String experimentId) {
    this.experimentId = experimentId;
  }

  public void unsetExperimentId() {
    this.experimentId = null;
  }

  /** Returns true if field experimentId is set (has been assigned a value) and false otherwise */
  public boolean isSetExperimentId() {
    return this.experimentId != null;
  }

  public void setExperimentIdIsSet(boolean value) {
    if (!value) {
      this.experimentId = null;
    }
  }

  public long getCreationTime() {
    return this.creationTime;
  }

  public void setCreationTime(long creationTime) {
    this.creationTime = creationTime;
    setCreationTimeIsSet(true);
  }

  public void unsetCreationTime() {
    __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __CREATIONTIME_ISSET_ID);
  }

  /** Returns true if field creationTime is set (has been assigned a value) and false otherwise */
  public boolean isSetCreationTime() {
    return EncodingUtils.testBit(__isset_bitfield, __CREATIONTIME_ISSET_ID);
  }

  public void setCreationTimeIsSet(boolean value) {
    __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __CREATIONTIME_ISSET_ID, value);
  }

  public long getLastUpdateTime() {
    return this.lastUpdateTime;
  }

  public void setLastUpdateTime(long lastUpdateTime) {
    this.lastUpdateTime = lastUpdateTime;
    setLastUpdateTimeIsSet(true);
  }

  public void unsetLastUpdateTime() {
    __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __LASTUPDATETIME_ISSET_ID);
  }

  /** Returns true if field lastUpdateTime is set (has been assigned a value) and false otherwise */
  public boolean isSetLastUpdateTime() {
    return EncodingUtils.testBit(__isset_bitfield, __LASTUPDATETIME_ISSET_ID);
  }

  public void setLastUpdateTimeIsSet(boolean value) {
    __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __LASTUPDATETIME_ISSET_ID, value);
  }

  public int getProcessStatusesSize() {
    return (this.processStatuses == null) ? 0 : this.processStatuses.size();
  }

  public java.util.Iterator<org.apache.airavata.model.status.ProcessStatus> getProcessStatusesIterator() {
    return (this.processStatuses == null) ? null : this.processStatuses.iterator();
  }

  public void addToProcessStatuses(org.apache.airavata.model.status.ProcessStatus elem) {
    if (this.processStatuses == null) {
      this.processStatuses = new ArrayList<org.apache.airavata.model.status.ProcessStatus>();
    }
    this.processStatuses.add(elem);
  }

  public List<org.apache.airavata.model.status.ProcessStatus> getProcessStatuses() {
    return this.processStatuses;
  }

  public void setProcessStatuses(List<org.apache.airavata.model.status.ProcessStatus> processStatuses) {
    this.processStatuses = processStatuses;
  }

  public void unsetProcessStatuses() {
    this.processStatuses = null;
  }

  /** Returns true if field processStatuses is set (has been assigned a value) and false otherwise */
  public boolean isSetProcessStatuses() {
    return this.processStatuses != null;
  }

  public void setProcessStatusesIsSet(boolean value) {
    if (!value) {
      this.processStatuses = null;
    }
  }

  public String getProcessDetail() {
    return this.processDetail;
  }

  public void setProcessDetail(String processDetail) {
    this.processDetail = processDetail;
  }

  public void unsetProcessDetail() {
    this.processDetail = null;
  }

  /** Returns true if field processDetail is set (has been assigned a value) and false otherwise */
  public boolean isSetProcessDetail() {
    return this.processDetail != null;
  }

  public void setProcessDetailIsSet(boolean value) {
    if (!value) {
      this.processDetail = null;
    }
  }

  public String getApplicationInterfaceId() {
    return this.applicationInterfaceId;
  }

  public void setApplicationInterfaceId(String applicationInterfaceId) {
    this.applicationInterfaceId = applicationInterfaceId;
  }

  public void unsetApplicationInterfaceId() {
    this.applicationInterfaceId = null;
  }

  /** Returns true if field applicationInterfaceId is set (has been assigned a value) and false otherwise */
  public boolean isSetApplicationInterfaceId() {
    return this.applicationInterfaceId != null;
  }

  public void setApplicationInterfaceIdIsSet(boolean value) {
    if (!value) {
      this.applicationInterfaceId = null;
    }
  }

  public String getApplicationDeploymentId() {
    return this.applicationDeploymentId;
  }

  public void setApplicationDeploymentId(String applicationDeploymentId) {
    this.applicationDeploymentId = applicationDeploymentId;
  }

  public void unsetApplicationDeploymentId() {
    this.applicationDeploymentId = null;
  }

  /** Returns true if field applicationDeploymentId is set (has been assigned a value) and false otherwise */
  public boolean isSetApplicationDeploymentId() {
    return this.applicationDeploymentId != null;
  }

  public void setApplicationDeploymentIdIsSet(boolean value) {
    if (!value) {
      this.applicationDeploymentId = null;
    }
  }

  public String getComputeResourceId() {
    return this.computeResourceId;
  }

  public void setComputeResourceId(String computeResourceId) {
    this.computeResourceId = computeResourceId;
  }

  public void unsetComputeResourceId() {
    this.computeResourceId = null;
  }

  /** Returns true if field computeResourceId is set (has been assigned a value) and false otherwise */
  public boolean isSetComputeResourceId() {
    return this.computeResourceId != null;
  }

  public void setComputeResourceIdIsSet(boolean value) {
    if (!value) {
      this.computeResourceId = null;
    }
  }

  public int getProcessInputsSize() {
    return (this.processInputs == null) ? 0 : this.processInputs.size();
  }

  public java.util.Iterator<org.apache.airavata.model.application.io.InputDataObjectType> getProcessInputsIterator() {
    return (this.processInputs == null) ? null : this.processInputs.iterator();
  }

  public void addToProcessInputs(org.apache.airavata.model.application.io.InputDataObjectType elem) {
    if (this.processInputs == null) {
      this.processInputs = new ArrayList<org.apache.airavata.model.application.io.InputDataObjectType>();
    }
    this.processInputs.add(elem);
  }

  public List<org.apache.airavata.model.application.io.InputDataObjectType> getProcessInputs() {
    return this.processInputs;
  }

  public void setProcessInputs(List<org.apache.airavata.model.application.io.InputDataObjectType> processInputs) {
    this.processInputs = processInputs;
  }

  public void unsetProcessInputs() {
    this.processInputs = null;
  }

  /** Returns true if field processInputs is set (has been assigned a value) and false otherwise */
  public boolean isSetProcessInputs() {
    return this.processInputs != null;
  }

  public void setProcessInputsIsSet(boolean value) {
    if (!value) {
      this.processInputs = null;
    }
  }

  public int getProcessOutputsSize() {
    return (this.processOutputs == null) ? 0 : this.processOutputs.size();
  }

  public java.util.Iterator<org.apache.airavata.model.application.io.OutputDataObjectType> getProcessOutputsIterator() {
    return (this.processOutputs == null) ? null : this.processOutputs.iterator();
  }

  public void addToProcessOutputs(org.apache.airavata.model.application.io.OutputDataObjectType elem) {
    if (this.processOutputs == null) {
      this.processOutputs = new ArrayList<org.apache.airavata.model.application.io.OutputDataObjectType>();
    }
    this.processOutputs.add(elem);
  }

  public List<org.apache.airavata.model.application.io.OutputDataObjectType> getProcessOutputs() {
    return this.processOutputs;
  }

  public void setProcessOutputs(List<org.apache.airavata.model.application.io.OutputDataObjectType> processOutputs) {
    this.processOutputs = processOutputs;
  }

  public void unsetProcessOutputs() {
    this.processOutputs = null;
  }

  /** Returns true if field processOutputs is set (has been assigned a value) and false otherwise */
  public boolean isSetProcessOutputs() {
    return this.processOutputs != null;
  }

  public void setProcessOutputsIsSet(boolean value) {
    if (!value) {
      this.processOutputs = null;
    }
  }

  public org.apache.airavata.model.scheduling.ComputationalResourceSchedulingModel getProcessResourceSchedule() {
    return this.processResourceSchedule;
  }

  public void setProcessResourceSchedule(org.apache.airavata.model.scheduling.ComputationalResourceSchedulingModel processResourceSchedule) {
    this.processResourceSchedule = processResourceSchedule;
  }

  public void unsetProcessResourceSchedule() {
    this.processResourceSchedule = null;
  }

  /** Returns true if field processResourceSchedule is set (has been assigned a value) and false otherwise */
  public boolean isSetProcessResourceSchedule() {
    return this.processResourceSchedule != null;
  }

  public void setProcessResourceScheduleIsSet(boolean value) {
    if (!value) {
      this.processResourceSchedule = null;
    }
  }

  public int getTasksSize() {
    return (this.tasks == null) ? 0 : this.tasks.size();
  }

  public java.util.Iterator<org.apache.airavata.model.task.TaskModel> getTasksIterator() {
    return (this.tasks == null) ? null : this.tasks.iterator();
  }

  public void addToTasks(org.apache.airavata.model.task.TaskModel elem) {
    if (this.tasks == null) {
      this.tasks = new ArrayList<org.apache.airavata.model.task.TaskModel>();
    }
    this.tasks.add(elem);
  }

  public List<org.apache.airavata.model.task.TaskModel> getTasks() {
    return this.tasks;
  }

  public void setTasks(List<org.apache.airavata.model.task.TaskModel> tasks) {
    this.tasks = tasks;
  }

  public void unsetTasks() {
    this.tasks = null;
  }

  /** Returns true if field tasks is set (has been assigned a value) and false otherwise */
  public boolean isSetTasks() {
    return this.tasks != null;
  }

  public void setTasksIsSet(boolean value) {
    if (!value) {
      this.tasks = null;
    }
  }

  public String getTaskDag() {
    return this.taskDag;
  }

  public void setTaskDag(String taskDag) {
    this.taskDag = taskDag;
  }

  public void unsetTaskDag() {
    this.taskDag = null;
  }

  /** Returns true if field taskDag is set (has been assigned a value) and false otherwise */
  public boolean isSetTaskDag() {
    return this.taskDag != null;
  }

  public void setTaskDagIsSet(boolean value) {
    if (!value) {
      this.taskDag = null;
    }
  }

  public int getProcessErrorsSize() {
    return (this.processErrors == null) ? 0 : this.processErrors.size();
  }

  public java.util.Iterator<org.apache.airavata.model.commons.ErrorModel> getProcessErrorsIterator() {
    return (this.processErrors == null) ? null : this.processErrors.iterator();
  }

  public void addToProcessErrors(org.apache.airavata.model.commons.ErrorModel elem) {
    if (this.processErrors == null) {
      this.processErrors = new ArrayList<org.apache.airavata.model.commons.ErrorModel>();
    }
    this.processErrors.add(elem);
  }

  public List<org.apache.airavata.model.commons.ErrorModel> getProcessErrors() {
    return this.processErrors;
  }

  public void setProcessErrors(List<org.apache.airavata.model.commons.ErrorModel> processErrors) {
    this.processErrors = processErrors;
  }

  public void unsetProcessErrors() {
    this.processErrors = null;
  }

  /** Returns true if field processErrors is set (has been assigned a value) and false otherwise */
  public boolean isSetProcessErrors() {
    return this.processErrors != null;
  }

  public void setProcessErrorsIsSet(boolean value) {
    if (!value) {
      this.processErrors = null;
    }
  }

  public String getGatewayExecutionId() {
    return this.gatewayExecutionId;
  }

  public void setGatewayExecutionId(String gatewayExecutionId) {
    this.gatewayExecutionId = gatewayExecutionId;
  }

  public void unsetGatewayExecutionId() {
    this.gatewayExecutionId = null;
  }

  /** Returns true if field gatewayExecutionId is set (has been assigned a value) and false otherwise */
  public boolean isSetGatewayExecutionId() {
    return this.gatewayExecutionId != null;
  }

  public void setGatewayExecutionIdIsSet(boolean value) {
    if (!value) {
      this.gatewayExecutionId = null;
    }
  }

  public boolean isEnableEmailNotification() {
    return this.enableEmailNotification;
  }

  public void setEnableEmailNotification(boolean enableEmailNotification) {
    this.enableEmailNotification = enableEmailNotification;
    setEnableEmailNotificationIsSet(true);
  }

  public void unsetEnableEmailNotification() {
    __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __ENABLEEMAILNOTIFICATION_ISSET_ID);
  }

  /** Returns true if field enableEmailNotification is set (has been assigned a value) and false otherwise */
  public boolean isSetEnableEmailNotification() {
    return EncodingUtils.testBit(__isset_bitfield, __ENABLEEMAILNOTIFICATION_ISSET_ID);
  }

  public void setEnableEmailNotificationIsSet(boolean value) {
    __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __ENABLEEMAILNOTIFICATION_ISSET_ID, value);
  }

  public int getEmailAddressesSize() {
    return (this.emailAddresses == null) ? 0 : this.emailAddresses.size();
  }

  public java.util.Iterator<String> getEmailAddressesIterator() {
    return (this.emailAddresses == null) ? null : this.emailAddresses.iterator();
  }

  public void addToEmailAddresses(String elem) {
    if (this.emailAddresses == null) {
      this.emailAddresses = new ArrayList<String>();
    }
    this.emailAddresses.add(elem);
  }

  public List<String> getEmailAddresses() {
    return this.emailAddresses;
  }

  public void setEmailAddresses(List<String> emailAddresses) {
    this.emailAddresses = emailAddresses;
  }

  public void unsetEmailAddresses() {
    this.emailAddresses = null;
  }

  /** Returns true if field emailAddresses is set (has been assigned a value) and false otherwise */
  public boolean isSetEmailAddresses() {
    return this.emailAddresses != null;
  }

  public void setEmailAddressesIsSet(boolean value) {
    if (!value) {
      this.emailAddresses = null;
    }
  }

  public String getStorageResourceId() {
    return this.storageResourceId;
  }

  public void setStorageResourceId(String storageResourceId) {
    this.storageResourceId = storageResourceId;
  }

  public void unsetStorageResourceId() {
    this.storageResourceId = null;
  }

  /** Returns true if field storageResourceId is set (has been assigned a value) and false otherwise */
  public boolean isSetStorageResourceId() {
    return this.storageResourceId != null;
  }

  public void setStorageResourceIdIsSet(boolean value) {
    if (!value) {
      this.storageResourceId = null;
    }
  }

  public String getUserDn() {
    return this.userDn;
  }

  public void setUserDn(String userDn) {
    this.userDn = userDn;
  }

  public void unsetUserDn() {
    this.userDn = null;
  }

  /** Returns true if field userDn is set (has been assigned a value) and false otherwise */
  public boolean isSetUserDn() {
    return this.userDn != null;
  }

  public void setUserDnIsSet(boolean value) {
    if (!value) {
      this.userDn = null;
    }
  }

  public boolean isGenerateCert() {
    return this.generateCert;
  }

  public void setGenerateCert(boolean generateCert) {
    this.generateCert = generateCert;
    setGenerateCertIsSet(true);
  }

  public void unsetGenerateCert() {
    __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __GENERATECERT_ISSET_ID);
  }

  /** Returns true if field generateCert is set (has been assigned a value) and false otherwise */
  public boolean isSetGenerateCert() {
    return EncodingUtils.testBit(__isset_bitfield, __GENERATECERT_ISSET_ID);
  }

  public void setGenerateCertIsSet(boolean value) {
    __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __GENERATECERT_ISSET_ID, value);
  }

  public String getExperimentDataDir() {
    return this.experimentDataDir;
  }

  public void setExperimentDataDir(String experimentDataDir) {
    this.experimentDataDir = experimentDataDir;
  }

  public void unsetExperimentDataDir() {
    this.experimentDataDir = null;
  }

  /** Returns true if field experimentDataDir is set (has been assigned a value) and false otherwise */
  public boolean isSetExperimentDataDir() {
    return this.experimentDataDir != null;
  }

  public void setExperimentDataDirIsSet(boolean value) {
    if (!value) {
      this.experimentDataDir = null;
    }
  }

  public String getUserName() {
    return this.userName;
  }

  public void setUserName(String userName) {
    this.userName = userName;
  }

  public void unsetUserName() {
    this.userName = null;
  }

  /** Returns true if field userName is set (has been assigned a value) and false otherwise */
  public boolean isSetUserName() {
    return this.userName != null;
  }

  public void setUserNameIsSet(boolean value) {
    if (!value) {
      this.userName = null;
    }
  }

  public boolean isUseUserCRPref() {
    return this.useUserCRPref;
  }

  public void setUseUserCRPref(boolean useUserCRPref) {
    this.useUserCRPref = useUserCRPref;
    setUseUserCRPrefIsSet(true);
  }

  public void unsetUseUserCRPref() {
    __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __USEUSERCRPREF_ISSET_ID);
  }

  /** Returns true if field useUserCRPref is set (has been assigned a value) and false otherwise */
  public boolean isSetUseUserCRPref() {
    return EncodingUtils.testBit(__isset_bitfield, __USEUSERCRPREF_ISSET_ID);
  }

  public void setUseUserCRPrefIsSet(boolean value) {
    __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __USEUSERCRPREF_ISSET_ID, value);
  }

  public void setFieldValue(_Fields field, Object value) {
    switch (field) {
    case PROCESS_ID:
      if (value == null) {
        unsetProcessId();
      } else {
        setProcessId((String)value);
      }
      break;

    case EXPERIMENT_ID:
      if (value == null) {
        unsetExperimentId();
      } else {
        setExperimentId((String)value);
      }
      break;

    case CREATION_TIME:
      if (value == null) {
        unsetCreationTime();
      } else {
        setCreationTime((Long)value);
      }
      break;

    case LAST_UPDATE_TIME:
      if (value == null) {
        unsetLastUpdateTime();
      } else {
        setLastUpdateTime((Long)value);
      }
      break;

    case PROCESS_STATUSES:
      if (value == null) {
        unsetProcessStatuses();
      } else {
        setProcessStatuses((List<org.apache.airavata.model.status.ProcessStatus>)value);
      }
      break;

    case PROCESS_DETAIL:
      if (value == null) {
        unsetProcessDetail();
      } else {
        setProcessDetail((String)value);
      }
      break;

    case APPLICATION_INTERFACE_ID:
      if (value == null) {
        unsetApplicationInterfaceId();
      } else {
        setApplicationInterfaceId((String)value);
      }
      break;

    case APPLICATION_DEPLOYMENT_ID:
      if (value == null) {
        unsetApplicationDeploymentId();
      } else {
        setApplicationDeploymentId((String)value);
      }
      break;

    case COMPUTE_RESOURCE_ID:
      if (value == null) {
        unsetComputeResourceId();
      } else {
        setComputeResourceId((String)value);
      }
      break;

    case PROCESS_INPUTS:
      if (value == null) {
        unsetProcessInputs();
      } else {
        setProcessInputs((List<org.apache.airavata.model.application.io.InputDataObjectType>)value);
      }
      break;

    case PROCESS_OUTPUTS:
      if (value == null) {
        unsetProcessOutputs();
      } else {
        setProcessOutputs((List<org.apache.airavata.model.application.io.OutputDataObjectType>)value);
      }
      break;

    case PROCESS_RESOURCE_SCHEDULE:
      if (value == null) {
        unsetProcessResourceSchedule();
      } else {
        setProcessResourceSchedule((org.apache.airavata.model.scheduling.ComputationalResourceSchedulingModel)value);
      }
      break;

    case TASKS:
      if (value == null) {
        unsetTasks();
      } else {
        setTasks((List<org.apache.airavata.model.task.TaskModel>)value);
      }
      break;

    case TASK_DAG:
      if (value == null) {
        unsetTaskDag();
      } else {
        setTaskDag((String)value);
      }
      break;

    case PROCESS_ERRORS:
      if (value == null) {
        unsetProcessErrors();
      } else {
        setProcessErrors((List<org.apache.airavata.model.commons.ErrorModel>)value);
      }
      break;

    case GATEWAY_EXECUTION_ID:
      if (value == null) {
        unsetGatewayExecutionId();
      } else {
        setGatewayExecutionId((String)value);
      }
      break;

    case ENABLE_EMAIL_NOTIFICATION:
      if (value == null) {
        unsetEnableEmailNotification();
      } else {
        setEnableEmailNotification((Boolean)value);
      }
      break;

    case EMAIL_ADDRESSES:
      if (value == null) {
        unsetEmailAddresses();
      } else {
        setEmailAddresses((List<String>)value);
      }
      break;

    case STORAGE_RESOURCE_ID:
      if (value == null) {
        unsetStorageResourceId();
      } else {
        setStorageResourceId((String)value);
      }
      break;

    case USER_DN:
      if (value == null) {
        unsetUserDn();
      } else {
        setUserDn((String)value);
      }
      break;

    case GENERATE_CERT:
      if (value == null) {
        unsetGenerateCert();
      } else {
        setGenerateCert((Boolean)value);
      }
      break;

    case EXPERIMENT_DATA_DIR:
      if (value == null) {
        unsetExperimentDataDir();
      } else {
        setExperimentDataDir((String)value);
      }
      break;

    case USER_NAME:
      if (value == null) {
        unsetUserName();
      } else {
        setUserName((String)value);
      }
      break;

    case USE_USER_CRPREF:
      if (value == null) {
        unsetUseUserCRPref();
      } else {
        setUseUserCRPref((Boolean)value);
      }
      break;

    }
  }

  public Object getFieldValue(_Fields field) {
    switch (field) {
    case PROCESS_ID:
      return getProcessId();

    case EXPERIMENT_ID:
      return getExperimentId();

    case CREATION_TIME:
      return getCreationTime();

    case LAST_UPDATE_TIME:
      return getLastUpdateTime();

    case PROCESS_STATUSES:
      return getProcessStatuses();

    case PROCESS_DETAIL:
      return getProcessDetail();

    case APPLICATION_INTERFACE_ID:
      return getApplicationInterfaceId();

    case APPLICATION_DEPLOYMENT_ID:
      return getApplicationDeploymentId();

    case COMPUTE_RESOURCE_ID:
      return getComputeResourceId();

    case PROCESS_INPUTS:
      return getProcessInputs();

    case PROCESS_OUTPUTS:
      return getProcessOutputs();

    case PROCESS_RESOURCE_SCHEDULE:
      return getProcessResourceSchedule();

    case TASKS:
      return getTasks();

    case TASK_DAG:
      return getTaskDag();

    case PROCESS_ERRORS:
      return getProcessErrors();

    case GATEWAY_EXECUTION_ID:
      return getGatewayExecutionId();

    case ENABLE_EMAIL_NOTIFICATION:
      return isEnableEmailNotification();

    case EMAIL_ADDRESSES:
      return getEmailAddresses();

    case STORAGE_RESOURCE_ID:
      return getStorageResourceId();

    case USER_DN:
      return getUserDn();

    case GENERATE_CERT:
      return isGenerateCert();

    case EXPERIMENT_DATA_DIR:
      return getExperimentDataDir();

    case USER_NAME:
      return getUserName();

    case USE_USER_CRPREF:
      return isUseUserCRPref();

    }
    throw new IllegalStateException();
  }

  /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
  public boolean isSet(_Fields field) {
    if (field == null) {
      throw new IllegalArgumentException();
    }

    switch (field) {
    case PROCESS_ID:
      return isSetProcessId();
    case EXPERIMENT_ID:
      return isSetExperimentId();
    case CREATION_TIME:
      return isSetCreationTime();
    case LAST_UPDATE_TIME:
      return isSetLastUpdateTime();
    case PROCESS_STATUSES:
      return isSetProcessStatuses();
    case PROCESS_DETAIL:
      return isSetProcessDetail();
    case APPLICATION_INTERFACE_ID:
      return isSetApplicationInterfaceId();
    case APPLICATION_DEPLOYMENT_ID:
      return isSetApplicationDeploymentId();
    case COMPUTE_RESOURCE_ID:
      return isSetComputeResourceId();
    case PROCESS_INPUTS:
      return isSetProcessInputs();
    case PROCESS_OUTPUTS:
      return isSetProcessOutputs();
    case PROCESS_RESOURCE_SCHEDULE:
      return isSetProcessResourceSchedule();
    case TASKS:
      return isSetTasks();
    case TASK_DAG:
      return isSetTaskDag();
    case PROCESS_ERRORS:
      return isSetProcessErrors();
    case GATEWAY_EXECUTION_ID:
      return isSetGatewayExecutionId();
    case ENABLE_EMAIL_NOTIFICATION:
      return isSetEnableEmailNotification();
    case EMAIL_ADDRESSES:
      return isSetEmailAddresses();
    case STORAGE_RESOURCE_ID:
      return isSetStorageResourceId();
    case USER_DN:
      return isSetUserDn();
    case GENERATE_CERT:
      return isSetGenerateCert();
    case EXPERIMENT_DATA_DIR:
      return isSetExperimentDataDir();
    case USER_NAME:
      return isSetUserName();
    case USE_USER_CRPREF:
      return isSetUseUserCRPref();
    }
    throw new IllegalStateException();
  }

  @Override
  public boolean equals(Object that) {
    if (that == null)
      return false;
    if (that instanceof ProcessModel)
      return this.equals((ProcessModel)that);
    return false;
  }

  public boolean equals(ProcessModel that) {
    if (that == null)
      return false;

    boolean this_present_processId = true && this.isSetProcessId();
    boolean that_present_processId = true && that.isSetProcessId();
    if (this_present_processId || that_present_processId) {
      if (!(this_present_processId && that_present_processId))
        return false;
      if (!this.processId.equals(that.processId))
        return false;
    }

    boolean this_present_experimentId = true && this.isSetExperimentId();
    boolean that_present_experimentId = true && that.isSetExperimentId();
    if (this_present_experimentId || that_present_experimentId) {
      if (!(this_present_experimentId && that_present_experimentId))
        return false;
      if (!this.experimentId.equals(that.experimentId))
        return false;
    }

    boolean this_present_creationTime = true && this.isSetCreationTime();
    boolean that_present_creationTime = true && that.isSetCreationTime();
    if (this_present_creationTime || that_present_creationTime) {
      if (!(this_present_creationTime && that_present_creationTime))
        return false;
      if (this.creationTime != that.creationTime)
        return false;
    }

    boolean this_present_lastUpdateTime = true && this.isSetLastUpdateTime();
    boolean that_present_lastUpdateTime = true && that.isSetLastUpdateTime();
    if (this_present_lastUpdateTime || that_present_lastUpdateTime) {
      if (!(this_present_lastUpdateTime && that_present_lastUpdateTime))
        return false;
      if (this.lastUpdateTime != that.lastUpdateTime)
        return false;
    }

    boolean this_present_processStatuses = true && this.isSetProcessStatuses();
    boolean that_present_processStatuses = true && that.isSetProcessStatuses();
    if (this_present_processStatuses || that_present_processStatuses) {
      if (!(this_present_processStatuses && that_present_processStatuses))
        return false;
      if (!this.processStatuses.equals(that.processStatuses))
        return false;
    }

    boolean this_present_processDetail = true && this.isSetProcessDetail();
    boolean that_present_processDetail = true && that.isSetProcessDetail();
    if (this_present_processDetail || that_present_processDetail) {
      if (!(this_present_processDetail && that_present_processDetail))
        return false;
      if (!this.processDetail.equals(that.processDetail))
        return false;
    }

    boolean this_present_applicationInterfaceId = true && this.isSetApplicationInterfaceId();
    boolean that_present_applicationInterfaceId = true && that.isSetApplicationInterfaceId();
    if (this_present_applicationInterfaceId || that_present_applicationInterfaceId) {
      if (!(this_present_applicationInterfaceId && that_present_applicationInterfaceId))
        return false;
      if (!this.applicationInterfaceId.equals(that.applicationInterfaceId))
        return false;
    }

    boolean this_present_applicationDeploymentId = true && this.isSetApplicationDeploymentId();
    boolean that_present_applicationDeploymentId = true && that.isSetApplicationDeploymentId();
    if (this_present_applicationDeploymentId || that_present_applicationDeploymentId) {
      if (!(this_present_applicationDeploymentId && that_present_applicationDeploymentId))
        return false;
      if (!this.applicationDeploymentId.equals(that.applicationDeploymentId))
        return false;
    }

    boolean this_present_computeResourceId = true && this.isSetComputeResourceId();
    boolean that_present_computeResourceId = true && that.isSetComputeResourceId();
    if (this_present_computeResourceId || that_present_computeResourceId) {
      if (!(this_present_computeResourceId && that_present_computeResourceId))
        return false;
      if (!this.computeResourceId.equals(that.computeResourceId))
        return false;
    }

    boolean this_present_processInputs = true && this.isSetProcessInputs();
    boolean that_present_processInputs = true && that.isSetProcessInputs();
    if (this_present_processInputs || that_present_processInputs) {
      if (!(this_present_processInputs && that_present_processInputs))
        return false;
      if (!this.processInputs.equals(that.processInputs))
        return false;
    }

    boolean this_present_processOutputs = true && this.isSetProcessOutputs();
    boolean that_present_processOutputs = true && that.isSetProcessOutputs();
    if (this_present_processOutputs || that_present_processOutputs) {
      if (!(this_present_processOutputs && that_present_processOutputs))
        return false;
      if (!this.processOutputs.equals(that.processOutputs))
        return false;
    }

    boolean this_present_processResourceSchedule = true && this.isSetProcessResourceSchedule();
    boolean that_present_processResourceSchedule = true && that.isSetProcessResourceSchedule();
    if (this_present_processResourceSchedule || that_present_processResourceSchedule) {
      if (!(this_present_processResourceSchedule && that_present_processResourceSchedule))
        return false;
      if (!this.processResourceSchedule.equals(that.processResourceSchedule))
        return false;
    }

    boolean this_present_tasks = true && this.isSetTasks();
    boolean that_present_tasks = true && that.isSetTasks();
    if (this_present_tasks || that_present_tasks) {
      if (!(this_present_tasks && that_present_tasks))
        return false;
      if (!this.tasks.equals(that.tasks))
        return false;
    }

    boolean this_present_taskDag = true && this.isSetTaskDag();
    boolean that_present_taskDag = true && that.isSetTaskDag();
    if (this_present_taskDag || that_present_taskDag) {
      if (!(this_present_taskDag && that_present_taskDag))
        return false;
      if (!this.taskDag.equals(that.taskDag))
        return false;
    }

    boolean this_present_processErrors = true && this.isSetProcessErrors();
    boolean that_present_processErrors = true && that.isSetProcessErrors();
    if (this_present_processErrors || that_present_processErrors) {
      if (!(this_present_processErrors && that_present_processErrors))
        return false;
      if (!this.processErrors.equals(that.processErrors))
        return false;
    }

    boolean this_present_gatewayExecutionId = true && this.isSetGatewayExecutionId();
    boolean that_present_gatewayExecutionId = true && that.isSetGatewayExecutionId();
    if (this_present_gatewayExecutionId || that_present_gatewayExecutionId) {
      if (!(this_present_gatewayExecutionId && that_present_gatewayExecutionId))
        return false;
      if (!this.gatewayExecutionId.equals(that.gatewayExecutionId))
        return false;
    }

    boolean this_present_enableEmailNotification = true && this.isSetEnableEmailNotification();
    boolean that_present_enableEmailNotification = true && that.isSetEnableEmailNotification();
    if (this_present_enableEmailNotification || that_present_enableEmailNotification) {
      if (!(this_present_enableEmailNotification && that_present_enableEmailNotification))
        return false;
      if (this.enableEmailNotification != that.enableEmailNotification)
        return false;
    }

    boolean this_present_emailAddresses = true && this.isSetEmailAddresses();
    boolean that_present_emailAddresses = true && that.isSetEmailAddresses();
    if (this_present_emailAddresses || that_present_emailAddresses) {
      if (!(this_present_emailAddresses && that_present_emailAddresses))
        return false;
      if (!this.emailAddresses.equals(that.emailAddresses))
        return false;
    }

    boolean this_present_storageResourceId = true && this.isSetStorageResourceId();
    boolean that_present_storageResourceId = true && that.isSetStorageResourceId();
    if (this_present_storageResourceId || that_present_storageResourceId) {
      if (!(this_present_storageResourceId && that_present_storageResourceId))
        return false;
      if (!this.storageResourceId.equals(that.storageResourceId))
        return false;
    }

    boolean this_present_userDn = true && this.isSetUserDn();
    boolean that_present_userDn = true && that.isSetUserDn();
    if (this_present_userDn || that_present_userDn) {
      if (!(this_present_userDn && that_present_userDn))
        return false;
      if (!this.userDn.equals(that.userDn))
        return false;
    }

    boolean this_present_generateCert = true && this.isSetGenerateCert();
    boolean that_present_generateCert = true && that.isSetGenerateCert();
    if (this_present_generateCert || that_present_generateCert) {
      if (!(this_present_generateCert && that_present_generateCert))
        return false;
      if (this.generateCert != that.generateCert)
        return false;
    }

    boolean this_present_experimentDataDir = true && this.isSetExperimentDataDir();
    boolean that_present_experimentDataDir = true && that.isSetExperimentDataDir();
    if (this_present_experimentDataDir || that_present_experimentDataDir) {
      if (!(this_present_experimentDataDir && that_present_experimentDataDir))
        return false;
      if (!this.experimentDataDir.equals(that.experimentDataDir))
        return false;
    }

    boolean this_present_userName = true && this.isSetUserName();
    boolean that_present_userName = true && that.isSetUserName();
    if (this_present_userName || that_present_userName) {
      if (!(this_present_userName && that_present_userName))
        return false;
      if (!this.userName.equals(that.userName))
        return false;
    }

    boolean this_present_useUserCRPref = true && this.isSetUseUserCRPref();
    boolean that_present_useUserCRPref = true && that.isSetUseUserCRPref();
    if (this_present_useUserCRPref || that_present_useUserCRPref) {
      if (!(this_present_useUserCRPref && that_present_useUserCRPref))
        return false;
      if (this.useUserCRPref != that.useUserCRPref)
        return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    List<Object> list = new ArrayList<Object>();

    boolean present_processId = true && (isSetProcessId());
    list.add(present_processId);
    if (present_processId)
      list.add(processId);

    boolean present_experimentId = true && (isSetExperimentId());
    list.add(present_experimentId);
    if (present_experimentId)
      list.add(experimentId);

    boolean present_creationTime = true && (isSetCreationTime());
    list.add(present_creationTime);
    if (present_creationTime)
      list.add(creationTime);

    boolean present_lastUpdateTime = true && (isSetLastUpdateTime());
    list.add(present_lastUpdateTime);
    if (present_lastUpdateTime)
      list.add(lastUpdateTime);

    boolean present_processStatuses = true && (isSetProcessStatuses());
    list.add(present_processStatuses);
    if (present_processStatuses)
      list.add(processStatuses);

    boolean present_processDetail = true && (isSetProcessDetail());
    list.add(present_processDetail);
    if (present_processDetail)
      list.add(processDetail);

    boolean present_applicationInterfaceId = true && (isSetApplicationInterfaceId());
    list.add(present_applicationInterfaceId);
    if (present_applicationInterfaceId)
      list.add(applicationInterfaceId);

    boolean present_applicationDeploymentId = true && (isSetApplicationDeploymentId());
    list.add(present_applicationDeploymentId);
    if (present_applicationDeploymentId)
      list.add(applicationDeploymentId);

    boolean present_computeResourceId = true && (isSetComputeResourceId());
    list.add(present_computeResourceId);
    if (present_computeResourceId)
      list.add(computeResourceId);

    boolean present_processInputs = true && (isSetProcessInputs());
    list.add(present_processInputs);
    if (present_processInputs)
      list.add(processInputs);

    boolean present_processOutputs = true && (isSetProcessOutputs());
    list.add(present_processOutputs);
    if (present_processOutputs)
      list.add(processOutputs);

    boolean present_processResourceSchedule = true && (isSetProcessResourceSchedule());
    list.add(present_processResourceSchedule);
    if (present_processResourceSchedule)
      list.add(processResourceSchedule);

    boolean present_tasks = true && (isSetTasks());
    list.add(present_tasks);
    if (present_tasks)
      list.add(tasks);

    boolean present_taskDag = true && (isSetTaskDag());
    list.add(present_taskDag);
    if (present_taskDag)
      list.add(taskDag);

    boolean present_processErrors = true && (isSetProcessErrors());
    list.add(present_processErrors);
    if (present_processErrors)
      list.add(processErrors);

    boolean present_gatewayExecutionId = true && (isSetGatewayExecutionId());
    list.add(present_gatewayExecutionId);
    if (present_gatewayExecutionId)
      list.add(gatewayExecutionId);

    boolean present_enableEmailNotification = true && (isSetEnableEmailNotification());
    list.add(present_enableEmailNotification);
    if (present_enableEmailNotification)
      list.add(enableEmailNotification);

    boolean present_emailAddresses = true && (isSetEmailAddresses());
    list.add(present_emailAddresses);
    if (present_emailAddresses)
      list.add(emailAddresses);

    boolean present_storageResourceId = true && (isSetStorageResourceId());
    list.add(present_storageResourceId);
    if (present_storageResourceId)
      list.add(storageResourceId);

    boolean present_userDn = true && (isSetUserDn());
    list.add(present_userDn);
    if (present_userDn)
      list.add(userDn);

    boolean present_generateCert = true && (isSetGenerateCert());
    list.add(present_generateCert);
    if (present_generateCert)
      list.add(generateCert);

    boolean present_experimentDataDir = true && (isSetExperimentDataDir());
    list.add(present_experimentDataDir);
    if (present_experimentDataDir)
      list.add(experimentDataDir);

    boolean present_userName = true && (isSetUserName());
    list.add(present_userName);
    if (present_userName)
      list.add(userName);

    boolean present_useUserCRPref = true && (isSetUseUserCRPref());
    list.add(present_useUserCRPref);
    if (present_useUserCRPref)
      list.add(useUserCRPref);

    return list.hashCode();
  }

  @Override
  public int compareTo(ProcessModel other) {
    if (!getClass().equals(other.getClass())) {
      return getClass().getName().compareTo(other.getClass().getName());
    }

    int lastComparison = 0;

    lastComparison = Boolean.valueOf(isSetProcessId()).compareTo(other.isSetProcessId());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetProcessId()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.processId, other.processId);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetExperimentId()).compareTo(other.isSetExperimentId());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetExperimentId()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.experimentId, other.experimentId);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetCreationTime()).compareTo(other.isSetCreationTime());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetCreationTime()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.creationTime, other.creationTime);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetLastUpdateTime()).compareTo(other.isSetLastUpdateTime());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetLastUpdateTime()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.lastUpdateTime, other.lastUpdateTime);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetProcessStatuses()).compareTo(other.isSetProcessStatuses());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetProcessStatuses()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.processStatuses, other.processStatuses);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetProcessDetail()).compareTo(other.isSetProcessDetail());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetProcessDetail()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.processDetail, other.processDetail);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetApplicationInterfaceId()).compareTo(other.isSetApplicationInterfaceId());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetApplicationInterfaceId()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.applicationInterfaceId, other.applicationInterfaceId);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetApplicationDeploymentId()).compareTo(other.isSetApplicationDeploymentId());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetApplicationDeploymentId()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.applicationDeploymentId, other.applicationDeploymentId);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetComputeResourceId()).compareTo(other.isSetComputeResourceId());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetComputeResourceId()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.computeResourceId, other.computeResourceId);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetProcessInputs()).compareTo(other.isSetProcessInputs());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetProcessInputs()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.processInputs, other.processInputs);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetProcessOutputs()).compareTo(other.isSetProcessOutputs());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetProcessOutputs()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.processOutputs, other.processOutputs);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetProcessResourceSchedule()).compareTo(other.isSetProcessResourceSchedule());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetProcessResourceSchedule()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.processResourceSchedule, other.processResourceSchedule);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetTasks()).compareTo(other.isSetTasks());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetTasks()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tasks, other.tasks);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetTaskDag()).compareTo(other.isSetTaskDag());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetTaskDag()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.taskDag, other.taskDag);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetProcessErrors()).compareTo(other.isSetProcessErrors());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetProcessErrors()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.processErrors, other.processErrors);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetGatewayExecutionId()).compareTo(other.isSetGatewayExecutionId());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetGatewayExecutionId()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.gatewayExecutionId, other.gatewayExecutionId);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetEnableEmailNotification()).compareTo(other.isSetEnableEmailNotification());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetEnableEmailNotification()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.enableEmailNotification, other.enableEmailNotification);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetEmailAddresses()).compareTo(other.isSetEmailAddresses());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetEmailAddresses()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.emailAddresses, other.emailAddresses);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetStorageResourceId()).compareTo(other.isSetStorageResourceId());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetStorageResourceId()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.storageResourceId, other.storageResourceId);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetUserDn()).compareTo(other.isSetUserDn());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetUserDn()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.userDn, other.userDn);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetGenerateCert()).compareTo(other.isSetGenerateCert());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetGenerateCert()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.generateCert, other.generateCert);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetExperimentDataDir()).compareTo(other.isSetExperimentDataDir());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetExperimentDataDir()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.experimentDataDir, other.experimentDataDir);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetUserName()).compareTo(other.isSetUserName());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetUserName()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.userName, other.userName);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetUseUserCRPref()).compareTo(other.isSetUseUserCRPref());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetUseUserCRPref()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.useUserCRPref, other.useUserCRPref);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    return 0;
  }

  public _Fields fieldForId(int fieldId) {
    return _Fields.findByThriftId(fieldId);
  }

  public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
    schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
  }

  public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
    schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder("ProcessModel(");
    boolean first = true;

    sb.append("processId:");
    if (this.processId == null) {
      sb.append("null");
    } else {
      sb.append(this.processId);
    }
    first = false;
    if (!first) sb.append(", ");
    sb.append("experimentId:");
    if (this.experimentId == null) {
      sb.append("null");
    } else {
      sb.append(this.experimentId);
    }
    first = false;
    if (isSetCreationTime()) {
      if (!first) sb.append(", ");
      sb.append("creationTime:");
      sb.append(this.creationTime);
      first = false;
    }
    if (isSetLastUpdateTime()) {
      if (!first) sb.append(", ");
      sb.append("lastUpdateTime:");
      sb.append(this.lastUpdateTime);
      first = false;
    }
    if (isSetProcessStatuses()) {
      if (!first) sb.append(", ");
      sb.append("processStatuses:");
      if (this.processStatuses == null) {
        sb.append("null");
      } else {
        sb.append(this.processStatuses);
      }
      first = false;
    }
    if (isSetProcessDetail()) {
      if (!first) sb.append(", ");
      sb.append("processDetail:");
      if (this.processDetail == null) {
        sb.append("null");
      } else {
        sb.append(this.processDetail);
      }
      first = false;
    }
    if (isSetApplicationInterfaceId()) {
      if (!first) sb.append(", ");
      sb.append("applicationInterfaceId:");
      if (this.applicationInterfaceId == null) {
        sb.append("null");
      } else {
        sb.append(this.applicationInterfaceId);
      }
      first = false;
    }
    if (isSetApplicationDeploymentId()) {
      if (!first) sb.append(", ");
      sb.append("applicationDeploymentId:");
      if (this.applicationDeploymentId == null) {
        sb.append("null");
      } else {
        sb.append(this.applicationDeploymentId);
      }
      first = false;
    }
    if (isSetComputeResourceId()) {
      if (!first) sb.append(", ");
      sb.append("computeResourceId:");
      if (this.computeResourceId == null) {
        sb.append("null");
      } else {
        sb.append(this.computeResourceId);
      }
      first = false;
    }
    if (isSetProcessInputs()) {
      if (!first) sb.append(", ");
      sb.append("processInputs:");
      if (this.processInputs == null) {
        sb.append("null");
      } else {
        sb.append(this.processInputs);
      }
      first = false;
    }
    if (isSetProcessOutputs()) {
      if (!first) sb.append(", ");
      sb.append("processOutputs:");
      if (this.processOutputs == null) {
        sb.append("null");
      } else {
        sb.append(this.processOutputs);
      }
      first = false;
    }
    if (isSetProcessResourceSchedule()) {
      if (!first) sb.append(", ");
      sb.append("processResourceSchedule:");
      if (this.processResourceSchedule == null) {
        sb.append("null");
      } else {
        sb.append(this.processResourceSchedule);
      }
      first = false;
    }
    if (isSetTasks()) {
      if (!first) sb.append(", ");
      sb.append("tasks:");
      if (this.tasks == null) {
        sb.append("null");
      } else {
        sb.append(this.tasks);
      }
      first = false;
    }
    if (isSetTaskDag()) {
      if (!first) sb.append(", ");
      sb.append("taskDag:");
      if (this.taskDag == null) {
        sb.append("null");
      } else {
        sb.append(this.taskDag);
      }
      first = false;
    }
    if (isSetProcessErrors()) {
      if (!first) sb.append(", ");
      sb.append("processErrors:");
      if (this.processErrors == null) {
        sb.append("null");
      } else {
        sb.append(this.processErrors);
      }
      first = false;
    }
    if (isSetGatewayExecutionId()) {
      if (!first) sb.append(", ");
      sb.append("gatewayExecutionId:");
      if (this.gatewayExecutionId == null) {
        sb.append("null");
      } else {
        sb.append(this.gatewayExecutionId);
      }
      first = false;
    }
    if (isSetEnableEmailNotification()) {
      if (!first) sb.append(", ");
      sb.append("enableEmailNotification:");
      sb.append(this.enableEmailNotification);
      first = false;
    }
    if (isSetEmailAddresses()) {
      if (!first) sb.append(", ");
      sb.append("emailAddresses:");
      if (this.emailAddresses == null) {
        sb.append("null");
      } else {
        sb.append(this.emailAddresses);
      }
      first = false;
    }
    if (isSetStorageResourceId()) {
      if (!first) sb.append(", ");
      sb.append("storageResourceId:");
      if (this.storageResourceId == null) {
        sb.append("null");
      } else {
        sb.append(this.storageResourceId);
      }
      first = false;
    }
    if (isSetUserDn()) {
      if (!first) sb.append(", ");
      sb.append("userDn:");
      if (this.userDn == null) {
        sb.append("null");
      } else {
        sb.append(this.userDn);
      }
      first = false;
    }
    if (isSetGenerateCert()) {
      if (!first) sb.append(", ");
      sb.append("generateCert:");
      sb.append(this.generateCert);
      first = false;
    }
    if (isSetExperimentDataDir()) {
      if (!first) sb.append(", ");
      sb.append("experimentDataDir:");
      if (this.experimentDataDir == null) {
        sb.append("null");
      } else {
        sb.append(this.experimentDataDir);
      }
      first = false;
    }
    if (isSetUserName()) {
      if (!first) sb.append(", ");
      sb.append("userName:");
      if (this.userName == null) {
        sb.append("null");
      } else {
        sb.append(this.userName);
      }
      first = false;
    }
    if (isSetUseUserCRPref()) {
      if (!first) sb.append(", ");
      sb.append("useUserCRPref:");
      sb.append(this.useUserCRPref);
      first = false;
    }
    sb.append(")");
    return sb.toString();
  }

  public void validate() throws org.apache.thrift.TException {
    // check for required fields
    if (!isSetProcessId()) {
      throw new org.apache.thrift.protocol.TProtocolException("Required field 'processId' is unset! Struct:" + toString());
    }

    if (!isSetExperimentId()) {
      throw new org.apache.thrift.protocol.TProtocolException("Required field 'experimentId' is unset! Struct:" + toString());
    }

    // check for sub-struct validity
    if (processResourceSchedule != null) {
      processResourceSchedule.validate();
    }
  }

  private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
    try {
      write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
    } catch (org.apache.thrift.TException te) {
      throw new java.io.IOException(te);
    }
  }

  private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
    try {
      // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
      __isset_bitfield = 0;
      read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
    } catch (org.apache.thrift.TException te) {
      throw new java.io.IOException(te);
    }
  }

  private static class ProcessModelStandardSchemeFactory implements SchemeFactory {
    public ProcessModelStandardScheme getScheme() {
      return new ProcessModelStandardScheme();
    }
  }

  private static class ProcessModelStandardScheme extends StandardScheme<ProcessModel> {

    public void read(org.apache.thrift.protocol.TProtocol iprot, ProcessModel struct) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField schemeField;
      iprot.readStructBegin();
      while (true)
      {
        schemeField = iprot.readFieldBegin();
        if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
          break;
        }
        switch (schemeField.id) {
          case 1: // PROCESS_ID
            if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
              struct.processId = iprot.readString();
              struct.setProcessIdIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 2: // EXPERIMENT_ID
            if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
              struct.experimentId = iprot.readString();
              struct.setExperimentIdIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 3: // CREATION_TIME
            if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
              struct.creationTime = iprot.readI64();
              struct.setCreationTimeIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 4: // LAST_UPDATE_TIME
            if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
              struct.lastUpdateTime = iprot.readI64();
              struct.setLastUpdateTimeIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 5: // PROCESS_STATUSES
            if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
              {
                org.apache.thrift.protocol.TList _list0 = iprot.readListBegin();
                struct.processStatuses = new ArrayList<org.apache.airavata.model.status.ProcessStatus>(_list0.size);
                org.apache.airavata.model.status.ProcessStatus _elem1;
                for (int _i2 = 0; _i2 < _list0.size; ++_i2)
                {
                  _elem1 = new org.apache.airavata.model.status.ProcessStatus();
                  _elem1.read(iprot);
                  struct.processStatuses.add(_elem1);
                }
                iprot.readListEnd();
              }
              struct.setProcessStatusesIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 6: // PROCESS_DETAIL
            if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
              struct.processDetail = iprot.readString();
              struct.setProcessDetailIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 7: // APPLICATION_INTERFACE_ID
            if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
              struct.applicationInterfaceId = iprot.readString();
              struct.setApplicationInterfaceIdIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 8: // APPLICATION_DEPLOYMENT_ID
            if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
              struct.applicationDeploymentId = iprot.readString();
              struct.setApplicationDeploymentIdIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 9: // COMPUTE_RESOURCE_ID
            if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
              struct.computeResourceId = iprot.readString();
              struct.setComputeResourceIdIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 10: // PROCESS_INPUTS
            if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
              {
                org.apache.thrift.protocol.TList _list3 = iprot.readListBegin();
                struct.processInputs = new ArrayList<org.apache.airavata.model.application.io.InputDataObjectType>(_list3.size);
                org.apache.airavata.model.application.io.InputDataObjectType _elem4;
                for (int _i5 = 0; _i5 < _list3.size; ++_i5)
                {
                  _elem4 = new org.apache.airavata.model.application.io.InputDataObjectType();
                  _elem4.read(iprot);
                  struct.processInputs.add(_elem4);
                }
                iprot.readListEnd();
              }
              struct.setProcessInputsIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 11: // PROCESS_OUTPUTS
            if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
              {
                org.apache.thrift.protocol.TList _list6 = iprot.readListBegin();
                struct.processOutputs = new ArrayList<org.apache.airavata.model.application.io.OutputDataObjectType>(_list6.size);
                org.apache.airavata.model.application.io.OutputDataObjectType _elem7;
                for (int _i8 = 0; _i8 < _list6.size; ++_i8)
                {
                  _elem7 = new org.apache.airavata.model.application.io.OutputDataObjectType();
                  _elem7.read(iprot);
                  struct.processOutputs.add(_elem7);
                }
                iprot.readListEnd();
              }
              struct.setProcessOutputsIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 12: // PROCESS_RESOURCE_SCHEDULE
            if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
              struct.processResourceSchedule = new org.apache.airavata.model.scheduling.ComputationalResourceSchedulingModel();
              struct.processResourceSchedule.read(iprot);
              struct.setProcessResourceScheduleIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 13: // TASKS
            if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
              {
                org.apache.thrift.protocol.TList _list9 = iprot.readListBegin();
                struct.tasks = new ArrayList<org.apache.airavata.model.task.TaskModel>(_list9.size);
                org.apache.airavata.model.task.TaskModel _elem10;
                for (int _i11 = 0; _i11 < _list9.size; ++_i11)
                {
                  _elem10 = new org.apache.airavata.model.task.TaskModel();
                  _elem10.read(iprot);
                  struct.tasks.add(_elem10);
                }
                iprot.readListEnd();
              }
              struct.setTasksIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 14: // TASK_DAG
            if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
              struct.taskDag = iprot.readString();
              struct.setTaskDagIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 15: // PROCESS_ERRORS
            if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
              {
                org.apache.thrift.protocol.TList _list12 = iprot.readListBegin();
                struct.processErrors = new ArrayList<org.apache.airavata.model.commons.ErrorModel>(_list12.size);
                org.apache.airavata.model.commons.ErrorModel _elem13;
                for (int _i14 = 0; _i14 < _list12.size; ++_i14)
                {
                  _elem13 = new org.apache.airavata.model.commons.ErrorModel();
                  _elem13.read(iprot);
                  struct.processErrors.add(_elem13);
                }
                iprot.readListEnd();
              }
              struct.setProcessErrorsIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 16: // GATEWAY_EXECUTION_ID
            if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
              struct.gatewayExecutionId = iprot.readString();
              struct.setGatewayExecutionIdIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 17: // ENABLE_EMAIL_NOTIFICATION
            if (schemeField.type == org.apache.thrift.protocol.TType.BOOL) {
              struct.enableEmailNotification = iprot.readBool();
              struct.setEnableEmailNotificationIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 18: // EMAIL_ADDRESSES
            if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
              {
                org.apache.thrift.protocol.TList _list15 = iprot.readListBegin();
                struct.emailAddresses = new ArrayList<String>(_list15.size);
                String _elem16;
                for (int _i17 = 0; _i17 < _list15.size; ++_i17)
                {
                  _elem16 = iprot.readString();
                  struct.emailAddresses.add(_elem16);
                }
                iprot.readListEnd();
              }
              struct.setEmailAddressesIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 19: // STORAGE_RESOURCE_ID
            if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
              struct.storageResourceId = iprot.readString();
              struct.setStorageResourceIdIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 20: // USER_DN
            if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
              struct.userDn = iprot.readString();
              struct.setUserDnIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 21: // GENERATE_CERT
            if (schemeField.type == org.apache.thrift.protocol.TType.BOOL) {
              struct.generateCert = iprot.readBool();
              struct.setGenerateCertIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 22: // EXPERIMENT_DATA_DIR
            if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
              struct.experimentDataDir = iprot.readString();
              struct.setExperimentDataDirIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 23: // USER_NAME
            if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
              struct.userName = iprot.readString();
              struct.setUserNameIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 24: // USE_USER_CRPREF
            if (schemeField.type == org.apache.thrift.protocol.TType.BOOL) {
              struct.useUserCRPref = iprot.readBool();
              struct.setUseUserCRPrefIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
      struct.validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot, ProcessModel struct) throws org.apache.thrift.TException {
      struct.validate();

      oprot.writeStructBegin(STRUCT_DESC);
      if (struct.processId != null) {
        oprot.writeFieldBegin(PROCESS_ID_FIELD_DESC);
        oprot.writeString(struct.processId);
        oprot.writeFieldEnd();
      }
      if (struct.experimentId != null) {
        oprot.writeFieldBegin(EXPERIMENT_ID_FIELD_DESC);
        oprot.writeString(struct.experimentId);
        oprot.writeFieldEnd();
      }
      if (struct.isSetCreationTime()) {
        oprot.writeFieldBegin(CREATION_TIME_FIELD_DESC);
        oprot.writeI64(struct.creationTime);
        oprot.writeFieldEnd();
      }
      if (struct.isSetLastUpdateTime()) {
        oprot.writeFieldBegin(LAST_UPDATE_TIME_FIELD_DESC);
        oprot.writeI64(struct.lastUpdateTime);
        oprot.writeFieldEnd();
      }
      if (struct.processStatuses != null) {
        if (struct.isSetProcessStatuses()) {
          oprot.writeFieldBegin(PROCESS_STATUSES_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, struct.processStatuses.size()));
            for (org.apache.airavata.model.status.ProcessStatus _iter18 : struct.processStatuses)
            {
              _iter18.write(oprot);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
      }
      if (struct.processDetail != null) {
        if (struct.isSetProcessDetail()) {
          oprot.writeFieldBegin(PROCESS_DETAIL_FIELD_DESC);
          oprot.writeString(struct.processDetail);
          oprot.writeFieldEnd();
        }
      }
      if (struct.applicationInterfaceId != null) {
        if (struct.isSetApplicationInterfaceId()) {
          oprot.writeFieldBegin(APPLICATION_INTERFACE_ID_FIELD_DESC);
          oprot.writeString(struct.applicationInterfaceId);
          oprot.writeFieldEnd();
        }
      }
      if (struct.applicationDeploymentId != null) {
        if (struct.isSetApplicationDeploymentId()) {
          oprot.writeFieldBegin(APPLICATION_DEPLOYMENT_ID_FIELD_DESC);
          oprot.writeString(struct.applicationDeploymentId);
          oprot.writeFieldEnd();
        }
      }
      if (struct.computeResourceId != null) {
        if (struct.isSetComputeResourceId()) {
          oprot.writeFieldBegin(COMPUTE_RESOURCE_ID_FIELD_DESC);
          oprot.writeString(struct.computeResourceId);
          oprot.writeFieldEnd();
        }
      }
      if (struct.processInputs != null) {
        if (struct.isSetProcessInputs()) {
          oprot.writeFieldBegin(PROCESS_INPUTS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, struct.processInputs.size()));
            for (org.apache.airavata.model.application.io.InputDataObjectType _iter19 : struct.processInputs)
            {
              _iter19.write(oprot);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
      }
      if (struct.processOutputs != null) {
        if (struct.isSetProcessOutputs()) {
          oprot.writeFieldBegin(PROCESS_OUTPUTS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, struct.processOutputs.size()));
            for (org.apache.airavata.model.application.io.OutputDataObjectType _iter20 : struct.processOutputs)
            {
              _iter20.write(oprot);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
      }
      if (struct.processResourceSchedule != null) {
        if (struct.isSetProcessResourceSchedule()) {
          oprot.writeFieldBegin(PROCESS_RESOURCE_SCHEDULE_FIELD_DESC);
          struct.processResourceSchedule.write(oprot);
          oprot.writeFieldEnd();
        }
      }
      if (struct.tasks != null) {
        if (struct.isSetTasks()) {
          oprot.writeFieldBegin(TASKS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, struct.tasks.size()));
            for (org.apache.airavata.model.task.TaskModel _iter21 : struct.tasks)
            {
              _iter21.write(oprot);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
      }
      if (struct.taskDag != null) {
        if (struct.isSetTaskDag()) {
          oprot.writeFieldBegin(TASK_DAG_FIELD_DESC);
          oprot.writeString(struct.taskDag);
          oprot.writeFieldEnd();
        }
      }
      if (struct.processErrors != null) {
        if (struct.isSetProcessErrors()) {
          oprot.writeFieldBegin(PROCESS_ERRORS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, struct.processErrors.size()));
            for (org.apache.airavata.model.commons.ErrorModel _iter22 : struct.processErrors)
            {
              _iter22.write(oprot);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
      }
      if (struct.gatewayExecutionId != null) {
        if (struct.isSetGatewayExecutionId()) {
          oprot.writeFieldBegin(GATEWAY_EXECUTION_ID_FIELD_DESC);
          oprot.writeString(struct.gatewayExecutionId);
          oprot.writeFieldEnd();
        }
      }
      if (struct.isSetEnableEmailNotification()) {
        oprot.writeFieldBegin(ENABLE_EMAIL_NOTIFICATION_FIELD_DESC);
        oprot.writeBool(struct.enableEmailNotification);
        oprot.writeFieldEnd();
      }
      if (struct.emailAddresses != null) {
        if (struct.isSetEmailAddresses()) {
          oprot.writeFieldBegin(EMAIL_ADDRESSES_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, struct.emailAddresses.size()));
            for (String _iter23 : struct.emailAddresses)
            {
              oprot.writeString(_iter23);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
      }
      if (struct.storageResourceId != null) {
        if (struct.isSetStorageResourceId()) {
          oprot.writeFieldBegin(STORAGE_RESOURCE_ID_FIELD_DESC);
          oprot.writeString(struct.storageResourceId);
          oprot.writeFieldEnd();
        }
      }
      if (struct.userDn != null) {
        if (struct.isSetUserDn()) {
          oprot.writeFieldBegin(USER_DN_FIELD_DESC);
          oprot.writeString(struct.userDn);
          oprot.writeFieldEnd();
        }
      }
      if (struct.isSetGenerateCert()) {
        oprot.writeFieldBegin(GENERATE_CERT_FIELD_DESC);
        oprot.writeBool(struct.generateCert);
        oprot.writeFieldEnd();
      }
      if (struct.experimentDataDir != null) {
        if (struct.isSetExperimentDataDir()) {
          oprot.writeFieldBegin(EXPERIMENT_DATA_DIR_FIELD_DESC);
          oprot.writeString(struct.experimentDataDir);
          oprot.writeFieldEnd();
        }
      }
      if (struct.userName != null) {
        if (struct.isSetUserName()) {
          oprot.writeFieldBegin(USER_NAME_FIELD_DESC);
          oprot.writeString(struct.userName);
          oprot.writeFieldEnd();
        }
      }
      if (struct.isSetUseUserCRPref()) {
        oprot.writeFieldBegin(USE_USER_CRPREF_FIELD_DESC);
        oprot.writeBool(struct.useUserCRPref);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

  }

  private static class ProcessModelTupleSchemeFactory implements SchemeFactory {
    public ProcessModelTupleScheme getScheme() {
      return new ProcessModelTupleScheme();
    }
  }

  private static class ProcessModelTupleScheme extends TupleScheme<ProcessModel> {

    @Override
    public void write(org.apache.thrift.protocol.TProtocol prot, ProcessModel struct) throws org.apache.thrift.TException {
      TTupleProtocol oprot = (TTupleProtocol) prot;
      oprot.writeString(struct.processId);
      oprot.writeString(struct.experimentId);
      BitSet optionals = new BitSet();
      if (struct.isSetCreationTime()) {
        optionals.set(0);
      }
      if (struct.isSetLastUpdateTime()) {
        optionals.set(1);
      }
      if (struct.isSetProcessStatuses()) {
        optionals.set(2);
      }
      if (struct.isSetProcessDetail()) {
        optionals.set(3);
      }
      if (struct.isSetApplicationInterfaceId()) {
        optionals.set(4);
      }
      if (struct.isSetApplicationDeploymentId()) {
        optionals.set(5);
      }
      if (struct.isSetComputeResourceId()) {
        optionals.set(6);
      }
      if (struct.isSetProcessInputs()) {
        optionals.set(7);
      }
      if (struct.isSetProcessOutputs()) {
        optionals.set(8);
      }
      if (struct.isSetProcessResourceSchedule()) {
        optionals.set(9);
      }
      if (struct.isSetTasks()) {
        optionals.set(10);
      }
      if (struct.isSetTaskDag()) {
        optionals.set(11);
      }
      if (struct.isSetProcessErrors()) {
        optionals.set(12);
      }
      if (struct.isSetGatewayExecutionId()) {
        optionals.set(13);
      }
      if (struct.isSetEnableEmailNotification()) {
        optionals.set(14);
      }
      if (struct.isSetEmailAddresses()) {
        optionals.set(15);
      }
      if (struct.isSetStorageResourceId()) {
        optionals.set(16);
      }
      if (struct.isSetUserDn()) {
        optionals.set(17);
      }
      if (struct.isSetGenerateCert()) {
        optionals.set(18);
      }
      if (struct.isSetExperimentDataDir()) {
        optionals.set(19);
      }
      if (struct.isSetUserName()) {
        optionals.set(20);
      }
      if (struct.isSetUseUserCRPref()) {
        optionals.set(21);
      }
      oprot.writeBitSet(optionals, 22);
      if (struct.isSetCreationTime()) {
        oprot.writeI64(struct.creationTime);
      }
      if (struct.isSetLastUpdateTime()) {
        oprot.writeI64(struct.lastUpdateTime);
      }
      if (struct.isSetProcessStatuses()) {
        {
          oprot.writeI32(struct.processStatuses.size());
          for (org.apache.airavata.model.status.ProcessStatus _iter24 : struct.processStatuses)
          {
            _iter24.write(oprot);
          }
        }
      }
      if (struct.isSetProcessDetail()) {
        oprot.writeString(struct.processDetail);
      }
      if (struct.isSetApplicationInterfaceId()) {
        oprot.writeString(struct.applicationInterfaceId);
      }
      if (struct.isSetApplicationDeploymentId()) {
        oprot.writeString(struct.applicationDeploymentId);
      }
      if (struct.isSetComputeResourceId()) {
        oprot.writeString(struct.computeResourceId);
      }
      if (struct.isSetProcessInputs()) {
        {
          oprot.writeI32(struct.processInputs.size());
          for (org.apache.airavata.model.application.io.InputDataObjectType _iter25 : struct.processInputs)
          {
            _iter25.write(oprot);
          }
        }
      }
      if (struct.isSetProcessOutputs()) {
        {
          oprot.writeI32(struct.processOutputs.size());
          for (org.apache.airavata.model.application.io.OutputDataObjectType _iter26 : struct.processOutputs)
          {
            _iter26.write(oprot);
          }
        }
      }
      if (struct.isSetProcessResourceSchedule()) {
        struct.processResourceSchedule.write(oprot);
      }
      if (struct.isSetTasks()) {
        {
          oprot.writeI32(struct.tasks.size());
          for (org.apache.airavata.model.task.TaskModel _iter27 : struct.tasks)
          {
            _iter27.write(oprot);
          }
        }
      }
      if (struct.isSetTaskDag()) {
        oprot.writeString(struct.taskDag);
      }
      if (struct.isSetProcessErrors()) {
        {
          oprot.writeI32(struct.processErrors.size());
          for (org.apache.airavata.model.commons.ErrorModel _iter28 : struct.processErrors)
          {
            _iter28.write(oprot);
          }
        }
      }
      if (struct.isSetGatewayExecutionId()) {
        oprot.writeString(struct.gatewayExecutionId);
      }
      if (struct.isSetEnableEmailNotification()) {
        oprot.writeBool(struct.enableEmailNotification);
      }
      if (struct.isSetEmailAddresses()) {
        {
          oprot.writeI32(struct.emailAddresses.size());
          for (String _iter29 : struct.emailAddresses)
          {
            oprot.writeString(_iter29);
          }
        }
      }
      if (struct.isSetStorageResourceId()) {
        oprot.writeString(struct.storageResourceId);
      }
      if (struct.isSetUserDn()) {
        oprot.writeString(struct.userDn);
      }
      if (struct.isSetGenerateCert()) {
        oprot.writeBool(struct.generateCert);
      }
      if (struct.isSetExperimentDataDir()) {
        oprot.writeString(struct.experimentDataDir);
      }
      if (struct.isSetUserName()) {
        oprot.writeString(struct.userName);
      }
      if (struct.isSetUseUserCRPref()) {
        oprot.writeBool(struct.useUserCRPref);
      }
    }

    @Override
    public void read(org.apache.thrift.protocol.TProtocol prot, ProcessModel struct) throws org.apache.thrift.TException {
      TTupleProtocol iprot = (TTupleProtocol) prot;
      struct.processId = iprot.readString();
      struct.setProcessIdIsSet(true);
      struct.experimentId = iprot.readString();
      struct.setExperimentIdIsSet(true);
      BitSet incoming = iprot.readBitSet(22);
      if (incoming.get(0)) {
        struct.creationTime = iprot.readI64();
        struct.setCreationTimeIsSet(true);
      }
      if (incoming.get(1)) {
        struct.lastUpdateTime = iprot.readI64();
        struct.setLastUpdateTimeIsSet(true);
      }
      if (incoming.get(2)) {
        {
          org.apache.thrift.protocol.TList _list30 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, iprot.readI32());
          struct.processStatuses = new ArrayList<org.apache.airavata.model.status.ProcessStatus>(_list30.size);
          org.apache.airavata.model.status.ProcessStatus _elem31;
          for (int _i32 = 0; _i32 < _list30.size; ++_i32)
          {
            _elem31 = new org.apache.airavata.model.status.ProcessStatus();
            _elem31.read(iprot);
            struct.processStatuses.add(_elem31);
          }
        }
        struct.setProcessStatusesIsSet(true);
      }
      if (incoming.get(3)) {
        struct.processDetail = iprot.readString();
        struct.setProcessDetailIsSet(true);
      }
      if (incoming.get(4)) {
        struct.applicationInterfaceId = iprot.readString();
        struct.setApplicationInterfaceIdIsSet(true);
      }
      if (incoming.get(5)) {
        struct.applicationDeploymentId = iprot.readString();
        struct.setApplicationDeploymentIdIsSet(true);
      }
      if (incoming.get(6)) {
        struct.computeResourceId = iprot.readString();
        struct.setComputeResourceIdIsSet(true);
      }
      if (incoming.get(7)) {
        {
          org.apache.thrift.protocol.TList _list33 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, iprot.readI32());
          struct.processInputs = new ArrayList<org.apache.airavata.model.application.io.InputDataObjectType>(_list33.size);
          org.apache.airavata.model.application.io.InputDataObjectType _elem34;
          for (int _i35 = 0; _i35 < _list33.size; ++_i35)
          {
            _elem34 = new org.apache.airavata.model.application.io.InputDataObjectType();
            _elem34.read(iprot);
            struct.processInputs.add(_elem34);
          }
        }
        struct.setProcessInputsIsSet(true);
      }
      if (incoming.get(8)) {
        {
          org.apache.thrift.protocol.TList _list36 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, iprot.readI32());
          struct.processOutputs = new ArrayList<org.apache.airavata.model.application.io.OutputDataObjectType>(_list36.size);
          org.apache.airavata.model.application.io.OutputDataObjectType _elem37;
          for (int _i38 = 0; _i38 < _list36.size; ++_i38)
          {
            _elem37 = new org.apache.airavata.model.application.io.OutputDataObjectType();
            _elem37.read(iprot);
            struct.processOutputs.add(_elem37);
          }
        }
        struct.setProcessOutputsIsSet(true);
      }
      if (incoming.get(9)) {
        struct.processResourceSchedule = new org.apache.airavata.model.scheduling.ComputationalResourceSchedulingModel();
        struct.processResourceSchedule.read(iprot);
        struct.setProcessResourceScheduleIsSet(true);
      }
      if (incoming.get(10)) {
        {
          org.apache.thrift.protocol.TList _list39 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, iprot.readI32());
          struct.tasks = new ArrayList<org.apache.airavata.model.task.TaskModel>(_list39.size);
          org.apache.airavata.model.task.TaskModel _elem40;
          for (int _i41 = 0; _i41 < _list39.size; ++_i41)
          {
            _elem40 = new org.apache.airavata.model.task.TaskModel();
            _elem40.read(iprot);
            struct.tasks.add(_elem40);
          }
        }
        struct.setTasksIsSet(true);
      }
      if (incoming.get(11)) {
        struct.taskDag = iprot.readString();
        struct.setTaskDagIsSet(true);
      }
      if (incoming.get(12)) {
        {
          org.apache.thrift.protocol.TList _list42 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, iprot.readI32());
          struct.processErrors = new ArrayList<org.apache.airavata.model.commons.ErrorModel>(_list42.size);
          org.apache.airavata.model.commons.ErrorModel _elem43;
          for (int _i44 = 0; _i44 < _list42.size; ++_i44)
          {
            _elem43 = new org.apache.airavata.model.commons.ErrorModel();
            _elem43.read(iprot);
            struct.processErrors.add(_elem43);
          }
        }
        struct.setProcessErrorsIsSet(true);
      }
      if (incoming.get(13)) {
        struct.gatewayExecutionId = iprot.readString();
        struct.setGatewayExecutionIdIsSet(true);
      }
      if (incoming.get(14)) {
        struct.enableEmailNotification = iprot.readBool();
        struct.setEnableEmailNotificationIsSet(true);
      }
      if (incoming.get(15)) {
        {
          org.apache.thrift.protocol.TList _list45 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, iprot.readI32());
          struct.emailAddresses = new ArrayList<String>(_list45.size);
          String _elem46;
          for (int _i47 = 0; _i47 < _list45.size; ++_i47)
          {
            _elem46 = iprot.readString();
            struct.emailAddresses.add(_elem46);
          }
        }
        struct.setEmailAddressesIsSet(true);
      }
      if (incoming.get(16)) {
        struct.storageResourceId = iprot.readString();
        struct.setStorageResourceIdIsSet(true);
      }
      if (incoming.get(17)) {
        struct.userDn = iprot.readString();
        struct.setUserDnIsSet(true);
      }
      if (incoming.get(18)) {
        struct.generateCert = iprot.readBool();
        struct.setGenerateCertIsSet(true);
      }
      if (incoming.get(19)) {
        struct.experimentDataDir = iprot.readString();
        struct.setExperimentDataDirIsSet(true);
      }
      if (incoming.get(20)) {
        struct.userName = iprot.readString();
        struct.setUserNameIsSet(true);
      }
      if (incoming.get(21)) {
        struct.useUserCRPref = iprot.readBool();
        struct.setUseUserCRPrefIsSet(true);
      }
    }
  }

}

