/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.connection.channel;

import java.io.IOException;
import java.io.OutputStream;
import net.schmizz.sshj.common.ErrorNotifiable;
import net.schmizz.sshj.common.Message;
import net.schmizz.sshj.common.SSHException;
import net.schmizz.sshj.common.SSHPacket;
import net.schmizz.sshj.connection.ConnectionException;
import net.schmizz.sshj.connection.channel.Channel;
import net.schmizz.sshj.connection.channel.Window;
import net.schmizz.sshj.transport.Transport;

public final class ChannelOutputStream
extends OutputStream
implements ErrorNotifiable {
    private final Channel chan;
    private final Transport trans;
    private final Window.Remote win;
    private final SSHPacket buffer = new SSHPacket();
    private final byte[] b = new byte[1];
    private int bufferLength;
    private boolean closed;
    private SSHException error;

    public ChannelOutputStream(Channel chan, Transport trans, Window.Remote win) {
        this.chan = chan;
        this.trans = trans;
        this.win = win;
        this.prepBuffer();
    }

    private void prepBuffer() {
        this.bufferLength = 0;
        this.buffer.rpos(5);
        this.buffer.wpos(5);
        this.buffer.putMessageID(Message.CHANNEL_DATA);
        this.buffer.putUInt32(0L);
        this.buffer.putUInt32(0L);
    }

    @Override
    public synchronized void write(int w) throws IOException {
        this.b[0] = (byte)w;
        this.write(this.b, 0, 1);
    }

    @Override
    public synchronized void write(byte[] data, int off, int len) throws IOException {
        this.checkClose();
        while (len > 0) {
            int x = Math.min(len, this.win.getMaxPacketSize() - this.bufferLength);
            if (x <= 0) {
                this.flush();
                continue;
            }
            this.buffer.putRawBytes(data, off, x);
            this.bufferLength += x;
            off += x;
            len -= x;
        }
    }

    @Override
    public synchronized void notifyError(SSHException error) {
        this.error = error;
    }

    private synchronized void checkClose() throws SSHException {
        if (this.closed) {
            if (this.error != null) {
                throw this.error;
            }
            throw new ConnectionException("Stream closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        if (!this.closed) {
            try {
                this.flush();
                this.chan.sendEOF();
            }
            finally {
                this.setClosed();
            }
        }
    }

    public synchronized void setClosed() {
        this.closed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void flush() throws IOException {
        this.checkClose();
        if (this.bufferLength <= 0) {
            return;
        }
        this.putRecipientAndLength();
        try {
            this.win.waitAndConsume(this.bufferLength);
            this.trans.write(this.buffer);
        }
        finally {
            this.prepBuffer();
        }
    }

    private void putRecipientAndLength() {
        int origPos = this.buffer.wpos();
        this.buffer.wpos(6);
        this.buffer.putUInt32(this.chan.getRecipient());
        this.buffer.putUInt32(this.bufferLength);
        this.buffer.wpos(origPos);
    }

    public String toString() {
        return "< ChannelOutputStream for Channel #" + this.chan.getID() + " >";
    }
}

