/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.blip;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import javax.imageio.ImageIO;
import org.apache.poi.hslf.blip.ImagePainter;
import org.apache.poi.hslf.model.Picture;
import org.apache.poi.hslf.usermodel.PictureData;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public final class BitmapPainter
implements ImagePainter {
    protected POILogger logger = POILogFactory.getLogger(this.getClass());

    public void paint(Graphics2D graphics, PictureData pict, Picture parent) {
        BufferedImage img;
        try {
            img = ImageIO.read(new ByteArrayInputStream(pict.getData()));
        }
        catch (Exception e) {
            this.logger.log(5, "ImageIO failed to create image. image.type: " + pict.getType());
            return;
        }
        Rectangle anchor = parent.getLogicalAnchor2D().getBounds();
        graphics.drawImage(img, anchor.x, anchor.y, anchor.width, anchor.height, null);
    }
}

