/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.app.catalog.resources;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.registry.core.app.catalog.model.ComputeResource;
import org.apache.airavata.registry.core.app.catalog.model.ComputeResourcePreference;
import org.apache.airavata.registry.core.app.catalog.model.ComputeResourcePreferencePK;
import org.apache.airavata.registry.core.app.catalog.model.GatewayProfile;
import org.apache.airavata.registry.core.app.catalog.model.SSHAccountProvisionerConfiguration;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatAbstractResource;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatalogResource;
import org.apache.airavata.registry.core.app.catalog.resources.ComputeResourceResource;
import org.apache.airavata.registry.core.app.catalog.resources.GatewayProfileResource;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogJPAUtils;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogQueryGenerator;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogResourceType;
import org.apache.airavata.registry.cpi.AppCatalogException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputeHostPreferenceResource
extends AppCatAbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(ComputeHostPreferenceResource.class);
    private String gatewayId;
    private String resourceId;
    private boolean overrideByAiravata;
    private String preferredJobProtocol;
    private String preferedDMProtocol;
    private String batchQueue;
    private String scratchLocation;
    private String projectNumber;
    private String loginUserName;
    private String resourceCSToken;
    private String usageReportingGatewayId;
    private String qualityOfService;
    private String reservation;
    private Timestamp reservationStartTime;
    private Timestamp reservationEndTime;
    private String sshAccountProvisioner;
    private Map<String, String> sshAccountProvisionerConfigurations;
    private String sshAccountProvisionerAdditionalInfo;
    private GatewayProfileResource gatewayProfile;
    private ComputeResourceResource computeHostResource;

    public String getLoginUserName() {
        return this.loginUserName;
    }

    public void setLoginUserName(String loginUserName) {
        this.loginUserName = loginUserName;
    }

    public String getGatewayId() {
        return this.gatewayId;
    }

    public void setGatewayId(String gatewayId) {
        this.gatewayId = gatewayId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public boolean getOverrideByAiravata() {
        return this.overrideByAiravata;
    }

    public void setOverrideByAiravata(boolean overrideByAiravata) {
        this.overrideByAiravata = overrideByAiravata;
    }

    public String getPreferredJobProtocol() {
        return this.preferredJobProtocol;
    }

    public void setPreferredJobProtocol(String preferredJobProtocol) {
        this.preferredJobProtocol = preferredJobProtocol;
    }

    public String getPreferedDMProtocol() {
        return this.preferedDMProtocol;
    }

    public void setPreferedDMProtocol(String preferedDMProtocol) {
        this.preferedDMProtocol = preferedDMProtocol;
    }

    public String getBatchQueue() {
        return this.batchQueue;
    }

    public void setBatchQueue(String batchQueue) {
        this.batchQueue = batchQueue;
    }

    public String getScratchLocation() {
        return this.scratchLocation;
    }

    public void setScratchLocation(String scratchLocation) {
        this.scratchLocation = scratchLocation;
    }

    public String getProjectNumber() {
        return this.projectNumber;
    }

    public void setProjectNumber(String projectNumber) {
        this.projectNumber = projectNumber;
    }

    public GatewayProfileResource getGatewayProfile() {
        return this.gatewayProfile;
    }

    public void setGatewayProfile(GatewayProfileResource gatewayProfile) {
        this.gatewayProfile = gatewayProfile;
    }

    public void setUserResourceProfile(GatewayProfileResource gatewayProfile) {
        this.gatewayProfile = gatewayProfile;
    }

    public ComputeResourceResource getComputeHostResource() {
        return this.computeHostResource;
    }

    public void setComputeHostResource(ComputeResourceResource computeHostResource) {
        this.computeHostResource = computeHostResource;
    }

    public String getResourceCSToken() {
        return this.resourceCSToken;
    }

    public void setResourceCSToken(String resourceCSToken) {
        this.resourceCSToken = resourceCSToken;
    }

    public String getUsageReportingGatewayId() {
        return this.usageReportingGatewayId;
    }

    public void setUsageReportingGatewayId(String usageReportingGatewayId) {
        this.usageReportingGatewayId = usageReportingGatewayId;
    }

    public String getQualityOfService() {
        return this.qualityOfService;
    }

    public void setQualityOfService(String qualityOfService) {
        this.qualityOfService = qualityOfService;
    }

    public String getReservation() {
        return this.reservation;
    }

    public void setReservation(String reservation) {
        this.reservation = reservation;
    }

    public Timestamp getReservationStartTime() {
        return this.reservationStartTime;
    }

    public void setReservationStartTime(Timestamp reservationStartTime) {
        this.reservationStartTime = reservationStartTime;
    }

    public Timestamp getReservationEndTime() {
        return this.reservationEndTime;
    }

    public void setReservationEndTime(Timestamp reservationEndTime) {
        this.reservationEndTime = reservationEndTime;
    }

    public String getSshAccountProvisioner() {
        return this.sshAccountProvisioner;
    }

    public void setSshAccountProvisioner(String sshAccountProvisioner) {
        this.sshAccountProvisioner = sshAccountProvisioner;
    }

    public Map<String, String> getSshAccountProvisionerConfigurations() {
        return this.sshAccountProvisionerConfigurations;
    }

    public void setSshAccountProvisionerConfigurations(Map<String, String> sshAccountProvisionerConfigurations) {
        this.sshAccountProvisionerConfigurations = sshAccountProvisionerConfigurations;
    }

    public String getSshAccountProvisionerAdditionalInfo() {
        return this.sshAccountProvisionerAdditionalInfo;
    }

    public void setSshAccountProvisionerAdditionalInfo(String sshAccountProvisionerAdditionalInfo) {
        this.sshAccountProvisionerAdditionalInfo = sshAccountProvisionerAdditionalInfo;
    }

    @Override
    public void remove(Object identifier) throws AppCatalogException {
        if (!(identifier instanceof Map)) {
            logger.error("Identifier should be a map with the field name and it's value");
            throw new AppCatalogException("Identifier should be a map with the field name and it's value");
        }
        HashMap ids = (HashMap)identifier;
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("ComputeResourcePreference", new Object[0][]);
            generator.setParameter("resourceId", ids.get("resourceId"));
            generator.setParameter("gatewayId", ids.get("gatewayId"));
            Query q = generator.deleteQuery(em);
            q.executeUpdate();
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public AppCatalogResource get(Object identifier) throws AppCatalogException {
        if (!(identifier instanceof Map)) {
            logger.error("Identifier should be a map with the field name and it's value");
            throw new AppCatalogException("Identifier should be a map with the field name and it's value");
        }
        HashMap ids = (HashMap)identifier;
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("ComputeResourcePreference", new Object[0][]);
            generator.setParameter("gatewayId", ids.get("gatewayId"));
            generator.setParameter("resourceId", ids.get("resourceId"));
            Query q = generator.selectQuery(em);
            ComputeResourcePreference preference = (ComputeResourcePreference)q.getSingleResult();
            ComputeHostPreferenceResource preferenceResource = (ComputeHostPreferenceResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.COMPUTE_RESOURCE_PREFERENCE, preference);
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            ComputeHostPreferenceResource computeHostPreferenceResource = preferenceResource;
            return computeHostPreferenceResource;
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public List<AppCatalogResource> get(String fieldName, Object value) throws AppCatalogException {
        ArrayList<AppCatalogResource> preferenceResourceList = new ArrayList<AppCatalogResource>();
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("ComputeResourcePreference", new Object[0][]);
            if (fieldName.equals("resourceId")) {
                generator.setParameter("resourceId", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        ComputeResourcePreference preference = (ComputeResourcePreference)result;
                        if (preference.getComputeHostResource() == null) continue;
                        ComputeHostPreferenceResource preferenceResource = (ComputeHostPreferenceResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.COMPUTE_RESOURCE_PREFERENCE, preference);
                        preferenceResourceList.add(preferenceResource);
                    }
                }
            } else if (fieldName.equals("gatewayId")) {
                generator.setParameter("gatewayId", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        ComputeResourcePreference preference = (ComputeResourcePreference)result;
                        if (preference.getComputeHostResource() == null) continue;
                        ComputeHostPreferenceResource preferenceResource = (ComputeHostPreferenceResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.COMPUTE_RESOURCE_PREFERENCE, preference);
                        preferenceResourceList.add(preferenceResource);
                    }
                }
            } else if (fieldName.equals("preferedJobSubmissionProtocol")) {
                generator.setParameter("preferedJobSubmissionProtocol", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        ComputeResourcePreference preference = (ComputeResourcePreference)result;
                        if (preference.getComputeHostResource() == null) continue;
                        ComputeHostPreferenceResource preferenceResource = (ComputeHostPreferenceResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.COMPUTE_RESOURCE_PREFERENCE, preference);
                        preferenceResourceList.add(preferenceResource);
                    }
                }
            } else if (fieldName.equals("preferedDataMoveProtocol")) {
                generator.setParameter("preferedDataMoveProtocol", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        ComputeResourcePreference preference = (ComputeResourcePreference)result;
                        if (preference.getResourceId() == null) continue;
                        ComputeHostPreferenceResource preferenceResource = (ComputeHostPreferenceResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.COMPUTE_RESOURCE_PREFERENCE, preference);
                        preferenceResourceList.add(preferenceResource);
                    }
                }
            } else {
                em.getTransaction().commit();
                if (em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
                logger.error("Unsupported field name for Compute host preference Resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported field name for Compute host preference Resource.");
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return preferenceResourceList;
    }

    @Override
    public List<AppCatalogResource> getAll() throws AppCatalogException {
        return null;
    }

    @Override
    public List<String> getAllIds() throws AppCatalogException {
        return null;
    }

    @Override
    public List<String> getIds(String fieldName, Object value) throws AppCatalogException {
        logger.error("Unsupported for objects with a composite identifier");
        throw new AppCatalogException("Unsupported for objects with a composite identifier");
    }

    @Override
    public void save() throws AppCatalogException {
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            ComputeResourcePreference existingPreference = (ComputeResourcePreference)em.find(ComputeResourcePreference.class, (Object)new ComputeResourcePreferencePK(this.gatewayId, this.resourceId));
            em.getTransaction().begin();
            ComputeResource computeResource = (ComputeResource)em.find(ComputeResource.class, (Object)this.resourceId);
            GatewayProfile gatewayProf = (GatewayProfile)em.find(GatewayProfile.class, (Object)this.gatewayId);
            if (existingPreference != null) {
                existingPreference.setResourceId(this.resourceId);
                existingPreference.setGatewayId(this.gatewayId);
                existingPreference.setComputeHostResource(computeResource);
                existingPreference.setGatewayProfile(gatewayProf);
                existingPreference.setOverrideByAiravata(this.overrideByAiravata);
                existingPreference.setPreferedJobSubmissionProtocol(this.preferredJobProtocol);
                existingPreference.setPreferedDataMoveProtocol(this.preferedDMProtocol);
                existingPreference.setScratchLocation(this.scratchLocation);
                existingPreference.setProjectNumber(this.projectNumber);
                existingPreference.setBatchQueue(this.batchQueue);
                existingPreference.setLoginUserName(this.loginUserName);
                existingPreference.setComputeResourceCSToken(this.resourceCSToken);
                existingPreference.setUsageReportingGWId(this.usageReportingGatewayId);
                existingPreference.setQualityOfService(this.qualityOfService);
                existingPreference.setReservation(this.reservation);
                existingPreference.setReservationStartTime(this.reservationStartTime);
                existingPreference.setReservationEndTime(this.reservationEndTime);
                existingPreference.setSshAccountProvisioner(this.sshAccountProvisioner);
                if (this.sshAccountProvisionerConfigurations != null && !this.sshAccountProvisionerConfigurations.isEmpty()) {
                    ArrayList<SSHAccountProvisionerConfiguration> configurations = new ArrayList<SSHAccountProvisionerConfiguration>();
                    for (String sshAccountProvisionerConfigName : this.sshAccountProvisionerConfigurations.keySet()) {
                        String value = this.sshAccountProvisionerConfigurations.get(sshAccountProvisionerConfigName);
                        configurations.add(new SSHAccountProvisionerConfiguration(sshAccountProvisionerConfigName, value, existingPreference));
                    }
                    existingPreference.setSshAccountProvisionerConfigurations(configurations);
                } else {
                    existingPreference.setSshAccountProvisionerConfigurations(null);
                }
                existingPreference.setSshAccountProvisionerAdditionalInfo(this.sshAccountProvisionerAdditionalInfo);
                em.merge((Object)existingPreference);
            } else {
                ComputeResourcePreference resourcePreference = new ComputeResourcePreference();
                resourcePreference.setResourceId(this.resourceId);
                resourcePreference.setGatewayId(this.gatewayId);
                resourcePreference.setComputeHostResource(computeResource);
                resourcePreference.setGatewayProfile(gatewayProf);
                resourcePreference.setOverrideByAiravata(this.overrideByAiravata);
                resourcePreference.setPreferedJobSubmissionProtocol(this.preferredJobProtocol);
                resourcePreference.setPreferedDataMoveProtocol(this.preferedDMProtocol);
                resourcePreference.setScratchLocation(this.scratchLocation);
                resourcePreference.setProjectNumber(this.projectNumber);
                resourcePreference.setBatchQueue(this.batchQueue);
                resourcePreference.setLoginUserName(this.loginUserName);
                resourcePreference.setComputeResourceCSToken(this.resourceCSToken);
                resourcePreference.setUsageReportingGWId(this.usageReportingGatewayId);
                resourcePreference.setQualityOfService(this.qualityOfService);
                resourcePreference.setReservation(this.reservation);
                resourcePreference.setReservationStartTime(this.reservationStartTime);
                resourcePreference.setReservationEndTime(this.reservationEndTime);
                resourcePreference.setSshAccountProvisioner(this.sshAccountProvisioner);
                if (this.sshAccountProvisionerConfigurations != null && !this.sshAccountProvisionerConfigurations.isEmpty()) {
                    ArrayList<SSHAccountProvisionerConfiguration> configurations = new ArrayList<SSHAccountProvisionerConfiguration>();
                    for (String sshAccountProvisionerConfigName : this.sshAccountProvisionerConfigurations.keySet()) {
                        String value = this.sshAccountProvisionerConfigurations.get(sshAccountProvisionerConfigName);
                        configurations.add(new SSHAccountProvisionerConfiguration(sshAccountProvisionerConfigName, value, resourcePreference));
                    }
                    resourcePreference.setSshAccountProvisionerConfigurations(configurations);
                }
                resourcePreference.setSshAccountProvisionerAdditionalInfo(this.sshAccountProvisionerAdditionalInfo);
                em.persist((Object)resourcePreference);
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public boolean isExists(Object identifier) throws AppCatalogException {
        if (!(identifier instanceof Map)) {
            logger.error("Identifier should be a map with the field name and it's value");
            throw new AppCatalogException("Identifier should be a map with the field name and it's value");
        }
        HashMap ids = (HashMap)identifier;
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            ComputeResourcePreference existingPreference = (ComputeResourcePreference)em.find(ComputeResourcePreference.class, (Object)new ComputeResourcePreferencePK((String)ids.get("gatewayId"), (String)ids.get("resourceId")));
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            boolean bl = existingPreference != null;
            return bl;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }
}

