/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.app.catalog.resources;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.registry.core.app.catalog.model.GSISSHExport;
import org.apache.airavata.registry.core.app.catalog.model.GSISSHExportPK;
import org.apache.airavata.registry.core.app.catalog.model.GSISSHSubmission;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatAbstractResource;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatalogResource;
import org.apache.airavata.registry.core.app.catalog.resources.GSISSHSubmissionResource;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogJPAUtils;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogQueryGenerator;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogResourceType;
import org.apache.airavata.registry.cpi.AppCatalogException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GSISSHExportResource
extends AppCatAbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(GSISSHExportResource.class);
    private String submissionID;
    private String export;
    private GSISSHSubmissionResource gsisshSubmissionResource;

    @Override
    public void remove(Object identifier) throws AppCatalogException {
        if (!(identifier instanceof Map)) {
            logger.error("Identifier should be a map with the field name and it's value");
            throw new AppCatalogException("Identifier should be a map with the field name and it's value");
        }
        HashMap ids = (HashMap)identifier;
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("GSISSHExport", new Object[0][]);
            generator.setParameter("export", ids.get("export"));
            generator.setParameter("submissionID", ids.get("submissionID"));
            Query q = generator.deleteQuery(em);
            q.executeUpdate();
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public AppCatalogResource get(Object identifier) throws AppCatalogException {
        if (!(identifier instanceof Map)) {
            logger.error("Identifier should be a map with the field name and it's value");
            throw new AppCatalogException("Identifier should be a map with the field name and it's value");
        }
        HashMap ids = (HashMap)identifier;
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("GSISSHExport", new Object[0][]);
            generator.setParameter("submissionID", ids.get("submissionID"));
            generator.setParameter("export", ids.get("export"));
            Query q = generator.selectQuery(em);
            GSISSHExport gsisshExport = (GSISSHExport)q.getSingleResult();
            GSISSHExportResource gsisshExportResource = (GSISSHExportResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.GSISSH_EXPORT, gsisshExport);
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            GSISSHExportResource gSISSHExportResource = gsisshExportResource;
            return gSISSHExportResource;
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public List<AppCatalogResource> get(String fieldName, Object value) throws AppCatalogException {
        ArrayList<AppCatalogResource> gsiSSHExportResources = new ArrayList<AppCatalogResource>();
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("GSISSHExport", new Object[0][]);
            if (fieldName.equals("export")) {
                generator.setParameter("export", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        GSISSHExport gsisshExport = (GSISSHExport)result;
                        GSISSHExportResource gsisshExportResource = (GSISSHExportResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.GSISSH_EXPORT, gsisshExport);
                        gsiSSHExportResources.add(gsisshExportResource);
                    }
                }
            } else if (fieldName.equals("submissionID")) {
                generator.setParameter("submissionID", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        GSISSHExport gsisshExport = (GSISSHExport)result;
                        GSISSHExportResource gsisshExportResource = (GSISSHExportResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.GSISSH_EXPORT, gsisshExport);
                        gsiSSHExportResources.add(gsisshExportResource);
                    }
                }
            } else {
                em.getTransaction().commit();
                if (em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
                logger.error("Unsupported field name for GSISSH Export Resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported field name for GSISSH Export Resource.");
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return gsiSSHExportResources;
    }

    @Override
    public List<AppCatalogResource> getAll() throws AppCatalogException {
        return null;
    }

    @Override
    public List<String> getAllIds() throws AppCatalogException {
        return null;
    }

    @Override
    public List<String> getIds(String fieldName, Object value) throws AppCatalogException {
        ArrayList<String> gsiSSHExportIDs = new ArrayList<String>();
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("GSISSHExport", new Object[0][]);
            if (fieldName.equals("submissionID")) {
                generator.setParameter("submissionID", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        GSISSHExport gsisshExport = (GSISSHExport)result;
                        gsiSSHExportIDs.add(gsisshExport.getSubmissionID());
                    }
                }
            } else if (fieldName.equals("export")) {
                generator.setParameter("export", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        GSISSHExport gsisshExport = (GSISSHExport)result;
                        gsiSSHExportIDs.add(gsisshExport.getSubmissionID());
                    }
                }
            } else {
                em.getTransaction().commit();
                if (em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
                logger.error("Unsupported field name for GSISSH Export resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported field name for GSISSH Export Resource.");
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return gsiSSHExportIDs;
    }

    @Override
    public void save() throws AppCatalogException {
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            GSISSHExport existingGSIExport = (GSISSHExport)em.find(GSISSHExport.class, (Object)new GSISSHExportPK(this.submissionID, this.export));
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            GSISSHSubmission gsisshSubmission = (GSISSHSubmission)em.find(GSISSHSubmission.class, (Object)this.submissionID);
            if (existingGSIExport != null) {
                existingGSIExport.setSubmissionID(this.submissionID);
                existingGSIExport.setExport(this.export);
                existingGSIExport.setGsisshJobSubmission(gsisshSubmission);
                em.merge((Object)existingGSIExport);
            } else {
                GSISSHExport gsisshExport = new GSISSHExport();
                gsisshExport.setSubmissionID(this.submissionID);
                gsisshExport.setExport(this.export);
                gsisshExport.setGsisshJobSubmission(gsisshSubmission);
                em.persist((Object)gsisshExport);
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public boolean isExists(Object identifier) throws AppCatalogException {
        if (!(identifier instanceof Map)) {
            logger.error("Identifier should be a map with the field name and it's value");
            throw new AppCatalogException("Identifier should be a map with the field name and it's value");
        }
        HashMap ids = (HashMap)identifier;
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            GSISSHExport gsisshExport = (GSISSHExport)em.find(GSISSHExport.class, (Object)new GSISSHExportPK((String)ids.get("submissionID"), (String)ids.get("export")));
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            boolean bl = gsisshExport != null;
            return bl;
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    public String getSubmissionID() {
        return this.submissionID;
    }

    public void setSubmissionID(String submissionID) {
        this.submissionID = submissionID;
    }

    public String getExport() {
        return this.export;
    }

    public void setExport(String export) {
        this.export = export;
    }

    public GSISSHSubmissionResource getGsisshSubmissionResource() {
        return this.gsisshSubmissionResource;
    }

    public void setGsisshSubmissionResource(GSISSHSubmissionResource gsisshSubmissionResource) {
        this.gsisshSubmissionResource = gsisshSubmissionResource;
    }
}

