/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.app.catalog.resources;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.AiravataUtils;
import org.apache.airavata.registry.core.app.catalog.model.ResourceJobManager;
import org.apache.airavata.registry.core.app.catalog.model.SshJobSubmission;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatAbstractResource;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatalogResource;
import org.apache.airavata.registry.core.app.catalog.resources.ResourceJobManagerResource;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogJPAUtils;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogQueryGenerator;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogResourceType;
import org.apache.airavata.registry.cpi.AppCatalogException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshJobSubmissionResource
extends AppCatAbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(SshJobSubmissionResource.class);
    private String resourceJobManagerId;
    private ResourceJobManagerResource resourceJobManagerResource;
    private String jobSubmissionInterfaceId;
    private String alternativeSshHostname;
    private String securityProtocol;
    private int sshPort;
    private String monitorMode;
    private Timestamp createdTime;
    private Timestamp updatedTime;

    public Timestamp getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(Timestamp createdTime) {
        this.createdTime = createdTime;
    }

    public Timestamp getUpdatedTime() {
        return this.updatedTime;
    }

    public void setUpdatedTime(Timestamp updatedTime) {
        this.updatedTime = updatedTime;
    }

    @Override
    public void remove(Object identifier) throws AppCatalogException {
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("SshJobSubmission", new Object[0][]);
            generator.setParameter("jobSubmissionInterfaceId", identifier);
            Query q = generator.deleteQuery(em);
            q.executeUpdate();
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public AppCatalogResource get(Object identifier) throws AppCatalogException {
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("SshJobSubmission", new Object[0][]);
            generator.setParameter("jobSubmissionInterfaceId", identifier);
            Query q = generator.selectQuery(em);
            SshJobSubmission sshJobSubmission = (SshJobSubmission)q.getSingleResult();
            SshJobSubmissionResource sshJobSubmissionResource = (SshJobSubmissionResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.SSH_JOB_SUBMISSION, sshJobSubmission);
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            SshJobSubmissionResource sshJobSubmissionResource2 = sshJobSubmissionResource;
            return sshJobSubmissionResource2;
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public List<AppCatalogResource> get(String fieldName, Object value) throws AppCatalogException {
        ArrayList<AppCatalogResource> sshJobSubmissionResources = new ArrayList<AppCatalogResource>();
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("SshJobSubmission", new Object[0][]);
            if (fieldName.equals("resourceJobManagerId") || fieldName.equals("jobSubmissionInterfaceId") || fieldName.equals("alternativeSshHostname") || fieldName.equals("securityProtocol") || fieldName.equals("sshPort")) {
                generator.setParameter(fieldName, value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                for (Object result : results) {
                    SshJobSubmission sshJobSubmission = (SshJobSubmission)result;
                    SshJobSubmissionResource sshJobSubmissionResource = (SshJobSubmissionResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.SSH_JOB_SUBMISSION, sshJobSubmission);
                    sshJobSubmissionResources.add(sshJobSubmissionResource);
                }
            } else {
                em.getTransaction().commit();
                if (em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
                logger.error("Unsupported field name for Ssh Job Submission Resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported field name for Ssh Job Submission Resource.");
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return sshJobSubmissionResources;
    }

    @Override
    public List<AppCatalogResource> getAll() throws AppCatalogException {
        return null;
    }

    @Override
    public List<String> getAllIds() throws AppCatalogException {
        return null;
    }

    @Override
    public List<String> getIds(String fieldName, Object value) throws AppCatalogException {
        ArrayList<String> sshJobSubmissionResourceIDs = new ArrayList<String>();
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("SshJobSubmission", new Object[0][]);
            if (fieldName.equals("resourceJobManagerId") || fieldName.equals("jobSubmissionInterfaceId") || fieldName.equals("alternativeSshHostname") || fieldName.equals("securityProtocol") || fieldName.equals("sshPort")) {
                generator.setParameter(fieldName, value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                for (Object result : results) {
                    SshJobSubmission sshJobSubmission = (SshJobSubmission)result;
                    SshJobSubmissionResource sshJobSubmissionResource = (SshJobSubmissionResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.SSH_JOB_SUBMISSION, sshJobSubmission);
                    sshJobSubmissionResourceIDs.add(sshJobSubmissionResource.getJobSubmissionInterfaceId());
                }
            } else {
                em.getTransaction().commit();
                if (em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
                logger.error("Unsupported field name for Ssh Job Submission Resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported field name for Ssh Job Submission Resource.");
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return sshJobSubmissionResourceIDs;
    }

    @Override
    public void save() throws AppCatalogException {
        EntityManager em = null;
        try {
            SshJobSubmission sshJobSubmission;
            em = AppCatalogJPAUtils.getEntityManager();
            SshJobSubmission existingSshJobSubmission = (SshJobSubmission)em.find(SshJobSubmission.class, (Object)this.jobSubmissionInterfaceId);
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            if (existingSshJobSubmission == null) {
                sshJobSubmission = new SshJobSubmission();
                sshJobSubmission.setCreationTime(AiravataUtils.getCurrentTimestamp());
            } else {
                sshJobSubmission = existingSshJobSubmission;
                sshJobSubmission.setUpdateTime(AiravataUtils.getCurrentTimestamp());
            }
            sshJobSubmission.setResourceJobManagerId(this.getResourceJobManagerId());
            ResourceJobManager resourceJobManager = (ResourceJobManager)em.find(ResourceJobManager.class, (Object)this.getResourceJobManagerId());
            sshJobSubmission.setResourceJobManager(resourceJobManager);
            sshJobSubmission.setJobSubmissionInterfaceId(this.getJobSubmissionInterfaceId());
            sshJobSubmission.setAlternativeSshHostname(this.getAlternativeSshHostname());
            sshJobSubmission.setSecurityProtocol(this.getSecurityProtocol());
            sshJobSubmission.setSshPort(this.getSshPort());
            sshJobSubmission.setMonitorMode(this.getMonitorMode());
            if (existingSshJobSubmission == null) {
                em.persist((Object)sshJobSubmission);
            } else {
                em.merge((Object)sshJobSubmission);
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public boolean isExists(Object identifier) throws AppCatalogException {
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            SshJobSubmission sshJobSubmission = (SshJobSubmission)em.find(SshJobSubmission.class, identifier);
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            boolean bl = sshJobSubmission != null;
            return bl;
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    public String getResourceJobManagerId() {
        return this.resourceJobManagerId;
    }

    public ResourceJobManagerResource getResourceJobManagerResource() {
        return this.resourceJobManagerResource;
    }

    public String getJobSubmissionInterfaceId() {
        return this.jobSubmissionInterfaceId;
    }

    public String getAlternativeSshHostname() {
        return this.alternativeSshHostname;
    }

    public String getSecurityProtocol() {
        return this.securityProtocol;
    }

    public int getSshPort() {
        return this.sshPort;
    }

    public void setResourceJobManagerId(String resourceJobManagerId) {
        this.resourceJobManagerId = resourceJobManagerId;
    }

    public void setResourceJobManagerResource(ResourceJobManagerResource resourceJobManagerResource) {
        this.resourceJobManagerResource = resourceJobManagerResource;
    }

    public void setJobSubmissionInterfaceId(String jobSubmissionInterfaceId) {
        this.jobSubmissionInterfaceId = jobSubmissionInterfaceId;
    }

    public void setAlternativeSshHostname(String alternativeSshHostname) {
        this.alternativeSshHostname = alternativeSshHostname;
    }

    public void setSecurityProtocol(String securityProtocol) {
        this.securityProtocol = securityProtocol;
    }

    public void setSshPort(int sshPort) {
        this.sshPort = sshPort;
    }

    public String getMonitorMode() {
        return this.monitorMode;
    }

    public void setMonitorMode(String monitorMode) {
        this.monitorMode = monitorMode;
    }
}

