/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.experiment.catalog.resources;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.airavata.registry.core.experiment.catalog.ExpCatResourceUtils;
import org.apache.airavata.registry.core.experiment.catalog.ExperimentCatResource;
import org.apache.airavata.registry.core.experiment.catalog.ResourceType;
import org.apache.airavata.registry.core.experiment.catalog.model.Experiment;
import org.apache.airavata.registry.core.experiment.catalog.model.Gateway;
import org.apache.airavata.registry.core.experiment.catalog.model.GatewayWorker;
import org.apache.airavata.registry.core.experiment.catalog.model.GatewayWorkerPK;
import org.apache.airavata.registry.core.experiment.catalog.model.Project;
import org.apache.airavata.registry.core.experiment.catalog.model.UserPK;
import org.apache.airavata.registry.core.experiment.catalog.model.Users;
import org.apache.airavata.registry.core.experiment.catalog.resources.AbstractExpCatResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.ExperimentResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.ProjectResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.UserResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.Utils;
import org.apache.airavata.registry.core.experiment.catalog.resources.WorkerResource;
import org.apache.airavata.registry.core.experiment.catalog.utils.QueryGenerator;
import org.apache.airavata.registry.cpi.RegistryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GatewayResource
extends AbstractExpCatResource {
    private static final Logger logger = LoggerFactory.getLogger(GatewayResource.class);
    private String gatewayId;
    private String gatewayName;
    private String domain;
    private String emailAddress;
    private String gatewayApprovalStatus;
    private String gatewayAcronym;
    private String gatewayUrl;
    private String gatewayPublicAbstract;
    private String reviewProposalDescription;
    private String gatewayAdminFirstName;
    private String getGatewayAdminLastName;
    private String gatewayAdminEmail;
    private String identityServerUserName;
    private String identityServerPasswordToken;
    private String declinedReason;
    private String oauthClientId;
    private String oauthClientSecret;
    private Timestamp requestCreationTime;
    private String requesterUsername;

    public String getGatewayAdminFirstName() {
        return this.gatewayAdminFirstName;
    }

    public void setGatewayAdminFirstName(String gatewayAdminFirstName) {
        this.gatewayAdminFirstName = gatewayAdminFirstName;
    }

    public String getGetGatewayAdminLastName() {
        return this.getGatewayAdminLastName;
    }

    public void setGetGatewayAdminLastName(String getGatewayAdminLastName) {
        this.getGatewayAdminLastName = getGatewayAdminLastName;
    }

    public String getGatewayAdminEmail() {
        return this.gatewayAdminEmail;
    }

    public void setGatewayAdminEmail(String gatewayAdminEmail) {
        this.gatewayAdminEmail = gatewayAdminEmail;
    }

    public String getIdentityServerUserName() {
        return this.identityServerUserName;
    }

    public void setIdentityServerUserName(String identityServerUserName) {
        this.identityServerUserName = identityServerUserName;
    }

    public String getIdentityServerPasswordToken() {
        return this.identityServerPasswordToken;
    }

    public void setIdentityServerPasswordToken(String identityServerPasswordToken) {
        this.identityServerPasswordToken = identityServerPasswordToken;
    }

    public String getGatewayId() {
        return this.gatewayId;
    }

    public void setGatewayId(String gatewayId) {
        this.gatewayId = gatewayId;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public String getGatewayApprovalStatus() {
        return this.gatewayApprovalStatus;
    }

    public void setGatewayApprovalStatus(String gatewayApprovalStatus) {
        this.gatewayApprovalStatus = gatewayApprovalStatus;
    }

    public String getGatewayAcronym() {
        return this.gatewayAcronym;
    }

    public void setGatewayAcronym(String gatewayAcronym) {
        this.gatewayAcronym = gatewayAcronym;
    }

    public String getGatewayUrl() {
        return this.gatewayUrl;
    }

    public void setGatewayUrl(String gatewayUrl) {
        this.gatewayUrl = gatewayUrl;
    }

    public String getGatewayPublicAbstract() {
        return this.gatewayPublicAbstract;
    }

    public void setGatewayPublicAbstract(String gatewayPublicAbstract) {
        this.gatewayPublicAbstract = gatewayPublicAbstract;
    }

    public String getReviewProposalDescription() {
        return this.reviewProposalDescription;
    }

    public void setReviewProposalDescription(String reviewProposalDescription) {
        this.reviewProposalDescription = reviewProposalDescription;
    }

    public String getDeclinedReason() {
        return this.declinedReason;
    }

    public void setDeclinedReason(String declinedReason) {
        this.declinedReason = declinedReason;
    }

    public String getOauthClientId() {
        return this.oauthClientId;
    }

    public void setOauthClientId(String oauthClientId) {
        this.oauthClientId = oauthClientId;
    }

    public String getOauthClientSecret() {
        return this.oauthClientSecret;
    }

    public void setOauthClientSecret(String oauthClientSecret) {
        this.oauthClientSecret = oauthClientSecret;
    }

    public Timestamp getRequestCreationTime() {
        return this.requestCreationTime;
    }

    public void setRequestCreationTime(Timestamp requestCreationTime) {
        this.requestCreationTime = requestCreationTime;
    }

    public String getRequesterUsername() {
        return this.requesterUsername;
    }

    public void setRequesterUsername(String requesterUsername) {
        this.requesterUsername = requesterUsername;
    }

    public GatewayResource(String gatewayId) {
        this.setGatewayId(gatewayId);
    }

    public GatewayResource() {
    }

    public String getGatewayName() {
        return this.gatewayName;
    }

    public void setGatewayName(String gatewayName) {
        this.gatewayName = gatewayName;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Override
    public ExperimentCatResource create(ResourceType type) throws RegistryException {
        switch (type) {
            case PROJECT: {
                ProjectResource projectResource = new ProjectResource();
                projectResource.setGatewayId(this.gatewayId);
                return projectResource;
            }
            case EXPERIMENT: {
                ExperimentResource experimentResource = new ExperimentResource();
                experimentResource.setGatewayExecutionId(this.gatewayId);
                return experimentResource;
            }
            case GATEWAY_WORKER: {
                WorkerResource workerResource = new WorkerResource();
                workerResource.setGatewayId(this.gatewayId);
                return workerResource;
            }
        }
        logger.error("Unsupported resource type for gateway resource.", (Throwable)new IllegalArgumentException());
        throw new IllegalArgumentException("Unsupported resource type for gateway resource.");
    }

    @Override
    public void remove(ResourceType type, Object name) throws RegistryException {
        EntityManager em = null;
        try {
            em = ExpCatResourceUtils.getEntityManager();
            em.getTransaction().begin();
            switch (type) {
                case USER: {
                    QueryGenerator generator = new QueryGenerator("Users", new Object[0][]);
                    generator.setParameter("userName", name);
                    Query q = generator.deleteQuery(em);
                    q.executeUpdate();
                    break;
                }
                case EXPERIMENT: {
                    QueryGenerator generator = new QueryGenerator("Experiment", new Object[0][]);
                    generator.setParameter("experimentId", name);
                    Query q = generator.deleteQuery(em);
                    q.executeUpdate();
                    break;
                }
                default: {
                    logger.error("Unsupported resource type for gateway resource.", (Throwable)new IllegalArgumentException());
                }
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public ExperimentCatResource get(ResourceType type, Object name) throws RegistryException {
        EntityManager em = null;
        try {
            em = ExpCatResourceUtils.getEntityManager();
            em.getTransaction().begin();
            switch (type) {
                case GATEWAY_WORKER: {
                    QueryGenerator generator = new QueryGenerator("GatewayWorker", new Object[0][]);
                    generator.setParameter("userName", name);
                    generator.setParameter("gatewayId", this.gatewayId);
                    Query q = generator.selectQuery(em);
                    GatewayWorker worker = (GatewayWorker)q.getSingleResult();
                    WorkerResource workerResource = (WorkerResource)Utils.getResource(ResourceType.GATEWAY_WORKER, worker);
                    em.getTransaction().commit();
                    em.close();
                    WorkerResource workerResource2 = workerResource;
                    return workerResource2;
                }
                case USER: {
                    QueryGenerator generator = new QueryGenerator("Users", new Object[0][]);
                    generator.setParameter("userName", name);
                    Query q = generator.selectQuery(em);
                    Users user = (Users)q.getSingleResult();
                    UserResource userResource = (UserResource)Utils.getResource(ResourceType.USER, user);
                    em.getTransaction().commit();
                    em.close();
                    UserResource userResource2 = userResource;
                    return userResource2;
                }
                case EXPERIMENT: {
                    QueryGenerator generator = new QueryGenerator("Experiment", new Object[0][]);
                    generator.setParameter("experimentId", name);
                    Query q = generator.selectQuery(em);
                    Experiment experiment = (Experiment)q.getSingleResult();
                    ExperimentResource experimentResource = (ExperimentResource)Utils.getResource(ResourceType.EXPERIMENT, experiment);
                    em.getTransaction().commit();
                    em.close();
                    ExperimentResource experimentResource2 = experimentResource;
                    return experimentResource2;
                }
            }
            try {
                em.getTransaction().commit();
                em.close();
                logger.error("Unsupported resource type for gateway resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported resource type for gateway resource.");
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new RegistryException((Throwable)e);
            }
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public List<ExperimentCatResource> get(ResourceType type) throws RegistryException {
        ArrayList<ExperimentCatResource> resourceList = new ArrayList<ExperimentCatResource>();
        EntityManager em = null;
        try {
            em = ExpCatResourceUtils.getEntityManager();
            em.getTransaction().begin();
            switch (type) {
                case PROJECT: {
                    QueryGenerator generator = new QueryGenerator("Project", new Object[0][]);
                    Gateway gatewayModel = (Gateway)em.find(Gateway.class, (Object)this.gatewayId);
                    generator.setParameter("gateway", gatewayModel);
                    Query q = generator.selectQuery(em);
                    List results = q.getResultList();
                    if (results.size() == 0) break;
                    for (Object result : results) {
                        Project project = (Project)result;
                        ProjectResource projectResource = (ProjectResource)Utils.getResource(ResourceType.PROJECT, project);
                        resourceList.add(projectResource);
                    }
                    break;
                }
                case GATEWAY_WORKER: {
                    QueryGenerator generator = new QueryGenerator("GatewayWorker", new Object[0][]);
                    generator.setParameter("gatewayId", this.gatewayId);
                    Query q = generator.selectQuery(em);
                    List results = q.getResultList();
                    if (results.size() == 0) break;
                    for (Object result : results) {
                        GatewayWorker gatewayWorker = (GatewayWorker)result;
                        WorkerResource workerResource = (WorkerResource)Utils.getResource(ResourceType.GATEWAY_WORKER, gatewayWorker);
                        resourceList.add(workerResource);
                    }
                    break;
                }
                case USER: {
                    QueryGenerator generator = new QueryGenerator("Users", new Object[0][]);
                    Query q = generator.selectQuery(em);
                    for (Object o : q.getResultList()) {
                        Users user = (Users)o;
                        UserResource userResource = (UserResource)Utils.getResource(ResourceType.USER, user);
                        resourceList.add(userResource);
                    }
                    break;
                }
                default: {
                    logger.error("Unsupported resource type for gateway resource.", (Throwable)new IllegalArgumentException());
                    throw new IllegalArgumentException("Unsupported resource type for gateway resource.");
                }
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return resourceList;
    }

    @Override
    public void save() throws RegistryException {
        EntityManager em = null;
        try {
            em = ExpCatResourceUtils.getEntityManager();
            Gateway existingGateway = (Gateway)em.find(Gateway.class, (Object)this.gatewayId);
            em.close();
            em = ExpCatResourceUtils.getEntityManager();
            em.getTransaction().begin();
            Gateway gateway = new Gateway();
            gateway.setGatewayName(this.gatewayName);
            gateway.setGatewayId(this.gatewayId);
            gateway.setGatewayApprovalStatus(this.gatewayApprovalStatus);
            gateway.setDomain(this.domain);
            gateway.setEmailAddress(this.emailAddress);
            gateway.setGatewayAcronym(this.gatewayAcronym);
            gateway.setGatewayUrl(this.gatewayUrl);
            gateway.setGatewayPublicAbstract(this.gatewayPublicAbstract);
            gateway.setReviewProposalDescription(this.reviewProposalDescription);
            gateway.setGatewayAdminFirstName(this.gatewayAdminFirstName);
            gateway.setGetGatewayAdminLastName(this.getGatewayAdminLastName);
            gateway.setGatewayAdminEmail(this.gatewayAdminEmail);
            gateway.setIdentityServerUserName(this.identityServerUserName);
            gateway.setIdentityServerPasswordToken(this.identityServerPasswordToken);
            gateway.setDeclinedReason(this.declinedReason);
            gateway.setOauthClientId(this.oauthClientId);
            gateway.setGetOauthClientSecret(this.oauthClientSecret);
            gateway.setRequestCreationTime(this.requestCreationTime);
            gateway.setRequesterUsername(this.requesterUsername);
            if (existingGateway != null) {
                existingGateway.setDomain(this.domain);
                existingGateway.setGatewayApprovalStatus(this.gatewayApprovalStatus);
                existingGateway.setGatewayName(this.gatewayName);
                gateway.setGatewayApprovalStatus(this.gatewayApprovalStatus);
                existingGateway.setEmailAddress(this.emailAddress);
                existingGateway.setGatewayAcronym(this.gatewayAcronym);
                existingGateway.setGatewayUrl(this.gatewayUrl);
                existingGateway.setGatewayPublicAbstract(this.gatewayPublicAbstract);
                existingGateway.setReviewProposalDescription(this.reviewProposalDescription);
                existingGateway.setGatewayAdminFirstName(this.gatewayAdminFirstName);
                existingGateway.setGetGatewayAdminLastName(this.getGatewayAdminLastName);
                existingGateway.setGatewayAdminEmail(this.gatewayAdminEmail);
                existingGateway.setIdentityServerUserName(this.identityServerUserName);
                existingGateway.setIdentityServerPasswordToken(this.identityServerPasswordToken);
                existingGateway.setDeclinedReason(this.declinedReason);
                existingGateway.setOauthClientId(this.oauthClientId);
                existingGateway.setGetOauthClientSecret(this.oauthClientSecret);
                existingGateway.setRequestCreationTime(this.requestCreationTime);
                existingGateway.setRequesterUsername(this.requesterUsername);
                em.merge((Object)existingGateway);
            } else {
                em.persist((Object)gateway);
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public boolean isExists(ResourceType type, Object name) throws RegistryException {
        EntityManager em = null;
        try {
            switch (type) {
                case GATEWAY_WORKER: {
                    em = ExpCatResourceUtils.getEntityManager();
                    GatewayWorkerPK gatewayWorkerPK = new GatewayWorkerPK();
                    gatewayWorkerPK.setGatewayId(this.gatewayId);
                    gatewayWorkerPK.setUserName(name.toString());
                    GatewayWorker existingWorker = (GatewayWorker)em.find(GatewayWorker.class, (Object)gatewayWorkerPK);
                    em.close();
                    boolean bl = existingWorker != null;
                    return bl;
                }
                case USER: {
                    em = ExpCatResourceUtils.getEntityManager();
                    UserPK userPK = new UserPK();
                    userPK.setGatewayId(this.getGatewayId());
                    userPK.setUserName(name.toString());
                    Users existingUser = (Users)em.find(Users.class, (Object)userPK);
                    em.close();
                    boolean bl = existingUser != null;
                    return bl;
                }
                case EXPERIMENT: {
                    em = ExpCatResourceUtils.getEntityManager();
                    Experiment existingExp = (Experiment)em.find(Experiment.class, (Object)name.toString());
                    em.close();
                    boolean bl = existingExp != null;
                    return bl;
                }
            }
            try {
                logger.error("Unsupported resource type for gateway resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported resource type for gateway resource.");
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new RegistryException((Throwable)e);
            }
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    public ExperimentResource getExperiment(String expId) throws RegistryException {
        return (ExperimentResource)this.get(ResourceType.EXPERIMENT, expId);
    }

    public List<ExperimentResource> getExperiments() throws RegistryException {
        ArrayList<ExperimentResource> experiments = new ArrayList<ExperimentResource>();
        List<ExperimentCatResource> resources = this.get(ResourceType.EXPERIMENT);
        for (ExperimentCatResource resource : resources) {
            experiments.add((ExperimentResource)resource);
        }
        return experiments;
    }
}

