/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.wsutil.client;

import eu.unicore.security.wsutil.XmlBeansNsHackOutHandler;
import eu.unicore.security.wsutil.XmlBinding;
import eu.unicore.security.wsutil.client.CheckUnderstoodHeadersHandler;
import eu.unicore.security.wsutil.client.Configurable;
import eu.unicore.security.wsutil.client.LogInMessageHandler;
import eu.unicore.security.wsutil.client.LogOutMessageHandler;
import eu.unicore.security.wsutil.client.MySSLSocketFactory;
import eu.unicore.security.wsutil.client.RetryFeature;
import eu.unicore.security.wsutil.client.SessionIDInHandler;
import eu.unicore.security.wsutil.client.SessionIDOutHandler;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.HttpClientProperties;
import eu.unicore.util.httpclient.HttpUtils;
import eu.unicore.util.httpclient.IClientConfiguration;
import eu.unicore.util.httpclient.SessionIDProvider;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.io.IOUtils;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.configuration.security.ProxyAuthorizationPolicy;
import org.apache.cxf.databinding.AbstractDataBinding;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.feature.Feature;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.jaxws.endpoint.dynamic.JaxWsDynamicClientFactory;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.factory.ReflectionServiceFactoryBean;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.ConnectionType;
import org.apache.cxf.transports.http.configuration.ProxyServerType;
import org.apache.cxf.xmlbeans.XmlBeansDataBinding;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class WSClientFactory {
    protected static final Logger logger = Log.getLogger("unicore.client", WSClientFactory.class);
    protected IClientConfiguration securityProperties;
    protected HttpClientProperties settings;
    protected final List<Interceptor<? extends Message>> inHandlers = new ArrayList<Interceptor<? extends Message>>();
    protected final List<Interceptor<? extends Message>> outHandlers = new ArrayList<Interceptor<? extends Message>>();
    protected final List<Interceptor<? extends Message>> faultHandlers = new ArrayList<Interceptor<? extends Message>>();
    protected final List<Feature> features = new ArrayList<Feature>();

    public WSClientFactory(IClientConfiguration securityCfg) {
        if (securityCfg == null) {
            throw new IllegalArgumentException("IAuthenticationConfiguration can not be null");
        }
        if (securityCfg.getHttpClientProperties() == null) {
            throw new IllegalArgumentException("HTTP settings can not be null");
        }
        Logger.getLogger(ReflectionServiceFactoryBean.class).setLevel(Level.FATAL);
        this.securityProperties = securityCfg.clone();
        this.settings = this.securityProperties.getHttpClientProperties();
        this.initHandlers();
        this.configureHandlers();
    }

    protected void configureHandlers() {
        for (Interceptor<? extends Message> i : this.inHandlers) {
            if (!(i instanceof Configurable)) continue;
            ((Configurable)i).configure(this.securityProperties);
        }
        for (Interceptor<? extends Message> i : this.outHandlers) {
            if (!(i instanceof Configurable)) continue;
            ((Configurable)i).configure(this.securityProperties);
        }
    }

    protected void initHandlers() {
        if (this.securityProperties.isMessageLogging()) {
            this.inHandlers.add((Interceptor<? extends Message>)new LogInMessageHandler());
            this.outHandlers.add((Interceptor<? extends Message>)new LogOutMessageHandler());
        }
        this.inHandlers.add((Interceptor<? extends Message>)new CheckUnderstoodHeadersHandler());
        this.outHandlers.add((Interceptor<? extends Message>)new CheckUnderstoodHeadersHandler());
        this.outHandlers.add((Interceptor<? extends Message>)new XmlBeansNsHackOutHandler());
        if (this.securityProperties.useSecuritySessions()) {
            this.inHandlers.add((Interceptor<? extends Message>)new SessionIDInHandler());
            this.outHandlers.add((Interceptor<? extends Message>)new SessionIDOutHandler());
        }
    }

    protected void initFeatures() {
    }

    public synchronized <T> T createPlainWSProxy(Class<T> iFace, String url) throws MalformedURLException {
        JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
        factory.setAddress(url);
        AbstractDataBinding binding = WSClientFactory.getBinding(iFace);
        logger.debug("Using databinding " + binding.getClass().getName());
        factory.setDataBinding((DataBinding)binding);
        Object proxy = factory.create(iFace);
        this.doAddHandlers(proxy);
        this.doAddFeatures(proxy);
        this.setupRetry(proxy);
        this.setupProxy(proxy, url);
        this.setupProxyInterface(iFace, WSClientFactory.getWSClient(proxy));
        return (T)proxy;
    }

    protected <T> void setupProxyInterface(Class<T> iFace, Client wsClient) {
    }

    public Client createDynamicClient(String url) throws Exception {
        JaxWsDynamicClientFactory dcf = JaxWsDynamicClientFactory.newInstance();
        Client client = dcf.createClient(url);
        this.setupProxy(client, url);
        return client;
    }

    protected void doAddHandlers(Object proxy) {
        Client client = WSClientFactory.getWSClient(proxy);
        for (Interceptor<? extends Message> h : this.outHandlers) {
            client.getOutInterceptors().add(h);
        }
        for (Interceptor<? extends Message> h : this.inHandlers) {
            client.getInInterceptors().add(h);
        }
        for (Interceptor<? extends Message> h : this.faultHandlers) {
            client.getOutFaultInterceptors().add(h);
        }
    }

    protected void doAddFeatures(Object proxy) {
        this.initFeatures();
        Client client = WSClientFactory.getWSClient(proxy);
        for (Feature f : this.features) {
            f.initialize(client, null);
        }
    }

    protected boolean isLocal(String url) {
        if (url == null) {
            return false;
        }
        return url.startsWith("local://");
    }

    protected void setupWSClientProxy(Client client, String uri) {
        HTTPConduit http = (HTTPConduit)client.getConduit();
        this.setupHTTPParams(http);
    }

    public void setupHTTPParams(HTTPConduit http) {
        if (this.securityProperties.doHttpAuthn()) {
            AuthorizationPolicy httpAuth = new AuthorizationPolicy();
            httpAuth.setUserName(this.securityProperties.getHttpUser());
            httpAuth.setPassword(this.securityProperties.getHttpPassword());
            http.setAuthorization(httpAuth);
        }
        TLSClientParameters params = new TLSClientParameters();
        params.setSSLSocketFactory((SSLSocketFactory)new MySSLSocketFactory(this.securityProperties));
        params.setDisableCNCheck(true);
        http.setTlsClientParameters(params);
        http.getClient().setConnectionTimeout((long)this.settings.getIntValue("connection.timeout").intValue());
        http.getClient().setReceiveTimeout((long)this.settings.getIntValue("socket.timeout").intValue());
        if (this.settings.getBooleanValue("connection-close").booleanValue()) {
            http.getClient().setConnection(ConnectionType.CLOSE);
        }
        boolean allowChunking = this.settings.getBooleanValue("allow-chunking");
        http.getClient().setAllowChunking(allowChunking);
        String uri = http.getAddress();
        this.configureHttpProxy(http, uri);
    }

    public RetryFeature getDefaultRetryFeature() {
        RetryFeature r = new RetryFeature(this);
        r.setMaxRetries(this.securityProperties.getMaxWSRetries());
        r.setDelayBetweenRetries(this.securityProperties.getRetryDelay());
        r.getRecoverableExceptions().add(SocketTimeoutException.class);
        return r;
    }

    public void setupRetry(Object proxy, RetryFeature retry) {
        Client client = WSClientFactory.getWSClient(proxy);
        retry.initialize(client, null);
        client.getRequestContext().put(RetryFeature.class.getName(), retry);
    }

    public void setupRetry(Object proxy) {
        this.setupRetry(proxy, this.getDefaultRetryFeature());
    }

    private void configureHttpProxy(HTTPConduit http, String uri) {
        if (this.isNonProxyHost(uri)) {
            return;
        }
        String proxyHost = this.settings.getValue("proxyHost");
        if (proxyHost == null) {
            proxyHost = System.getProperty("http.proxyHost");
        }
        if (proxyHost != null && proxyHost.trim().length() > 0) {
            String portS = this.settings.getValue("proxyPort");
            if (portS == null) {
                portS = System.getProperty("http.proxyPort");
            }
            int port = 80;
            if (portS != null) {
                port = Integer.parseInt(portS);
            }
            http.getClient().setProxyServer(proxyHost);
            http.getClient().setProxyServerPort(port);
            String proxyType = this.settings.getValue("proxyType");
            http.getClient().setProxyServerType(ProxyServerType.fromValue((String)proxyType));
            String user = this.settings.getValue("proxy.user");
            if (user != null) {
                ProxyAuthorizationPolicy ap = new ProxyAuthorizationPolicy();
                ap.setUserName(user);
                String password = this.settings.getValue("proxy.password");
                if (password != null) {
                    ap.setPassword(password);
                }
                http.setProxyAuthorization(ap);
            }
        }
    }

    private boolean isNonProxyHost(String uri) {
        String nonProxyHosts = this.settings.getValue("nonProxyHosts");
        if (nonProxyHosts == null) {
            return false;
        }
        try {
            String[] npHosts;
            URI u = new URI(uri);
            String host = u.getHost();
            for (String npHost : npHosts = nonProxyHosts.split(" ")) {
                if (!host.contains(npHost)) continue;
                return true;
            }
        }
        catch (URISyntaxException e) {
            logger.error("Can't resolve URI from " + uri, e);
        }
        return false;
    }

    protected void setupProxy(Object proxy, String uri) {
        Client wsClient = WSClientFactory.getWSClient(proxy);
        this.setupWSClientProxy(wsClient, uri);
        if (this.securityProperties.useSecuritySessions()) {
            wsClient.getRequestContext().put("unicore-security-session-target-url", uri);
        }
    }

    public static Client getWSClient(Object proxy) {
        return ClientProxy.getClient((Object)proxy);
    }

    public static RetryFeature getRetryFeature(Object proxy) {
        Client c = WSClientFactory.getWSClient(proxy);
        return (RetryFeature)((Object)c.getRequestContext().get(RetryFeature.class.getName()));
    }

    protected String getServiceWSDL(String url, IClientConfiguration sec) throws Exception {
        HttpClient client = HttpUtils.createClient(url, sec);
        String wsdlurl = url + "?wsdl";
        HttpGet method = new HttpGet(wsdlurl);
        HttpResponse response = client.execute((HttpUriRequest)method);
        return IOUtils.toString((InputStream)response.getEntity().getContent());
    }

    public static AbstractDataBinding getBinding(Class<?> clazz) {
        XmlBinding annot = clazz.getAnnotation(XmlBinding.class);
        if (annot == null || "xmlbeans".equalsIgnoreCase(annot.name())) {
            return new XmlBeansDataBinding();
        }
        if ("jaxb".equalsIgnoreCase(annot.name())) {
            return new JAXBDataBinding();
        }
        throw new IllegalArgumentException("Unknown databinding: " + annot.name());
    }

    public SessionIDProvider getSessionIDProvider() {
        return this.securityProperties.getSessionIDProvider();
    }
}

