/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.wsutil.client.authn;

import eu.unicore.security.wsutil.client.authn.AuthenticationProvider;
import eu.unicore.security.wsutil.client.authn.ClientConfigurationProvider;
import eu.unicore.security.wsutil.client.authn.DelegationSpecification;
import eu.unicore.security.wsutil.client.authn.SecuritySessionPersistence;
import eu.unicore.security.wsutil.client.authn.ServiceIdentityResolver;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ClientConfigurationProviderImpl
implements ClientConfigurationProvider {
    private Map<String, String[]> securityPreferences;
    private AuthenticationProvider authnProvider;
    private IClientConfiguration basicConfiguration;
    private IClientConfiguration anonymousConfiguration;
    private SecuritySessionPersistence sessionsPersistence;
    private ServiceIdentityResolver identityResolver;

    public ClientConfigurationProviderImpl(AuthenticationProvider authnProvider, SecuritySessionPersistence sessionsPersistence, ServiceIdentityResolver identityResolver, Map<String, String[]> securityPreferences) throws Exception {
        this.securityPreferences = securityPreferences;
        this.authnProvider = authnProvider;
        this.sessionsPersistence = sessionsPersistence;
        this.identityResolver = identityResolver;
        this.basicConfiguration = authnProvider.getBaseClientConfiguration();
        this.anonymousConfiguration = authnProvider.getAnonymousClientConfiguration();
        sessionsPersistence.readSessionIDs(this.basicConfiguration.getSessionIDProvider());
    }

    protected ClientConfigurationProviderImpl() {
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public IClientConfiguration getClientConfiguration(String serviceUrl, String serviceIdentity, DelegationSpecification delegate) throws Exception {
        if (serviceUrl == null) {
            throw new IllegalArgumentException("Service URL must be always given");
        }
        if (serviceUrl.startsWith("http://")) {
            return this.getAnonymousClientConfiguration();
        }
        if (serviceIdentity == null) {
            try {
                serviceIdentity = this.identityResolver.resolveIdentity(serviceUrl);
            }
            catch (IOException e) {
                if (!delegate.isDelegate()) ** GOTO lbl13
                throw e;
            }
        } else {
            this.identityResolver.registerIdentity(serviceUrl, serviceIdentity);
        }
lbl13:
        // 3 sources

        securityProperties = this.authnProvider.getClientConfiguration(serviceUrl, serviceIdentity, delegate);
        target = securityProperties.getETDSettings().getRequestedUserAttributes2();
        target.putAll(this.securityPreferences);
        securityProperties.setSessionIDProvider(this.basicConfiguration.getSessionIDProvider());
        return securityProperties;
    }

    @Override
    public void flushSessions() throws IOException {
        this.sessionsPersistence.storeSessionIDs(this.basicConfiguration.getSessionIDProvider());
    }

    @Override
    public IClientConfiguration getAnonymousClientConfiguration() throws Exception {
        return this.anonymousConfiguration.clone();
    }

    @Override
    public IClientConfiguration getBasicClientConfiguration() {
        return this.basicConfiguration.clone();
    }

    protected void setSecurityPreferences(Map<String, String[]> securityPreferences) {
        this.securityPreferences = new HashMap<String, String[]>(securityPreferences);
    }

    protected void setAuthnProvider(AuthenticationProvider authnProvider) {
        this.authnProvider = authnProvider;
    }

    protected void setBasicConfiguration(IClientConfiguration basicConfiguration) {
        this.basicConfiguration = basicConfiguration;
    }

    protected void setAnonymousConfiguration(IClientConfiguration anonymousConfiguration) {
        this.anonymousConfiguration = anonymousConfiguration;
    }

    protected void setSessionsPersistence(SecuritySessionPersistence sessionsPersistence) {
        this.sessionsPersistence = sessionsPersistence;
    }

    @Override
    public ServiceIdentityResolver getIdentityResolver() {
        return this.identityResolver;
    }

    protected void setIdentityResolver(ServiceIdentityResolver identityResolver) {
        this.identityResolver = identityResolver;
    }

    @Override
    public Map<String, String[]> getSecurityPreferences() {
        return new HashMap<String, String[]>(this.securityPreferences);
    }

    @Override
    public AuthenticationProvider getAuthnProvider() {
        return this.authnProvider;
    }

    @Override
    public SecuritySessionPersistence getSessionsPersistence() {
        return this.sessionsPersistence;
    }
}

