/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.airavata.common.exception.AiravataException;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.credential.store.credential.Credential;
import org.apache.airavata.credential.store.credential.impl.ssh.SSHCredential;
import org.apache.airavata.credential.store.store.CredentialReader;
import org.apache.airavata.credential.store.store.CredentialStoreException;
import org.apache.airavata.gfac.core.GFacEngine;
import org.apache.airavata.gfac.core.GFacException;
import org.apache.airavata.gfac.core.GFacUtils;
import org.apache.airavata.gfac.core.JobManagerConfiguration;
import org.apache.airavata.gfac.core.authentication.AuthenticationInfo;
import org.apache.airavata.gfac.core.authentication.SSHKeyAuthentication;
import org.apache.airavata.gfac.core.cluster.OutputParser;
import org.apache.airavata.gfac.core.cluster.RemoteCluster;
import org.apache.airavata.gfac.core.cluster.ServerInfo;
import org.apache.airavata.gfac.core.config.DataTransferTaskConfig;
import org.apache.airavata.gfac.core.config.GFacYamlConfigruation;
import org.apache.airavata.gfac.core.config.JobSubmitterTaskConfig;
import org.apache.airavata.gfac.core.config.ResourceConfig;
import org.apache.airavata.gfac.core.context.GFacContext;
import org.apache.airavata.gfac.core.context.ProcessContext;
import org.apache.airavata.gfac.core.monitor.JobMonitor;
import org.apache.airavata.gfac.core.scheduler.HostScheduler;
import org.apache.airavata.gfac.core.task.JobSubmissionTask;
import org.apache.airavata.gfac.core.task.Task;
import org.apache.airavata.gfac.core.watcher.CancelRequestWatcher;
import org.apache.airavata.gfac.core.watcher.RedeliveryRequestWatcher;
import org.apache.airavata.gfac.impl.DefaultHostScheduler;
import org.apache.airavata.gfac.impl.GFacEngineImpl;
import org.apache.airavata.gfac.impl.HPCRemoteCluster;
import org.apache.airavata.gfac.impl.LocalRemoteCluster;
import org.apache.airavata.gfac.impl.StandardOutReader;
import org.apache.airavata.gfac.impl.job.ForkJobConfiguration;
import org.apache.airavata.gfac.impl.job.LSFJobConfiguration;
import org.apache.airavata.gfac.impl.job.PBSJobConfiguration;
import org.apache.airavata.gfac.impl.job.SlurmJobConfiguration;
import org.apache.airavata.gfac.impl.job.UGEJobConfiguration;
import org.apache.airavata.gfac.impl.task.ArchiveTask;
import org.apache.airavata.gfac.impl.watcher.CancelRequestWatcherImpl;
import org.apache.airavata.gfac.impl.watcher.RedeliveryRequestWatcherImpl;
import org.apache.airavata.gfac.monitor.cloud.AuroraJobMonitor;
import org.apache.airavata.gfac.monitor.email.EmailBasedMonitor;
import org.apache.airavata.messaging.core.MessageHandler;
import org.apache.airavata.messaging.core.MessagingFactory;
import org.apache.airavata.messaging.core.Publisher;
import org.apache.airavata.messaging.core.Subscriber;
import org.apache.airavata.messaging.core.Type;
import org.apache.airavata.messaging.core.impl.RabbitMQPublisher;
import org.apache.airavata.model.appcatalog.computeresource.JobSubmissionProtocol;
import org.apache.airavata.model.appcatalog.computeresource.MonitorMode;
import org.apache.airavata.model.appcatalog.computeresource.ResourceJobManager;
import org.apache.airavata.model.appcatalog.computeresource.ResourceJobManagerType;
import org.apache.airavata.model.data.movement.DataMovementProtocol;
import org.apache.airavata.registry.core.experiment.catalog.impl.RegistryFactory;
import org.apache.airavata.registry.cpi.AppCatalog;
import org.apache.airavata.registry.cpi.AppCatalogException;
import org.apache.airavata.registry.cpi.ExperimentCatalog;
import org.apache.airavata.registry.cpi.RegistryException;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Factory {
    private static final Logger log = LoggerFactory.getLogger(Factory.class);
    private static GFacEngine engine;
    private static GFacContext gfacContext;
    private static Publisher statusPublisher;
    private static CuratorFramework curatorClient;
    private static EmailBasedMonitor emailBasedMonitor;
    private static Map<String, RemoteCluster> remoteClusterMap;
    private static Map<JobSubmissionProtocol, JobSubmissionTask> jobSubmissionTask;
    private static Map<DataMovementProtocol, Task> dataMovementTask;
    private static Map<ResourceJobManagerType, ResourceConfig> resources;
    private static Map<MonitorMode, JobMonitor> jobMonitorServices;
    private static Subscriber processLaunchSubscriber;
    private static Map<String, Session> sessionMap;
    private static Cache<String, Session> sessionCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GFacEngine getGFacEngine() throws GFacException {
        if (engine != null) return engine;
        Class<GFacEngineImpl> clazz = GFacEngineImpl.class;
        synchronized (GFacEngineImpl.class) {
            if (engine != null) return engine;
            engine = new GFacEngineImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return engine;
        }
    }

    public static void loadConfiguration() throws GFacException {
        GFacYamlConfigruation config = new GFacYamlConfigruation();
        try {
            JobSubmissionTask task;
            Constructor<?> constructor;
            Class<?> aClass;
            String taskClass;
            for (JobSubmitterTaskConfig jobSubmitterTaskConfig : config.getJobSbumitters()) {
                taskClass = jobSubmitterTaskConfig.getTaskClass();
                aClass = Class.forName(taskClass);
                constructor = aClass.getConstructor(new Class[0]);
                task = (JobSubmissionTask)constructor.newInstance(new Object[0]);
                task.init(jobSubmitterTaskConfig.getProperties());
                jobSubmissionTask.put(jobSubmitterTaskConfig.getSubmissionProtocol(), task);
            }
            for (DataTransferTaskConfig dataTransferTaskConfig : config.getFileTransferTasks()) {
                taskClass = dataTransferTaskConfig.getTaskClass();
                aClass = Class.forName(taskClass);
                constructor = aClass.getConstructor(new Class[0]);
                task = (Task)constructor.newInstance(new Object[0]);
                task.init(dataTransferTaskConfig.getProperties());
                dataMovementTask.put(dataTransferTaskConfig.getTransferProtocol(), (Task)task);
            }
            for (ResourceConfig resourceConfig : config.getResourceConfiguration()) {
                resources.put(resourceConfig.getJobManagerType(), resourceConfig);
            }
        }
        catch (Exception e) {
            throw new GFacException("Gfac config issue", (Throwable)e);
        }
        sessionCache = CacheBuilder.newBuilder().expireAfterAccess((long)ServerSettings.getSessionCacheAccessTimeout(), TimeUnit.MINUTES).removalListener(removalNotification -> {
            if (((Session)removalNotification.getValue()).isConnected()) {
                log.info("Disconnecting ssh session with key: " + (String)removalNotification.getKey());
                ((Session)removalNotification.getValue()).disconnect();
            }
            log.info("Removed ssh session with key: " + (String)removalNotification.getKey());
        }).build();
    }

    public static GFacContext getGfacContext() {
        if (gfacContext == null) {
            gfacContext = GFacContext.getInstance();
        }
        return gfacContext;
    }

    public static ExperimentCatalog getDefaultExpCatalog() throws RegistryException {
        return RegistryFactory.getDefaultExpCatalog();
    }

    public static AppCatalog getDefaultAppCatalog() throws AppCatalogException {
        return RegistryFactory.getAppCatalog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Publisher getStatusPublisher() throws AiravataException {
        if (statusPublisher != null) return statusPublisher;
        Class<RabbitMQPublisher> clazz = RabbitMQPublisher.class;
        synchronized (RabbitMQPublisher.class) {
            if (statusPublisher != null) return statusPublisher;
            statusPublisher = MessagingFactory.getPublisher((Type)Type.STATUS);
            // ** MonitorExit[var0] (shouldn't be in output)
            return statusPublisher;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CuratorFramework getCuratorClient() throws ApplicationSettingsException {
        if (curatorClient != null) return curatorClient;
        Class<Factory> clazz = Factory.class;
        synchronized (Factory.class) {
            if (curatorClient != null) return curatorClient;
            String connectionSting = ServerSettings.getZookeeperConnection();
            ExponentialBackoffRetry retryPolicy = new ExponentialBackoffRetry(1000, 5);
            curatorClient = CuratorFrameworkFactory.newClient((String)connectionSting, (RetryPolicy)retryPolicy);
            // ** MonitorExit[var0] (shouldn't be in output)
            return curatorClient;
        }
    }

    public static synchronized void initPrcessLaunchSubscriber(MessageHandler processMessageHandler) throws AiravataException {
        if (Factory.getProcessLaunchSubscriber() != null) {
            throw new AiravataException("Process launch Subscriber is already initialized");
        }
        ArrayList<String> routingKeys = new ArrayList<String>();
        routingKeys.add(ServerSettings.getRabbitmqProcessExchangeName());
        processLaunchSubscriber = MessagingFactory.getSubscriber((MessageHandler)processMessageHandler, routingKeys, (Type)Type.PROCESS_LAUNCH);
    }

    public static synchronized Subscriber getProcessLaunchSubscriber() throws AiravataException {
        return processLaunchSubscriber;
    }

    public static JobManagerConfiguration getJobManagerConfiguration(ResourceJobManager resourceJobManager) throws GFacException {
        OutputParser outputParser;
        if (resourceJobManager == null) {
            return null;
        }
        ResourceConfig resourceConfig = Factory.getResourceConfig(resourceJobManager.getResourceJobManagerType());
        try {
            Class<OutputParser> aClass = Class.forName(resourceConfig.getCommandOutputParser()).asSubclass(OutputParser.class);
            outputParser = aClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new GFacException("Error while instantiating output parser for " + resourceJobManager.getResourceJobManagerType().name());
        }
        String templateFileName = GFacUtils.getTemplateFileName((ResourceJobManagerType)resourceJobManager.getResourceJobManagerType());
        switch (resourceJobManager.getResourceJobManagerType()) {
            case PBS: {
                return new PBSJobConfiguration(templateFileName, ".pbs", resourceJobManager.getJobManagerBinPath(), resourceJobManager.getJobManagerCommands(), outputParser);
            }
            case SLURM: {
                return new SlurmJobConfiguration(templateFileName, ".slurm", resourceJobManager.getJobManagerBinPath(), resourceJobManager.getJobManagerCommands(), outputParser);
            }
            case LSF: {
                return new LSFJobConfiguration(templateFileName, ".lsf", resourceJobManager.getJobManagerBinPath(), resourceJobManager.getJobManagerCommands(), outputParser);
            }
            case UGE: {
                return new UGEJobConfiguration(templateFileName, ".pbs", resourceJobManager.getJobManagerBinPath(), resourceJobManager.getJobManagerCommands(), outputParser);
            }
            case FORK: {
                return new ForkJobConfiguration(templateFileName, ".sh", resourceJobManager.getJobManagerBinPath(), resourceJobManager.getJobManagerCommands(), outputParser);
            }
        }
        return null;
    }

    public static HostScheduler getHostScheduler() {
        return new DefaultHostScheduler();
    }

    public static RemoteCluster getJobSubmissionRemoteCluster(ProcessContext processContext) throws GFacException, AppCatalogException, AiravataException, CredentialStoreException {
        String computeResourceId = processContext.getComputeResourceId();
        JobSubmissionProtocol jobSubmissionProtocol = processContext.getJobSubmissionProtocol();
        String key = processContext.getComputeResourceLoginUserName() + ':' + jobSubmissionProtocol.name() + ':' + computeResourceId + ':' + processContext.getComputeResourceCredentialToken();
        Object remoteCluster = remoteClusterMap.get(key);
        if (remoteCluster == null) {
            JobManagerConfiguration jobManagerConfiguration = Factory.getJobManagerConfiguration(processContext.getResourceJobManager());
            if (jobSubmissionProtocol == JobSubmissionProtocol.LOCAL || jobSubmissionProtocol == JobSubmissionProtocol.LOCAL_FORK) {
                remoteCluster = new LocalRemoteCluster(processContext.getComputeResourceServerInfo(), jobManagerConfiguration, null);
            } else if (jobSubmissionProtocol == JobSubmissionProtocol.SSH || jobSubmissionProtocol == JobSubmissionProtocol.SSH_FORK || jobSubmissionProtocol == JobSubmissionProtocol.CLOUD) {
                remoteCluster = new HPCRemoteCluster(processContext.getComputeResourceServerInfo(), jobManagerConfiguration, (AuthenticationInfo)Factory.getComputerResourceSSHKeyAuthentication(processContext));
            } else {
                throw new GFacException("No remote cluster implementation map to job submission protocol " + jobSubmissionProtocol.name());
            }
            remoteClusterMap.put(key, (RemoteCluster)remoteCluster);
        } else {
            SSHKeyAuthentication sshKeyAuthentication;
            AuthenticationInfo authentication = remoteCluster.getAuthentication();
            if (authentication instanceof SSHKeyAuthentication && !(sshKeyAuthentication = (SSHKeyAuthentication)authentication).getUserName().equals(processContext.getComputeResourceLoginUserName())) {
                JobManagerConfiguration jobManagerConfiguration = Factory.getJobManagerConfiguration(processContext.getResourceJobManager());
                if (jobSubmissionProtocol == JobSubmissionProtocol.SSH || jobSubmissionProtocol == JobSubmissionProtocol.SSH_FORK) {
                    remoteCluster = new HPCRemoteCluster(processContext.getComputeResourceServerInfo(), jobManagerConfiguration, (AuthenticationInfo)Factory.getComputerResourceSSHKeyAuthentication(processContext));
                }
            }
        }
        return remoteCluster;
    }

    public static RemoteCluster getDataMovementRemoteCluster(ProcessContext processContext) throws GFacException, AiravataException, CredentialStoreException {
        String storageResourceId = processContext.getStorageResourceId();
        DataMovementProtocol dataMovementProtocol = processContext.getDataMovementProtocol();
        String key = processContext.getComputeResourceLoginUserName() + ':' + dataMovementProtocol.name() + ':' + storageResourceId + ":" + processContext.getStorageResourceCredentialToken();
        Object remoteCluster = remoteClusterMap.get(key);
        if (remoteCluster == null) {
            JobManagerConfiguration jobManagerConfiguration = Factory.getJobManagerConfiguration(processContext.getResourceJobManager());
            if (dataMovementProtocol == DataMovementProtocol.LOCAL) {
                remoteCluster = new LocalRemoteCluster(processContext.getStorageResourceServerInfo(), jobManagerConfiguration, null);
            } else if (dataMovementProtocol == DataMovementProtocol.SCP) {
                remoteCluster = new HPCRemoteCluster(processContext.getStorageResourceServerInfo(), jobManagerConfiguration, (AuthenticationInfo)Factory.getStorageSSHKeyAuthentication(processContext));
            } else {
                throw new GFacException("No remote cluster implementation map to job data movement protocol " + dataMovementProtocol.name());
            }
            remoteClusterMap.put(key, (RemoteCluster)remoteCluster);
        } else {
            SSHKeyAuthentication sshKeyAuthentication;
            AuthenticationInfo authentication = remoteCluster.getAuthentication();
            if (authentication instanceof SSHKeyAuthentication && !(sshKeyAuthentication = (SSHKeyAuthentication)authentication).getUserName().equals(processContext.getStorageResourceLoginUserName())) {
                JobManagerConfiguration jobManagerConfiguration = Factory.getJobManagerConfiguration(processContext.getResourceJobManager());
                dataMovementProtocol = processContext.getDataMovementProtocol();
                if (dataMovementProtocol == DataMovementProtocol.SCP) {
                    remoteCluster = new HPCRemoteCluster(processContext.getStorageResourceServerInfo(), jobManagerConfiguration, (AuthenticationInfo)Factory.getStorageSSHKeyAuthentication(processContext));
                }
            }
        }
        return remoteCluster;
    }

    public static SSHKeyAuthentication getComputerResourceSSHKeyAuthentication(ProcessContext pc) throws GFacException, CredentialStoreException {
        try {
            return Factory.getSshKeyAuthentication(pc.getGatewayId(), pc.getComputeResourceLoginUserName(), pc.getComputeResourceCredentialToken());
        }
        catch (IllegalAccessException | InstantiationException | ApplicationSettingsException e) {
            throw new GFacException("Couldn't build ssh authentication object", e);
        }
    }

    public static SSHKeyAuthentication getStorageSSHKeyAuthentication(ProcessContext pc) throws GFacException, CredentialStoreException {
        try {
            return Factory.getSshKeyAuthentication(pc.getGatewayId(), pc.getStorageResourceLoginUserName(), pc.getStorageResourceCredentialToken());
        }
        catch (IllegalAccessException | InstantiationException | ApplicationSettingsException e) {
            throw new GFacException("Couldn't build ssh authentication object", e);
        }
    }

    private static SSHKeyAuthentication getSshKeyAuthentication(String gatewayId, String loginUserName, String credentialStoreToken) throws ApplicationSettingsException, IllegalAccessException, InstantiationException, CredentialStoreException, GFacException {
        CredentialReader credentialReader = GFacUtils.getCredentialReader();
        Credential credential = credentialReader.getCredential(gatewayId, credentialStoreToken);
        if (credential instanceof SSHCredential) {
            SSHKeyAuthentication sshKA = new SSHKeyAuthentication();
            sshKA.setUserName(loginUserName);
            SSHCredential sshCredential = (SSHCredential)credential;
            sshKA.setPublicKey(sshCredential.getPublicKey());
            sshKA.setPrivateKey(sshCredential.getPrivateKey());
            sshKA.setPassphrase(sshCredential.getPassphrase());
            sshKA.setStrictHostKeyChecking("no");
            return sshKA;
        }
        String msg = "Provided credential store token is not valid. Please provide the correct credential store token";
        log.error(msg);
        throw new CredentialStoreException("Invalid credential store token:" + credentialStoreToken);
    }

    public static JobSubmissionTask getJobSubmissionTask(JobSubmissionProtocol jobSubmissionProtocol) {
        return jobSubmissionTask.get(jobSubmissionProtocol);
    }

    public static Task getDataMovementTask(DataMovementProtocol dataMovementProtocol) {
        return dataMovementTask.get(dataMovementProtocol);
    }

    public static ResourceConfig getResourceConfig(ResourceJobManagerType resourceJobManagerType) {
        return resources.get(resourceJobManagerType);
    }

    public static Map<ResourceJobManagerType, ResourceConfig> getResourceConfig() {
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JobMonitor getMonitorService(MonitorMode monitorMode) throws AiravataException, GFacException {
        JobMonitor jobMonitor = jobMonitorServices.get(monitorMode);
        if (jobMonitor != null) return jobMonitor;
        Class<JobMonitor> clazz = JobMonitor.class;
        synchronized (JobMonitor.class) {
            jobMonitor = jobMonitorServices.get(monitorMode);
            if (jobMonitor != null) return jobMonitor;
            switch (monitorMode) {
                case JOB_EMAIL_NOTIFICATION_MONITOR: {
                    EmailBasedMonitor emailBasedMonitor = new EmailBasedMonitor(Factory.getResourceConfig());
                    jobMonitorServices.put(MonitorMode.JOB_EMAIL_NOTIFICATION_MONITOR, emailBasedMonitor);
                    jobMonitor = emailBasedMonitor;
                    new Thread(emailBasedMonitor).start();
                    break;
                }
                case CLOUD_JOB_MONITOR: {
                    AuroraJobMonitor auroraJobMonitor = AuroraJobMonitor.getInstance();
                    new Thread(auroraJobMonitor).start();
                    jobMonitorServices.put(MonitorMode.CLOUD_JOB_MONITOR, auroraJobMonitor);
                    return auroraJobMonitor;
                }
                default: {
                    throw new GFacException("Unsupported monitor mode :" + monitorMode.name());
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return jobMonitor;
        }
    }

    public static JobMonitor getDefaultMonitorService() throws AiravataException, GFacException {
        return Factory.getMonitorService(MonitorMode.JOB_EMAIL_NOTIFICATION_MONITOR);
    }

    public static RedeliveryRequestWatcher getRedeliveryReqeustWatcher(String experimentId, String processId) {
        return new RedeliveryRequestWatcherImpl(experimentId, processId);
    }

    public static CancelRequestWatcher getCancelRequestWatcher(String experimentId, String processId) {
        return new CancelRequestWatcherImpl(experimentId, processId);
    }

    public static synchronized Session getSSHSession(AuthenticationInfo authenticationInfo, ServerInfo serverInfo) throws GFacException {
        if (authenticationInfo == null || serverInfo == null) {
            throw new IllegalArgumentException("Can't create ssh session, argument should be valid (not null)");
        }
        if (!(authenticationInfo instanceof SSHKeyAuthentication)) {
            throw new GFacException("Support ssh key authentication only");
        }
        SSHKeyAuthentication authentication = (SSHKeyAuthentication)authenticationInfo;
        String key = Factory.buildKey(serverInfo);
        Session session = (Session)sessionCache.getIfPresent((Object)key);
        boolean valid = Factory.isValidSession(session);
        if (valid) {
            log.info("SSH Session validation succeeded, key :" + key);
            valid = Factory.testChannelCreation(session);
            if (valid) {
                log.info("Channel creation test succeeded, key :" + key);
            } else {
                log.info("Channel creation test failed, key :" + key);
            }
        } else {
            log.info("Session validation failed, key :" + key);
        }
        if (!valid) {
            if (session != null) {
                log.info("Reinitialize a new SSH session for :" + key);
            } else {
                log.info("Initialize a new SSH session for :" + key);
            }
            try {
                JSch jSch = new JSch();
                jSch.addIdentity(UUID.randomUUID().toString(), authentication.getPrivateKey(), authentication.getPublicKey(), authentication.getPassphrase().getBytes());
                session = jSch.getSession(serverInfo.getUserName(), serverInfo.getHost(), serverInfo.getPort());
                session.setUserInfo((UserInfo)new DefaultUserInfo(serverInfo.getUserName(), null, authentication.getPassphrase()));
                if (authentication.getStrictHostKeyChecking().equals("yes")) {
                    jSch.setKnownHosts(authentication.getKnownHostsFilePath());
                } else {
                    session.setConfig("StrictHostKeyChecking", "no");
                }
                session.connect();
                sessionCache.put((Object)key, (Object)session);
            }
            catch (JSchException e) {
                throw new GFacException("JSch initialization error ", (Throwable)e);
            }
        } else {
            log.info("Reuse SSH session for :" + key);
        }
        return session;
    }

    private static String buildKey(ServerInfo serverInfo) {
        return serverInfo.getUserName() + "_" + serverInfo.getHost() + "_" + serverInfo.getPort() + "_" + serverInfo.getCredentialToken();
    }

    public static void disconnectSSHSession(ServerInfo serverInfo) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean testChannelCreation(Session session) {
        String command = "pwd ";
        Channel channel = null;
        try {
            channel = session.openChannel("exec");
            StandardOutReader stdOutReader = new StandardOutReader();
            ((ChannelExec)channel).setCommand(command);
            ((ChannelExec)channel).setErrStream(stdOutReader.getStandardError());
            channel.connect();
            stdOutReader.onOutput(channel);
        }
        catch (JSchException e) {
            log.error("Test Channel creation failed.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (channel != null) {
                channel.disconnect();
            }
        }
        return true;
    }

    private static boolean isValidSession(Session session) {
        return session != null && session.isConnected();
    }

    public static Task getArchiveTask() {
        return new ArchiveTask();
    }

    static {
        remoteClusterMap = new HashMap<String, RemoteCluster>();
        jobSubmissionTask = new HashMap<JobSubmissionProtocol, JobSubmissionTask>();
        dataMovementTask = new HashMap<DataMovementProtocol, Task>();
        resources = new HashMap<ResourceJobManagerType, ResourceConfig>();
        jobMonitorServices = new HashMap<MonitorMode, JobMonitor>();
        sessionMap = new HashMap<String, Session>();
    }

    private static class DefaultUserInfo
    implements UserInfo,
    UIKeyboardInteractive {
        private String userName;
        private String password;
        private String passphrase;

        public DefaultUserInfo(String userName, String password, String passphrase) {
            this.userName = userName;
            this.password = password;
            this.passphrase = passphrase;
        }

        public String getPassphrase() {
            return null;
        }

        public String getPassword() {
            return null;
        }

        public boolean promptPassword(String s) {
            return false;
        }

        public boolean promptPassphrase(String s) {
            return false;
        }

        public boolean promptYesNo(String s) {
            return false;
        }

        public void showMessage(String s) {
        }

        public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
            return new String[0];
        }
    }
}

