/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.proxy;

import eu.emi.security.authn.x509.X509Credential;
import eu.emi.security.authn.x509.impl.KeyAndCertCredential;
import eu.emi.security.authn.x509.proxy.ProxyCertificate;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;

public class ProxyCertificateImpl
implements ProxyCertificate {
    private X509Certificate[] chain;
    private PrivateKey privateKey;
    private X509Credential credential;

    public ProxyCertificateImpl(X509Certificate[] chain, PrivateKey privateKey) throws KeyStoreException {
        this.chain = chain;
        this.privateKey = privateKey;
        this.credential = new KeyAndCertCredential(privateKey, chain);
    }

    public ProxyCertificateImpl(X509Certificate[] chain) {
        this.chain = chain;
    }

    @Override
    public X509Certificate[] getCertificateChain() {
        return this.chain;
    }

    @Override
    public PrivateKey getPrivateKey() throws IllegalStateException {
        if (this.privateKey == null) {
            throw new IllegalStateException("Private key was not generated for this proxy");
        }
        return this.privateKey;
    }

    @Override
    public X509Credential getCredential() throws IllegalStateException {
        if (this.privateKey == null) {
            throw new IllegalStateException("Private key was not generated for this proxy");
        }
        return this.credential;
    }

    @Override
    public boolean hasPrivateKey() {
        return this.privateKey != null;
    }
}

