/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.ssl;

import eu.emi.security.authn.x509.ValidationResult;
import eu.emi.security.authn.x509.X509CertChainValidator;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;

public class SSLTrustManager
implements X509TrustManager {
    protected X509CertChainValidator validator;

    public SSLTrustManager(X509CertChainValidator validator) {
        this.validator = validator;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.checkIfTrusted(chain);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.checkIfTrusted(chain);
    }

    protected void checkIfTrusted(X509Certificate[] certChain) throws CertificateException {
        ValidationResult result = this.validator.validate(certChain);
        if (!result.isValid()) {
            result.toString();
            String subject = "";
            if (certChain != null && certChain.length > 0) {
                subject = certChain[0].getSubjectX500Principal().getName();
            }
            throw new CertificateException("The peer's certificate with subject's DN " + subject + " was rejected. The peer's certificate status is: " + result.toString());
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.validator.getTrustedIssuers();
    }
}

