/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.rds.model.DBInstance;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeDBInstancesResult
implements Serializable {
    private String marker;
    private ListWithAutoConstructFlag<DBInstance> dBInstances;

    public String getMarker() {
        return this.marker;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public DescribeDBInstancesResult withMarker(String marker) {
        this.marker = marker;
        return this;
    }

    public List<DBInstance> getDBInstances() {
        if (this.dBInstances == null) {
            this.dBInstances = new ListWithAutoConstructFlag();
            this.dBInstances.setAutoConstruct(true);
        }
        return this.dBInstances;
    }

    public void setDBInstances(Collection<DBInstance> dBInstances) {
        if (dBInstances == null) {
            this.dBInstances = null;
            return;
        }
        ListWithAutoConstructFlag dBInstancesCopy = new ListWithAutoConstructFlag(dBInstances.size());
        dBInstancesCopy.addAll(dBInstances);
        this.dBInstances = dBInstancesCopy;
    }

    public DescribeDBInstancesResult withDBInstances(DBInstance ... dBInstances) {
        if (this.getDBInstances() == null) {
            this.setDBInstances(new ArrayList<DBInstance>(dBInstances.length));
        }
        for (DBInstance value : dBInstances) {
            this.getDBInstances().add(value);
        }
        return this;
    }

    public DescribeDBInstancesResult withDBInstances(Collection<DBInstance> dBInstances) {
        if (dBInstances == null) {
            this.dBInstances = null;
        } else {
            ListWithAutoConstructFlag dBInstancesCopy = new ListWithAutoConstructFlag(dBInstances.size());
            dBInstancesCopy.addAll(dBInstances);
            this.dBInstances = dBInstancesCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMarker() != null) {
            sb.append("Marker: " + this.getMarker() + ",");
        }
        if (this.getDBInstances() != null) {
            sb.append("DBInstances: " + this.getDBInstances());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        hashCode = 31 * hashCode + (this.getDBInstances() == null ? 0 : this.getDBInstances().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDBInstancesResult)) {
            return false;
        }
        DescribeDBInstancesResult other = (DescribeDBInstancesResult)obj;
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        if (other.getMarker() != null && !other.getMarker().equals(this.getMarker())) {
            return false;
        }
        if (other.getDBInstances() == null ^ this.getDBInstances() == null) {
            return false;
        }
        return other.getDBInstances() == null || other.getDBInstances().equals(this.getDBInstances());
    }
}

