/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.stores;

import java.io.IOException;
import java.net.URI;
import java.security.InvalidAlgorithmParameterException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.SigningPolicy;
import org.globus.gsi.provider.SigningPolicyStore;
import org.globus.gsi.provider.SigningPolicyStoreException;
import org.globus.gsi.provider.SigningPolicyStoreParameters;
import org.globus.gsi.stores.ResourceSigningPolicy;
import org.globus.gsi.stores.ResourceSigningPolicyStoreParameters;
import org.globus.gsi.stores.ResourceStoreException;
import org.globus.gsi.util.CertificateIOUtil;
import org.globus.util.GlobusPathMatchingResourcePatternResolver;
import org.globus.util.GlobusResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceSigningPolicyStore
implements SigningPolicyStore {
    private Map<URI, ResourceSigningPolicy> signingPolicyFileMap = new HashMap<URI, ResourceSigningPolicy>();
    private Map<String, SigningPolicy> policyMap = new HashMap<String, SigningPolicy>();
    private ResourceSigningPolicyStoreParameters parameters;
    private static final Log logger = LogFactory.getLog((String)ResourceSigningPolicyStore.class.getCanonicalName());
    private final Map<String, Long> invalidPoliciesCache = new HashMap<String, Long>();
    private final Map<String, Long> validPoliciesCache = new HashMap<String, Long>();
    private static final long CACHE_TIME_MILLIS = 3600000L;

    public ResourceSigningPolicyStore(SigningPolicyStoreParameters param) throws InvalidAlgorithmParameterException {
        if (param == null) {
            throw new IllegalArgumentException();
        }
        if (!(param instanceof ResourceSigningPolicyStoreParameters)) {
            throw new InvalidAlgorithmParameterException();
        }
        this.parameters = (ResourceSigningPolicyStoreParameters)param;
    }

    @Override
    public synchronized SigningPolicy getSigningPolicy(X500Principal caPrincipal) throws SigningPolicyStoreException {
        if (caPrincipal == null) {
            return null;
        }
        String caPrincipalName = caPrincipal.getName();
        long now = System.currentTimeMillis();
        String hash = CertificateIOUtil.nameHash(caPrincipal);
        Long validCacheTime = this.validPoliciesCache.get(caPrincipalName);
        Long invalidCacheTime = this.invalidPoliciesCache.get(caPrincipalName);
        if (invalidCacheTime != null && now - invalidCacheTime < 36000000L) {
            return null;
        }
        if (validCacheTime == null || now - validCacheTime >= 3600000L || !this.policyMap.containsKey(caPrincipalName)) {
            this.loadPolicy(hash, caPrincipalName);
        }
        return this.policyMap.get(caPrincipalName);
    }

    private synchronized void loadPolicy(String hash, String caPrincipalName) throws SigningPolicyStoreException {
        String locations = this.parameters.getTrustRootLocations();
        GlobusResource[] resources = new GlobusPathMatchingResourcePatternResolver().getResources(locations);
        long now = System.currentTimeMillis();
        boolean found_policy = false;
        for (GlobusResource resource : resources) {
            String filename = resource.getFilename();
            if (!filename.startsWith(hash) || !this.loadSigningPolicy(resource, this.policyMap, this.signingPolicyFileMap, now)) continue;
            found_policy = true;
        }
        if (!found_policy) {
            for (GlobusResource resource : resources) {
                this.loadSigningPolicy(resource, this.policyMap, this.signingPolicyFileMap, now);
            }
        }
        if (!this.validPoliciesCache.containsKey(caPrincipalName)) {
            this.invalidPoliciesCache.put(caPrincipalName, now);
        }
    }

    private boolean loadSigningPolicy(GlobusResource policyResource, Map<String, SigningPolicy> policyMapToLoad, Map<URI, ResourceSigningPolicy> currentPolicyFileMap, long currentMillis) {
        boolean loaded;
        block11: {
            String filename = policyResource.getFilename();
            long now = currentMillis;
            loaded = false;
            Long invalidCacheTime = this.invalidPoliciesCache.get(filename);
            if (invalidCacheTime != null && now - invalidCacheTime < 36000000L) {
                return false;
            }
            try {
                URI uri;
                if (!policyResource.isReadable()) {
                    throw new SigningPolicyStoreException("file is not readable");
                }
                try {
                    uri = policyResource.getURI();
                }
                catch (IOException e) {
                    throw new SigningPolicyStoreException(e);
                }
                ResourceSigningPolicy filePolicy = this.signingPolicyFileMap.get(uri);
                if (filePolicy == null) {
                    try {
                        filePolicy = new ResourceSigningPolicy(policyResource);
                    }
                    catch (ResourceStoreException e) {
                        throw new SigningPolicyStoreException(e);
                    }
                }
                Collection<SigningPolicy> policies = filePolicy.getSigningPolicies();
                currentPolicyFileMap.put(uri, filePolicy);
                if (policies != null) {
                    for (SigningPolicy policy : policies) {
                        X500Principal caPrincipal = policy.getCASubjectDN();
                        policyMapToLoad.put(caPrincipal.getName(), policy);
                        this.validPoliciesCache.put(caPrincipal.getName(), now);
                    }
                }
                loaded = true;
            }
            catch (SigningPolicyStoreException e) {
                if (invalidCacheTime != null && now - invalidCacheTime < 36000000L) break block11;
                logger.warn((Object)("Failed to load signing policy: " + filename + " : " + e.getMessage()));
                logger.debug((Object)("Failed to load signing policy: " + filename), (Throwable)e);
                this.invalidPoliciesCache.put(filename, now);
            }
        }
        return loaded;
    }
}

