/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.app;

import java.util.HashMap;
import java.util.Map;
import org.wso2.carbon.registry.core.Resource;

public class CachedResources {
    private Map<String, Resource> resources = new HashMap<String, Resource>();
    private Map<String, String> eTags = new HashMap<String, String>();

    public boolean isResourceCached(String path) {
        return !this.resources.isEmpty() && this.resources.containsKey(path);
    }

    public boolean cacheResource(String path, Resource resource, String eTag, long size) {
        if (this.resources.get(path) != null && (long)this.getSizeOfCache() <= size) {
            this.resources.put(path, resource);
            this.eTags.put(path, eTag);
            return true;
        }
        return false;
    }

    public Resource getCachedResource(String path) {
        return this.resources.get(path);
    }

    public String getETag(String path) {
        return this.eTags.get(path);
    }

    public int getSizeOfCache() {
        return this.resources.size();
    }
}

