/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.client.secure.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import javax.net.ssl.SSLContext;
import org.apache.airavata.client.secure.client.Properties;
import org.apache.airavata.security.AiravataSecurityException;
import org.apache.airavata.security.util.TrustStoreManager;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class OAuthTokenRetrievalClient {
    public String retrieveAccessToken(String consumerId, String consumerSecret, String userName, String password, int grantType) throws AiravataSecurityException {
        HttpPost postMethod = null;
        try {
            TrustStoreManager trustStoreManager = new TrustStoreManager();
            SSLContext sslContext = trustStoreManager.initializeTrustStoreManager("../../../../../airavata/modules/configuration/server/src/main/resources/client_truststore.jks", "airavata");
            SSLSocketFactory sf = new SSLSocketFactory(sslContext);
            Scheme httpsScheme = new Scheme("https", (SocketFactory)sf, Properties.authzServerPort);
            DefaultHttpClient httpClient = new DefaultHttpClient();
            httpClient.getConnectionManager().getSchemeRegistry().register(httpsScheme);
            postMethod = new HttpPost(Properties.oauthTokenEndPointURL);
            String authInfo = consumerId + ":" + consumerSecret;
            String authHeader = new String(Base64.encodeBase64((byte[])authInfo.getBytes()));
            postMethod.setHeader("Content-Type", "application/x-www-form-urlencoded");
            postMethod.setHeader("Authorization", "Basic " + authHeader);
            ArrayList<BasicNameValuePair> urlParameters = new ArrayList<BasicNameValuePair>();
            if (grantType == 1) {
                urlParameters.add(new BasicNameValuePair("grant_type", "password"));
                urlParameters.add(new BasicNameValuePair("username", userName));
                urlParameters.add(new BasicNameValuePair("password", password));
            } else if (grantType == 2) {
                urlParameters.add(new BasicNameValuePair("grant_type", "client_credentials"));
            }
            postMethod.setEntity((HttpEntity)new UrlEncodedFormEntity(urlParameters));
            HttpResponse response = httpClient.execute((HttpUriRequest)postMethod);
            BufferedReader rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            StringBuilder result = new StringBuilder();
            String line = "";
            while ((line = rd.readLine()) != null) {
                result.append(line);
            }
            JSONParser parser = new JSONParser();
            JSONObject jsonObject = (JSONObject)parser.parse(result.toString());
            String string = (String)jsonObject.get((Object)"access_token");
            return string;
        }
        catch (ClientProtocolException e) {
            throw new AiravataSecurityException(e.getMessage(), (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new AiravataSecurityException(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new AiravataSecurityException(e.getMessage(), (Throwable)e);
        }
        catch (ParseException e) {
            throw new AiravataSecurityException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (postMethod != null) {
                postMethod.releaseConnection();
            }
        }
    }
}

