/*
 * Decompiled with CFR 0.152.
 */
package org.kosmix.kosmosfs.access;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Properties;
import org.kosmix.kosmosfs.access.KfsFileAttr;
import org.kosmix.kosmosfs.access.KfsInputChannel;
import org.kosmix.kosmosfs.access.KfsOutputChannel;

public class KfsAccess {
    private long cPtr;

    private static final native long initF(String var0);

    private static final native long initS(String var0, int var1);

    private static final native int cd(long var0, String var2);

    private static final native int mkdirs(long var0, String var2);

    private static final native int rmdir(long var0, String var2);

    private static final native int rmdirs(long var0, String var2);

    private static final native String[] readdir(long var0, String var2, boolean var3);

    private static final native String[] readdirplus(long var0, String var2);

    private static final native String[][] getDataLocation(long var0, String var2, long var3, long var5);

    private static final native short getReplication(long var0, String var2);

    private static final native short setReplication(long var0, String var2, int var3);

    private static final native long getModificationTime(long var0, String var2);

    private static final native int create(long var0, String var2, int var3, boolean var4);

    private static final native int remove(long var0, String var2);

    private static final native int rename(long var0, String var2, String var3, boolean var4);

    private static final native int open(long var0, String var2, String var3, int var4);

    private static final native int exists(long var0, String var2);

    private static final native int isFile(long var0, String var2);

    private static final native int isDirectory(long var0, String var2);

    private static final native long filesize(long var0, String var2);

    public static final native long setDefaultIoBufferSize(long var0);

    public static final native long getDefaultIoBufferSize();

    public static final native long setDefaultReadAheadSize(long var0);

    public static final native long getDefaultReadAheadSize();

    private static final native long setIoBufferSize(int var0, long var1);

    private static final native long getIoBufferSize(int var0);

    private static final native long setReadAheadSize(int var0, long var1);

    private static final native long getReadAheadSize(int var0);

    public KfsAccess(String configFn) throws IOException {
        this.cPtr = KfsAccess.initF(configFn);
        if (this.cPtr == 0L) {
            throw new IOException("Unable to initialize KFS Client");
        }
    }

    public KfsAccess(String metaServerHost, int metaServerPort) throws IOException {
        this.cPtr = KfsAccess.initS(metaServerHost, metaServerPort);
        if (this.cPtr == 0L) {
            throw new IOException("Unable to initialize KFS Client");
        }
    }

    public int kfs_cd(String path) {
        return KfsAccess.cd(this.cPtr, path);
    }

    public int kfs_mkdirs(String path) {
        return KfsAccess.mkdirs(this.cPtr, path);
    }

    public int kfs_rmdir(String path) {
        return KfsAccess.rmdir(this.cPtr, path);
    }

    public int kfs_rmdirs(String path) {
        return KfsAccess.rmdirs(this.cPtr, path);
    }

    public String[] kfs_readdir(String path) {
        return this.kfs_readdir(path, false);
    }

    public String[] kfs_readdir(String path, boolean prefetchAttr) {
        return KfsAccess.readdir(this.cPtr, path, prefetchAttr);
    }

    public KfsFileAttr[] kfs_readdirplus(String path) {
        String[] entries = KfsAccess.readdirplus(this.cPtr, path);
        if (entries == null) {
            return null;
        }
        KfsFileAttr[] fattr = new KfsFileAttr[entries.length];
        for (int i = 0; i < entries.length; ++i) {
            byte[] arr = entries[i].getBytes();
            ByteArrayInputStream bis = new ByteArrayInputStream(arr);
            Properties prop = new Properties();
            try {
                prop.load(bis);
                fattr[i] = new KfsFileAttr();
                fattr[i].filename = prop.getProperty("Filename", "");
                String s = prop.getProperty("IsDirectory", "false");
                fattr[i].isDirectory = s.startsWith("true");
                s = prop.getProperty("Filesize", "0");
                fattr[i].filesize = Long.parseLong(s);
                s = prop.getProperty("M-Time", "0");
                fattr[i].modificationTime = Long.parseLong(s);
                s = prop.getProperty("Replicas", "1");
                fattr[i].replication = Integer.parseInt(s);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                fattr[i] = null;
            }
        }
        return fattr;
    }

    public KfsOutputChannel kfs_append(String path) {
        int fd = KfsAccess.open(this.cPtr, path, "a", 1);
        if (fd < 0) {
            return null;
        }
        return new KfsOutputChannel(this.cPtr, fd);
    }

    public KfsOutputChannel kfs_create(String path) {
        return this.kfs_create(path, 1);
    }

    public KfsOutputChannel kfs_create(String path, int numReplicas) {
        return this.kfs_create(path, numReplicas, false);
    }

    public KfsOutputChannel kfs_create(String path, int numReplicas, boolean exclusive) {
        int fd = KfsAccess.create(this.cPtr, path, numReplicas, exclusive);
        if (fd < 0) {
            return null;
        }
        return new KfsOutputChannel(this.cPtr, fd);
    }

    public KfsOutputChannel kfs_create(String path, int numReplicas, boolean exclusive, long bufferSize, long readAheadSize) {
        int fd = KfsAccess.create(this.cPtr, path, numReplicas, exclusive);
        if (fd < 0) {
            return null;
        }
        if (bufferSize >= 0L) {
            KfsAccess.setIoBufferSize(fd, bufferSize);
        }
        if (readAheadSize >= 0L) {
            KfsAccess.setReadAheadSize(fd, readAheadSize);
        }
        return new KfsOutputChannel(this.cPtr, fd);
    }

    public KfsInputChannel kfs_open(String path) {
        int fd = KfsAccess.open(this.cPtr, path, "r", 1);
        if (fd < 0) {
            return null;
        }
        return new KfsInputChannel(this.cPtr, fd);
    }

    public KfsInputChannel kfs_open(String path, long bufferSize, long readAheadSize) {
        int fd = KfsAccess.open(this.cPtr, path, "r", 1);
        if (fd < 0) {
            return null;
        }
        if (bufferSize >= 0L) {
            KfsAccess.setIoBufferSize(fd, bufferSize);
        }
        if (readAheadSize >= 0L) {
            KfsAccess.setReadAheadSize(fd, readAheadSize);
        }
        return new KfsInputChannel(this.cPtr, fd);
    }

    public int kfs_remove(String path) {
        return KfsAccess.remove(this.cPtr, path);
    }

    public int kfs_rename(String oldpath, String newpath) {
        return KfsAccess.rename(this.cPtr, oldpath, newpath, true);
    }

    public int kfs_rename(String oldpath, String newpath, boolean overwrite) {
        return KfsAccess.rename(this.cPtr, oldpath, newpath, overwrite);
    }

    public boolean kfs_exists(String path) {
        return KfsAccess.exists(this.cPtr, path) == 1;
    }

    public boolean kfs_isFile(String path) {
        return KfsAccess.isFile(this.cPtr, path) == 1;
    }

    public boolean kfs_isDirectory(String path) {
        return KfsAccess.isDirectory(this.cPtr, path) == 1;
    }

    public long kfs_filesize(String path) {
        return KfsAccess.filesize(this.cPtr, path);
    }

    public String[][] kfs_getDataLocation(String path, long start, long len) {
        return KfsAccess.getDataLocation(this.cPtr, path, start, len);
    }

    public short kfs_getReplication(String path) {
        return KfsAccess.getReplication(this.cPtr, path);
    }

    public short kfs_setReplication(String path, int numReplicas) {
        return KfsAccess.setReplication(this.cPtr, path, numReplicas);
    }

    public long kfs_getModificationTime(String path) {
        return KfsAccess.getModificationTime(this.cPtr, path);
    }

    protected void finalize() throws Throwable {
        this.release();
        super.finalize();
    }

    public void release() {
        if (this.cPtr != 0L) {
            // empty if block
        }
    }

    static {
        try {
            System.loadLibrary("kfs_access");
        }
        catch (UnsatisfiedLinkError e) {
            e.printStackTrace();
            System.err.println("Unable to load kfs_access native library");
            System.exit(1);
        }
    }
}

